<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Utils\ReporteLayout;

/**
 * Description of BackendProfesorController
 *
 * @author jose
 */

class BackendProfesorController extends Controller {
    
    public function includeHeadProfAction(){
        $datenow = new \DateTime();
        return $this->render('AppBundle:BackendProfesores:includes/head.html.twig', array('datenow'=>$datenow));
    }
    
    public function includeAsideLeftProfAction()
    {
        return $this->render('AppBundle:BackendProfesores:includes/aside_left.html.twig', array());
    }
    
    /**
     * @Route("/app/backend/profesor/index", name="app_homepage_profesor")
     */
    public function indexAction(){
        $entity = $this->getUser()->getSede()->getCodigo();
        $this->get('session')->set('em', $entity);
        $this->get('session')->set('cedulaprof', $this->getUser()->getCedula());
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $datosProf = $em->getRepository('AppBundle:Profesor')->findOneBy(array('cedula'=>  $this->get('session')->get('cedulaprof')));        
        $lapsoActual = $em->getRepository('AppBundle:Lapso')->findOneBy(array('activo'=>1));
        
        
        
        $this->get('session')->set('datosProf', $datosProf);
        $this->get('session')->set('lapsoActual', $lapsoActual);
        
        return $this->render('AppBundle:BackendProfesores:views/index.html.twig', array(            
            
        ));
    }
    
    /**
     * @Route("/app/backend/profesor/transcripcion", name="app_backend_profesor_transcripcion")
     */
    public function cursosTranscripcionAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $lapsoAc = $this->get('session')->get('lapsoActual');
        $profesor = $this->get('session')->get('datosProf');
        
        $cursosTransc = $em->getRepository('AppBundle:OfertAcade')->findCursoTransNew($profesor, $lapsoAc);
        if(!$cursosTransc)
        {
            $this->get('session')->getFlashBag()->add('msg-errror', 'No tiene curso asignados!');
            return $this->redirect($this->generateUrl('app_homepage_profesor'));
        }
        if($request->get('id')!==null)
        {
            $id = $request->get('id');
            $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
            $curso = $oferta->getCurso();
            $cursoEspecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
            $entities = $em->getRepository('AppBundle:Matricula')->findAlumnosByCursoA($oferta);
            $condiciones = $em->getRepository('AppBundle:CondCurso')->findBy(array('codigo'=>array('APR', 'APLZ', 'PROC')));
            return $this->render('AppBundle:BackendProfesores:views/transcripcion/index.html.twig', array(
                'entities'=>$cursosTransc,
                'matricula'=>$entities, 
                'cursoisEspecial'=>$cursoEspecial,
                'conditions'=>$condiciones
            ));
        }
        
        return $this->render('AppBundle:BackendProfesores:views/transcripcion/index.html.twig', array(
            'entities'=>$cursosTransc
        ));
    }
    
    /**
     * @Route("/app/backend/profesor/process/transcripcion", name="app_backend_profesor_process_transcripcion")
     */
    public function procesarTranscripcion(Request $request)
    {
        $reqMatricula = $request->get('matricula');
        $reqNotas= $request->get('notas');
        $oferta_id = $request->get('ofertaid');
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $conditionAprob = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'APR'));
        $conditionAplz  = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'APLZ'));
        $conditionProc  = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'PROC'));
        $oferta         = $em->getRepository('AppBundle:OfertAcade')->find($oferta_id);
        $curso          = $oferta->getCurso();
        $cursoEspecial  = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
        $cualitativo = false;
        if($cursoEspecial)
            if($cursoEspecial->getModoTranscripcion()->getDescripcion()=='Cualitativo')
                $cualitativo = true;
            
        
        if(!$oferta)
            throw new Exception ("Oferta no encontrada");


        for ($i = 0; $i<count($reqMatricula); $i++)
        {
            $idM =  $reqMatricula[$i];
            $matricula = $em->getRepository('AppBundle:Matricula')->find($idM);
            if(!$matricula)
                throw new Exception ('No se encontro matricula señalada !!');
            $nota = $reqNotas[$i];
            $matricula->setNota($nota);
            if(!$cualitativo){
                if($nota>=6)
                    $matricula->setCondicion($conditionAprob);
                elseif($nota<6)
                    $matricula->setCondicion($conditionAplz);
            }else{
                $condition = $em->getRepository('AppBundle:CondCurso')->find($nota);
                $matricula->setCondicion($condition);
            }
            $em->persist($matricula);
            
            //ACTUALIZAR HIST_MATRI
            $histExist = $em->getRepository('AppBundle:HistMatri')->findOneByMatricula($matricula->getId());
            if(!$histExist)
            {
                $newHistMatri = new \AppBundle\Entity\HistMatri();
                $newHistMatri->setMatricula($matricula);
                $newHistMatri->setCondicion($matricula->getCondicion());
                $newHistMatri->setCurso($matricula->getOferta()->getCurso());
                $newHistMatri->setEspecialidad($matricula->getEstudiante()->getEspecialidad());
                $newHistMatri->setEstudiante($matricula->getEstudiante());
                $newHistMatri->setLapso($matricula->getOferta()->getLapso());
                $newHistMatri->setNota($matricula->getNota());
                $newHistMatri->setObs('Pasado Matricula '.$matricula->getOferta()->getLapso()->getCodigo());
                $newHistMatri->setPrograma($matricula->getOferta()->getPrograma());
                $newHistMatri->setSede($matricula->getOferta()->getSede());
                $newHistMatri->setUc($matricula->getOferta()->getCurso()->getUc());
                $newHistMatri->setSeccion($matricula->getOferta()->getSeccion());
                $em->persist($newHistMatri);
            }else{
                $histExist->setMatricula($matricula);
                $histExist->setCondicion($matricula->getCondicion());
                $histExist->setCurso($matricula->getOferta()->getCurso());
                $histExist->setEspecialidad($matricula->getEstudiante()->getEspecialidad());
                $histExist->setEstudiante($matricula->getEstudiante());
                $histExist->setLapso($matricula->getOferta()->getLapso());
                $histExist->setNota($matricula->getNota());
                $histExist->setObs('Pasado Matricula '.$matricula->getOferta()->getLapso()->getCodigo());
                $histExist->setPrograma($matricula->getOferta()->getPrograma());
                $histExist->setSede($matricula->getOferta()->getSede());
                $histExist->setUc($matricula->getOferta()->getCurso()->getUc());
                $histExist->setSeccion($matricula->getOferta()->getSeccion());
                $em->persist($histExist);
            }
        }
        
        $oferta->setFechaTrans(new \DateTime());
        $em->persist($oferta);
        
        $em->flush();
        
        $this->get('session')->getFlashBag()->add('msg-success', 'Datos guardadados con exito !');
        return $this->redirect($this->generateUrl('app_backend_profesor_transcripcion', array('id'=>$oferta->getId())));
    }
    
    /**
     * @Route("/app/backend/profesor/reportes/acta/{id}", name="app_backend_profesor_reporte_acta")
     */
    public function reportListadoClasesAction($id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $curso          = $oferta->getCurso();
        $cursoEspecial  = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
        $cualitativo = false;
        if($cursoEspecial)
            if($cursoEspecial->getModoTranscripcion()->getDescripcion()=='Cualitativo')
                $cualitativo = true;
        
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesByOferta($oferta);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->setActa($oferta->getNumeroActa());
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(10,20,60,60,10,30));
        $pdf->SetAligns(array('C','C','L', 'L', 'C', 'L'));
        //srand(microtime()*1000000);
        
        $headerPage = array('Programa'=>$oferta->getPrograma(), 'Especialidad'=>$oferta->getEspecialidad(),
            'Curso'=>$oferta->getCurso(), 'Sección'=>$oferta->getSeccion(), 'Lapso'=>$oferta->getLapso());
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Acta de transcripción');
        
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('#','Cédula', 'Nombre', 'Apellidos', 'Nota','Condicion');
        $pdf->RowTitles($titles);
        
        
        $index = 1;
        $aplaz = 0;
        $aprob = 0;
        $proc = 0;
        foreach ($entities as $value){
            $nota = ($cualitativo) ? '':$value->getNota();
           
            $pdf->RowBorders(array($index,
                    $value->getEstudiante()->getEstudiante()->getCedula(),
                    $value->getEstudiante()->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getEstudiante()->getSegundoNombre(),
                    $value->getEstudiante()->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getEstudiante()->getSegundoApellido(),
                    $nota,
                    $value->getCondicion(),
             ), 0);
            if($value->getCondicion()->getCodigo()=='APLZ'){
                $aplaz++;
            }elseif($value->getCondicion()->getCodigo()=='APR'){
                $aprob++;
            }elseif($value->getCondicion()->getCodigo()=='PROC'){
                $proc++;
            }
            
            $index++;
        }  
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(($cualitativo)? 47.5: 63, 6,'Total estudiantes: '.count($entities), 'T',0,'C');
        $pdf->Cell(($cualitativo)? 47.5: 63, 6,'Total Aprobados: '.$aprob, 'T',0,'C');
        $pdf->Cell(($cualitativo)? 47.5: 64, 6,'Total Aplazado: '.($aplaz), 'T',0,'C');
        if($cualitativo)
            $pdf->Cell(47.5, 6,'Total En Proceso: '.($proc), 'T',1,'C');
        
        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    
}
