<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Description of ConfigSistema
 *
 * @author jose
 */
class ConfigSistemaController extends Controller {
    
    /**
     * @Route("/app/admin/config/sistema", name="app_admin_config_sistema_index")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $configuraciones = $em->getRepository('AppBundle:ConfigSistema')->findAll();
        
        return $this->render('AppBundle:ConfigProgramas:index.html.twig', array('configuraciones'=>$configuraciones));
    }
    
    
    /**
     * @Route("/app/admin/show/config/sistema/{id}", name="app_admin_config_sistema_programa")
     */
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $config = $em->getRepository('AppBundle:ConfigSistema')->find($id);
        
        return $this->render('AppBundle:ConfigProgramas:show.html.twig', array('config'=>$config));
    }
    
    /**
     * @Route("/app/admin/save/config/sistema/{id}", name="app_admin_config_sistema_save")
     */
    public function saveChangeAction($id, Request $request)
    {        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $config = $em->getRepository('AppBundle:ConfigSistema')->find($id);
        $status = $request->get('check') ? 1 : 0 ;
        $config->setControlpago($status);
        $cuota1 = $request->get('porc1ercuota') ? $request->get('porc1ercuota'): 0;
        $config->setCuota1($cuota1);
        $cuota2 = $request->get('porc2dacuota') ? $request->get('porc2dacuota'): 0;
        $config->setCuota2($cuota2);
        $cuota3 = $request->get('porc3eracuota') ? $request->get('porc3eracuota'): 0;
        $config->setCuota3($cuota3);
        $choque = $request->get('choque') ? 1 : 0 ;
        $config->setChoque($choque);
        $config->setMontouc($request->get('montouc'));
        $config->setPorcentajeuc($request->get('porcentajeuc'));
        $config->setUcMin($request->get('ucmin'));
        $config->setUcMax($request->get('ucmax'));
        $em->persist($config);
            
        $em->flush();       
        $this->get('session')->getFlashBag()->add('msg-success', 'Configuración guardada con exito.!!');
        return $this->redirect($this->generateUrl('app_admin_config_sistema_programa', array('id'=>$id)));
        
    }
}
