<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Depositos;
use AppBundle\Form\DepositosType;

/**
 * Description of DepositosController
 *
 * @author jose
 */
class DepositosController extends Controller {
    
    /**
     * @Route("/app/admin/depositos", name="app_admin_alumn_depositos")
     */
    public function indexAction()
    {
        $form = $this->formSearchEstudiante();
        return $this->render('AppBundle:Depositos:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }    
    
    private function formSearchEstudiante()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_alumn_deposito_search'))
                ->setMethod('GET')
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/deposito/search/estudiante", name="app_admin_alumn_deposito_search", requirements={"_method":"GET"})
     */
    public function searchEstudiantesAction(Request $request)
    {
        $form = $this->formSearchEstudiante();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
            $lapsos = $em->getRepository('AppBundle:Lapso')->findBySede($sede);
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_admin_alumn_exoneracion'));
            }
            
            return $this->render('AppBundle:Depositos:result.html.twig', array(
                'datos'=>$estudiante,
                'lapsos'=>$lapsos
            ));
        }
        
        return $this->render('AppBundle:Exoneracion:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/depositos", name="app_depositos_index")
     */
    public function depositosAction(Request $request){
        
        $entity = new Depositos();
        $especialidad = $request->get('especialidad');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $form = $this->formDepositoEstudiante($em,$entity, $request->get('especialidad'), $request->get('lapso'));
        $lapsoac = $em->getRepository('AppBundle:Lapso')->find($request->get('lapso'));
        
        if($request->getMethod() == 'POST')
        {
            $form->handleRequest($request);
            
            if($form->isValid())
            {
                $directorio = $this->container->getParameter('directorio.imagenes.baucher');
                $entity->subirFotoBauche($directorio);                
                $lapso = $em->getRepository('AppBundle:Lapso')->find($form['lapso']->getData());
                $entity->setLapso($lapso);
                
                $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($form['id']->getData());
                $entity->setEstudiante($espeestud);
                $condde = $em->getRepository('AppBundle:CondDepositos')->findOneBy(array('descripcion'=>'Deposito'));
                $entity->setConddepositos($condde);
                $em->persist($entity);
                $em->flush();
                
                $this->get('session')->getFlashBag()->add('msg-success', 'Registro insertado con exito!!');
                return $this->redirect($this->generateUrl('app_depositos_index', array(
                    'especialidad'=>$request->get('especialidad'),
                    'lapso'=>$request->get('lapso')
                )));
                
            }
        }
        
        $depositosAnt = $em->getRepository('AppBundle:Depositos')->findBy(array('estudiante'=>$especialidad, 'lapso'=>$lapsoac->getId()));
        
        return $this->render('AppBundle:Depositos:depositos.html.twig', array(
            'form'=>$form->createView(), 
            'depositos'=>$depositosAnt
        ));
       // echo "OK";
    }
    
    private function formDepositoEstudiante(\Doctrine\ORM\EntityManager $em, Depositos $entity, $especialidad, $lapso)
    {
        $form = $this->createForm(new DepositosType($em), $entity, array(
            'method'=>'POST', 
            'action'=>$this->generateUrl('app_depositos_index', array('especialidad'=>$especialidad, 'lapso'=>$lapso))
        ))
        ->add('id', 'hidden', array('data'=>$especialidad, 'mapped'=>false))
        ->add('lapso', 'hidden', array('data'=>$lapso, 'mapped'=>false))
        ->add('submit', 'submit', array('label'=>'Insertar','attr'=>array('class'=>'btn btn-primary btn-flat', 'style'=>'margin-left:15px;')))
        ;
        return $form;
    }
    
    /**
     * @Route("/app/delete/depositos/{especialidad}/{id}/{lapso}", name="app_delete_depositos")
     */
    public function deleteDepositoEstudianteAction($especialidad, $id, $lapso)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $directorio = $this->container->getParameter('directorio.imagenes.baucher');
        $entity = $em->getRepository('AppBundle:Depositos')->find($id);
        if(is_file($directorio.'/'.$entity->getFileBauche())){
            unlink($directorio.'/'.$entity->getFileBauche());
        }
        $em->remove($entity);
        $em->flush();
        $this->get('session')->getFlashBag()->add('msg-success', 'Registro eliminado con exito!');
        return $this->redirect($this->generateUrl('app_depositos_index', array('especialidad'=>$especialidad, 'lapso'=>$lapso)));
    }
    
}