<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Procesos;
use AppBundle\Form\ProcesosType;
    

/**
 * Description of ProcesosController
 *
 * @author jose
 */
class ProcesosController extends Controller {
    
    /**
     * @Route("/app/admin/procesos", name="app_admin_procesos_index")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
        $entities = $em->getRepository('AppBundle:Procesos')->findBy(array('sede'=>$sede->getId()));
        
        return $this->render('AppBundle:Procesos:index.html.twig', array(
            'entities'=>$entities
        ));
    }
    
    /**
     * @Route("/app/admin/edit/proceso/{id}", name="app_admin_edit_proceso")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Procesos')->find($id);
        $form = $this->editForm($entity, $em);
        
        return $this->render('AppBundle:Procesos:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/proceso/{id}", name="app_admin_update_proceso", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Procesos')->find($id);
        $form = $this->editForm($entity, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
            return $this->redirect($this->generateUrl('app_admin_procesos_index'));
        }
        
        return $this->render('AppBundle:Procesos:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editForm(Procesos $entity, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new ProcesosType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_update_proceso', array('id'=>$entity->getId())),
            'method'=>'PUT'            
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        
        return $form;
    }
    
    
}
