<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Description of CreditosGraduando
 *
 * @author jose
 */

/**
 * @ORM\Table(name="credito_graduando")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\CreditosGraduandoRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class CreditosGraduando {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="creditos")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="creditos")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    protected $especialidad;
    
    /**
     * @ORM\Column(type="integer", name="uc_obligatoris")
     */
    protected $ucObligatorios;
    
    /**
     * @ORM\Column(type="integer", name="uc_electivos")
     */
    protected $ucElectivos;
    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set ucObligatorios
     *
     * @param integer $ucObligatorios
     * @return CreditosGraduando
     */
    public function setUcObligatorios($ucObligatorios)
    {
        $this->ucObligatorios = $ucObligatorios;
    
        return $this;
    }

    /**
     * Get ucObligatorios
     *
     * @return integer 
     */
    public function getUcObligatorios()
    {
        return $this->ucObligatorios;
    }

    /**
     * Set ucElectivos
     *
     * @param integer $ucElectivos
     * @return CreditosGraduando
     */
    public function setUcElectivos($ucElectivos)
    {
        $this->ucElectivos = $ucElectivos;
    
        return $this;
    }

    /**
     * Get ucElectivos
     *
     * @return integer 
     */
    public function getUcElectivos()
    {
        return $this->ucElectivos;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     * @return CreditosGraduando
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set especialidad
     *
     * @param \AppBundle\Entity\Especialidad $especialidad
     * @return CreditosGraduando
     */
    public function setEspecialidad(\AppBundle\Entity\Especialidad $especialidad = null)
    {
        $this->especialidad = $especialidad;
    
        return $this;
    }

    /**
     * Get especialidad
     *
     * @return \AppBundle\Entity\Especialidad 
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }
}
