<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="cursos")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\CursosRepository")
 */
class Cursos {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=30, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string")
     */
    protected $nombre;
    
    /**
     * @ORM\Column(type="integer", length=1)
     */
    protected $uc;
    
    /**
     * @ORM\Column(type="text", nullable=true)
     */
    protected $observacion;
    
    /**
     * @ORM\OneToMany(targetEntity="PlanEstudio", mappedBy="curso")
     */
    protected $planestudio;
       
    /**
     * @ORM\OneToMany(targetEntity="PlanEstudio", mappedBy="prelacion")
     */
    protected $planprelacion;
    
    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="curso")
     */
    protected $oferacade;

    /**
     * @ORM\OneToMany(targetEntity="HistMatri", mappedBy="curso")
     */
    protected $histmatri;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatriEgresado", mappedBy="curso")
     */
    protected $histmatriegresado;
    
    /**
     * @ORM\OneToMany(targetEntity="CursosEspeciales", mappedBy="curso")
     */
    protected $cursoespecial;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="cursos")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\Prelacion", mappedBy="curso")
     */
    protected $prelacion;

    /**
     * @ORM\Column(type="integer", length=1)
     */
    protected $had;

    /**
     * @ORM\Column(type="integer", length=1)
     */
    protected $hle;
    
    
    /**
     * @ORM\ManyToOne(targetEntity="Componentes", inversedBy="cursos")
     * @ORM\JoinColumn(name="componente_id", referencedColumnName="id")
     */
    protected $componentes;

    
       /**
     * @ORM\ManyToOne(targetEntity="TipoCursos", inversedBy="cursos")
     * @ORM\JoinColumn(name="tipocursos_id", referencedColumnName="id")
     */
    protected $tipocursos;

    
        /**
     * @ORM\ManyToOne(targetEntity="Areas", inversedBy="cursos")
     * @ORM\JoinColumn(name="area_id", referencedColumnName="id")
     */
    protected $areas;






    // METODOS GENERADOS PARA LAS CONSULTAS //
    
    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->planestudio = new \Doctrine\Common\Collections\ArrayCollection();
        $this->planprelacion = new \Doctrine\Common\Collections\ArrayCollection();
        $this->oferacade = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatri = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatriegresado = new \Doctrine\Common\Collections\ArrayCollection();
        $this->cursoespecial = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return Cursos
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return Cursos
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return string 
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set uc
     *
     * @param integer $uc
     * @return Cursos
     */
    public function setUc($uc)
    {
        $this->uc = $uc;
    
        return $this;
    }

    /**
     * Get uc
     *
     * @return integer 
     */
    public function getUc()
    {
        return $this->uc;
    }

    /**
     * Set observacion
     *
     * @param string $observacion
     * @return Cursos
     */
    public function setObservacion($observacion)
    {
        $this->observacion = $observacion;
    
        return $this;
    }

    /**
     * Get observacion
     *
     * @return string 
     */
    public function getObservacion()
    {
        return $this->observacion;
    }

    /**
     * Add planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     * @return Cursos
     */
    public function addPlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio[] = $planestudio;
    
        return $this;
    }

    /**
     * Remove planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     */
    public function removePlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio->removeElement($planestudio);
    }

    /**
     * Get planestudio
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPlanestudio()
    {
        return $this->planestudio;
    }

    /**
     * Add planprelacion
     *
     * @param \AppBundle\Entity\PlanEstudio $planprelacion
     * @return Cursos
     */
    public function addPlanprelacion(\AppBundle\Entity\PlanEstudio $planprelacion)
    {
        $this->planprelacion[] = $planprelacion;
    
        return $this;
    }

    /**
     * Remove planprelacion
     *
     * @param \AppBundle\Entity\PlanEstudio $planprelacion
     */
    public function removePlanprelacion(\AppBundle\Entity\PlanEstudio $planprelacion)
    {
        $this->planprelacion->removeElement($planprelacion);
    }

    /**
     * Get planprelacion
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPlanprelacion()
    {
        return $this->planprelacion;
    }

    /**
     * Add oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     * @return Cursos
     */
    public function addOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade[] = $oferacade;
    
        return $this;
    }

    /**
     * Remove oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     */
    public function removeOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade->removeElement($oferacade);
    }

    /**
     * Get oferacade
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getOferacade()
    {
        return $this->oferacade;
    }

    /**
     * Add histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     * @return Cursos
     */
    public function addHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri[] = $histmatri;
    
        return $this;
    }

    /**
     * Remove histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     */
    public function removeHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri->removeElement($histmatri);
    }

    /**
     * Get histmatri
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatri()
    {
        return $this->histmatri;
    }

    /**
     * Add histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     * @return Cursos
     */
    public function addHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado[] = $histmatriegresado;
    
        return $this;
    }

    /**
     * Remove histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     */
    public function removeHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado->removeElement($histmatriegresado);
    }

    /**
     * Get histmatriegresado
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatriegresado()
    {
        return $this->histmatriegresado;
    }

    /**
     * Add cursoespecial
     *
     * @param \AppBundle\Entity\CursosEspeciales $cursoespecial
     * @return Cursos
     */
    public function addCursoespecial(\AppBundle\Entity\CursosEspeciales $cursoespecial)
    {
        $this->cursoespecial[] = $cursoespecial;
    
        return $this;
    }

    /**
     * Remove cursoespecial
     *
     * @param \AppBundle\Entity\CursosEspeciales $cursoespecial
     */
    public function removeCursoespecial(\AppBundle\Entity\CursosEspeciales $cursoespecial)
    {
        $this->cursoespecial->removeElement($cursoespecial);
    }

    /**
     * Get cursoespecial
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCursoespecial()
    {
        return $this->cursoespecial;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     * @return Cursos
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }
    
    public function __toString() {
        return $this->getCodigo().' - '.$this->getNombre();
    }

    /**
     * Add prelacion
     *
     * @param \AppBundle\Entity\Prelacion $prelacion
     *
     * @return Cursos
     */
    public function addPrelacion(\AppBundle\Entity\Prelacion $prelacion)
    {
        $this->prelacion[] = $prelacion;

        return $this;
    }

    /**
     * Remove prelacion
     *
     * @param \AppBundle\Entity\Prelacion $prelacion
     */
    public function removePrelacion(\AppBundle\Entity\Prelacion $prelacion)
    {
        $this->prelacion->removeElement($prelacion);
    }

    /**
     * Get prelacion
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPrelacion()
    {
        return $this->prelacion;
    }

    /**
     * Set had
     *
     * @param integer $had
     *
     * @return Cursos
     */
    public function setHad($had)
    {
        $this->had = $had;

        return $this;
    }

    /**
     * Get had
     *
     * @return integer
     */
    public function getHad()
    {
        return $this->had;
    }

    /**
     * Set hle
     *
     * @param integer $hle
     *
     * @return Cursos
     */
    public function setHle($hle)
    {
        $this->hle = $hle;

        return $this;
    }

    /**
     * Get hle
     *
     * @return integer
     */
    public function getHle()
    {
        return $this->hle;
    }
    
    /**
     * Set componentes
     *
     * @param string $componentes
     * @return PlanEstudio
     */
    public function setComponentes($componentes)
    {
        $this->componentes = $componentes;
    
        return $this;
    }

    /**
     * Get componentes
     *
     * @return string 
     */
    public function getComponentes()
    {
        return $this->componentes;
    }
    
    
    /**
     * Set areas
     *
     * @param \AppBundle\Entity\Areas $areas
     *
     * @return PlanEstudio
     */
    public function setAreas(\AppBundle\Entity\Areas $areas = null)
    {
        $this->areas = $areas;

        return $this;
    }

    /**
     * Get areas
     *
     * @return \AppBundle\Entity\Areas
     */
    public function getAreas()
    {
        return $this->areas;
    }

    /**
     * Set tipocursos
     *
     * @param \AppBundle\Entity\TipoCursos $tipocursos
     *
     * @return PlanEstudio
     */
    public function setTipocursos(\AppBundle\Entity\TipoCursos $tipocursos = null)
    {
        $this->tipocursos = $tipocursos;

        return $this;
    }

    /**
     * Get tipocursos
     *
     * @return \AppBundle\Entity\TipoCursos
     */
    public function getTipocursos()
    {
        return $this->tipocursos;
    }
    
}
