<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="lapso")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\LapsoRepository")
 */    
class Lapso {
    
     /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    protected $activo;
    
    /**
     * @ORM\Column(type="string") 
     */
    protected $fecha_inicial;
    
    /**
     * @ORM\Column(type="string") 
     */
    protected $fecha_final;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="lapso")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\OneToMany(targetEntity="EspeEstud", mappedBy="cod_lapso")
     */
    protected $espeestud;
    
    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="lapso")
     */
    protected $oferacade;

    /**
     * @ORM\OneToMany(targetEntity="Depositos", mappedBy="lapso")
     */
    protected $depositos;

    /**
     * @ORM\OneToMany(targetEntity="HistMatri", mappedBy="lapso")
     */
    protected $histmatri;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatriEgresado", mappedBy="lapso")
     */
    protected $histmatriegresado;

      
    /**
     * @ORM\OneToMany(targetEntity="Procesos", mappedBy="lapso")
     */
    protected $procesos;
    
    /**
     * @ORM\OneToMany(targetEntity="ValidEstudiante", mappedBy="lapso")
     */
    protected $validestud;
    
    /**
     * @ORM\OneToMany(targetEntity="Exonerados", mappedBy="lapso")
     */
    protected $exonerados;
    
    /**
     * @ORM\OneToMany(targetEntity="ControlPagos", mappedBy="lapso")
     */
    protected $controlpagos;

    // METODOS GENERADOS PARA LAS CONSULTAS //
    
    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->espeestud = new \Doctrine\Common\Collections\ArrayCollection();
        $this->oferacade = new \Doctrine\Common\Collections\ArrayCollection();
        $this->depositos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatri = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatriegresado = new \Doctrine\Common\Collections\ArrayCollection();
        $this->procesos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->validestud = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return Lapso
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set activo
     *
     * @param boolean $activo
     * @return Lapso
     */
    public function setActivo($activo)
    {
        $this->activo = $activo;
    
        return $this;
    }

    /**
     * Get activo
     *
     * @return boolean 
     */
    public function getActivo()
    {
        return $this->activo;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     * @return Lapso
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Add espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     * @return Lapso
     */
    public function addEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud[] = $espeestud;
    
        return $this;
    }

    /**
     * Remove espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     */
    public function removeEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud->removeElement($espeestud);
    }

    /**
     * Get espeestud
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEspeestud()
    {
        return $this->espeestud;
    }

    /**
     * Add oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     * @return Lapso
     */
    public function addOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade[] = $oferacade;
    
        return $this;
    }

    /**
     * Remove oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     */
    public function removeOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade->removeElement($oferacade);
    }

    /**
     * Get oferacade
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getOferacade()
    {
        return $this->oferacade;
    }

    /**
     * Add depositos
     *
     * @param \AppBundle\Entity\Depositos $depositos
     * @return Lapso
     */
    public function addDeposito(\AppBundle\Entity\Depositos $depositos)
    {
        $this->depositos[] = $depositos;
    
        return $this;
    }

    /**
     * Remove depositos
     *
     * @param \AppBundle\Entity\Depositos $depositos
     */
    public function removeDeposito(\AppBundle\Entity\Depositos $depositos)
    {
        $this->depositos->removeElement($depositos);
    }

    /**
     * Get depositos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getDepositos()
    {
        return $this->depositos;
    }

    /**
     * Add histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     * @return Lapso
     */
    public function addHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri[] = $histmatri;
    
        return $this;
    }

    /**
     * Remove histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     */
    public function removeHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri->removeElement($histmatri);
    }

    /**
     * Get histmatri
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatri()
    {
        return $this->histmatri;
    }

    /**
     * Add histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     * @return Lapso
     */
    public function addHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado[] = $histmatriegresado;
    
        return $this;
    }

    /**
     * Remove histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     */
    public function removeHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado->removeElement($histmatriegresado);
    }

    /**
     * Get histmatriegresado
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatriegresado()
    {
        return $this->histmatriegresado;
    }

    /**
     * Add procesos
     *
     * @param \AppBundle\Entity\Procesos $procesos
     * @return Lapso
     */
    public function addProceso(\AppBundle\Entity\Procesos $procesos)
    {
        $this->procesos[] = $procesos;
    
        return $this;
    }

    /**
     * Remove procesos
     *
     * @param \AppBundle\Entity\Procesos $procesos
     */
    public function removeProceso(\AppBundle\Entity\Procesos $procesos)
    {
        $this->procesos->removeElement($procesos);
    }

    /**
     * Get procesos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getProcesos()
    {
        return $this->procesos;
    }

    /**
     * Add validestud
     *
     * @param \AppBundle\Entity\ValidEstudiante $validestud
     * @return Lapso
     */
    public function addValidestud(\AppBundle\Entity\ValidEstudiante $validestud)
    {
        $this->validestud[] = $validestud;
    
        return $this;
    }

    /**
     * Remove validestud
     *
     * @param \AppBundle\Entity\ValidEstudiante $validestud
     */
    public function removeValidestud(\AppBundle\Entity\ValidEstudiante $validestud)
    {
        $this->validestud->removeElement($validestud);
    }

    /**
     * Get validestud
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getValidestud()
    {
        return $this->validestud;
    }
    
    public function __toString() {
        return $this->getCodigo();
    }

    /**
     * Add exonerados
     *
     * @param \AppBundle\Entity\Exonerados $exonerados
     * @return Lapso
     */
    public function addExonerado(\AppBundle\Entity\Exonerados $exonerados)
    {
        $this->exonerados[] = $exonerados;
    
        return $this;
    }

    /**
     * Remove exonerados
     *
     * @param \AppBundle\Entity\Exonerados $exonerados
     */
    public function removeExonerado(\AppBundle\Entity\Exonerados $exonerados)
    {
        $this->exonerados->removeElement($exonerados);
    }

    /**
     * Get exonerados
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getExonerados()
    {
        return $this->exonerados;
    }

    /**
     * Add controlpagos
     *
     * @param \AppBundle\Entity\ControlPagos $controlpagos
     * @return Lapso
     */
    public function addControlpago(\AppBundle\Entity\ControlPagos $controlpagos)
    {
        $this->controlpagos[] = $controlpagos;
    
        return $this;
    }

    /**
     * Remove controlpagos
     *
     * @param \AppBundle\Entity\ControlPagos $controlpagos
     */
    public function removeControlpago(\AppBundle\Entity\ControlPagos $controlpagos)
    {
        $this->controlpagos->removeElement($controlpagos);
    }

    /**
     * Get controlpagos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getControlpagos()
    {
        return $this->controlpagos;
    }

    /**
     * Set fechaInicial
     *
     * @param string $fechaInicial
     *
     * @return Lapso
     */
    public function setFechaInicial($fechaInicial)
    {
        $this->fecha_inicial = $fechaInicial;

        return $this;
    }

    /**
     * Get fechaInicial
     *
     * @return string
     */
    public function getFechaInicial()
    {
        return $this->fecha_inicial;
    }

    /**
     * Set fechaFinal
     *
     * @param string $fechaFinal
     *
     * @return Lapso
     */
    public function setFechaFinal($fechaFinal)
    {
        $this->fecha_final = $fechaFinal;

        return $this;
    }

    /**
     * Get fechaFinal
     *
     * @return string
     */
    public function getFechaFinal()
    {
        return $this->fecha_final;
    }
}
