<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="monto_curso")
 * @ORM\Entity
 */
class MontoCurso {
   
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="montocurso")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\ManyToOne(targetEntity="Programa", inversedBy="montocurso")
     * @ORM\JoinColumn(name="programa_id", referencedColumnName="id")
     */
    protected $programa;
    
    /**
     * @ORM\Column(type="float", scale=2)
     */
    protected $monto;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set monto
     *
     * @param float $monto
     * @return MontoCurso
     */
    public function setMonto($monto)
    {
        $this->monto = $monto;
    
        return $this;
    }

    /**
     * Get monto
     *
     * @return float 
     */
    public function getMonto()
    {
        return $this->monto;
    }

    /**
     * Set sede
     *
     * @param AppBundle\Entity\Sede $sede
     * @return MontoCurso
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set programa
     *
     * @param \AppBundle\Entity\Programa $programa
     * @return MontoCurso
     */
    public function setPrograma(\AppBundle\Entity\Programa $programa = null)
    {
        $this->programa = $programa;
    
        return $this;
    }

    /**
     * Get programa
     *
     * @return \AppBundle\Entity\Programa 
     */
    public function getPrograma()
    {
        return $this->programa;
    }
}
