<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * ProfesorRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ProfesorRepository extends EntityRepository
{
    public function findByAllProfesoresBySede($sede, $especialidad, $lapso)
    {
        $query = $this->getEntityManager()->createQuery(
                "SELECT p FROM AppBundle:Profesor p 
                 LEFT JOIN p.oferacade o 
                 WHERE                  
                 o.especialidad = :especialidad AND 
                 o.lapso = :lapso AND 
                 o.sede = :sede AND 
                 p.cedula != 1 
                 ORDER BY p.cedula ASC
                "
                )
                ->setParameter('sede', $sede)
                ->setParameter('especialidad', $especialidad)
                ->setParameter('lapso', $lapso);
        return $query->getResult();
    }
    
    public function findSearchTermino($term)
    {
        $query = $this->getEntityManager()->createQuery(
                "SELECT p FROM AppBundle:Profesor p 
                 WHERE  
                 CONCAT(p.primer_nombre, ' ', p.primer_apellido) LIKE :term AND p.activo != 0 OR 
                 p.cedula LIKE :term AND 
                 p.cedula != 1 AND p.activo != 0
                 ORDER BY p.cedula ASC
                "
                )
                ->setParameter('term', '%'.$term.'%')
                ;
        return $query->getResult();
    }
    
}
