<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="subsede")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\SubSedeRepository")
 */
class SubSede {
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=80)
     */
    protected $descripcion;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $vigente;

    /**
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\TipoSubSede", inversedBy="subsede")
     * @ORM\JoinColumn(name="tiposubsede_id", referencedColumnName="id")
     */
    protected $tiposubsede;

    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="subsede")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
     /**
     * @ORM\OneToMany(targetEntity="Autoridades", mappedBy="subsede")
     */
    protected $autoridades;

    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="subsede")
     */
    protected $oferacade;
    /**
     * @ORM\OneToMany(targetEntity="ExtensionesUsuarios", mappedBy="subsede")
     */
    protected $extensiones;
     /**
     * @ORM\OneToMany(targetEntity="ControlPagos", mappedBy="subsede")
     */
    protected $controlpagos;
    /**
     * @ORM\OneToMany(targetEntity="ConfigSistema", mappedBy="subsede")
     */
    protected $configsistema;

    /**
     * @ORM\OneToMany(targetEntity="Depositos", mappedBy="subsede")
     */
    protected $depositos;
    /**
     * @ORM\OneToMany(targetEntity="Exonerados", mappedBy="subsede")
     */
    protected $exonerados;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatriEgresado", mappedBy="subsede")
     */
    protected $histmatriegresado;
     /**
     * @ORM\OneToMany(targetEntity="Procesos", mappedBy="subsede")
     */
    protected $procesos;
    /**
     * @ORM\OneToMany(targetEntity="EspeEstud", mappedBy="subsedes")
     */
    protected $estudiante;
    /**
     * @ORM\OneToMany(targetEntity="SubSedeEspe", mappedBy="subsede")
     */    
    protected $subsedeespe;

        /**
     * @ORM\OneToMany(targetEntity="SubSedeUsuario", mappedBy="subsede")
     */    
    protected $subsedeusuario;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->oferacade = new \Doctrine\Common\Collections\ArrayCollection();
        $this->subsedeusuario = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return SubSede
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     *
     * @return SubSede
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Set vigente
     *
     * @param boolean $vigente
     *
     * @return SubSede
     */
    public function setVigente($vigente)
    {
        $this->vigente = $vigente;

        return $this;
    }

    /**
     * Get vigente
     *
     * @return boolean
     */
    public function getVigente()
    {
        return $this->vigente;
    }

    /**
     * Set tiposubsede
     *
     * @param \AppBundle\Entity\TipoSubSede $tiposubsede
     *
     * @return SubSede
     */
    public function setTiposubsede(\AppBundle\Entity\TipoSubSede $tiposubsede = null)
    {
        $this->tiposubsede = $tiposubsede;

        return $this;
    }

    /**
     * Get tiposubsede
     *
     * @return \AppBundle\Entity\TipoSubSede
     */
    public function getTiposubsede()
    {
        return $this->tiposubsede;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     *
     * @return SubSede
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;

        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Add oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     *
     * @return SubSede
     */
    public function addOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade[] = $oferacade;

        return $this;
    }

    /**
     * Remove oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     */
    public function removeOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade->removeElement($oferacade);
    }

    /**
     * Get oferacade
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOferacade()
    {
        return $this->oferacade;
    }
     public function __toString()
    {
        return $this->descripcion;}

    /**
     * Add autoridade
     *
     * @param \AppBundle\Entity\Autoridades $autoridade
     *
     * @return SubSede
     */
    public function addAutoridade(\AppBundle\Entity\Autoridades $autoridade)
    {
        $this->autoridades[] = $autoridade;

        return $this;
    }

    /**
     * Remove autoridade
     *
     * @param \AppBundle\Entity\Autoridades $autoridade
     */
    public function removeAutoridade(\AppBundle\Entity\Autoridades $autoridade)
    {
        $this->autoridades->removeElement($autoridade);
    }

    /**
     * Get autoridades
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAutoridades()
    {
        return $this->autoridades;
    }


    /**
     * Add extensione
     *
     * @param \AppBundle\Entity\ExtensionesUsuarios $extensione
     *
     * @return SubSede
     */
    public function addExtensione(\AppBundle\Entity\ExtensionesUsuarios $extensione)
    {
        $this->extensiones[] = $extensione;

        return $this;
    }

    /**
     * Remove extensione
     *
     * @param \AppBundle\Entity\ExtensionesUsuarios $extensione
     */
    public function removeExtensione(\AppBundle\Entity\ExtensionesUsuarios $extensione)
    {
        $this->extensiones->removeElement($extensione);
    }

    /**
     * Get extensiones
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getExtensiones()
    {
        return $this->extensiones;
    }

    /**
     * Add controlpago
     *
     * @param \AppBundle\Entity\ControlPagos $controlpago
     *
     * @return SubSede
     */
    public function addControlpago(\AppBundle\Entity\ControlPagos $controlpago)
    {
        $this->controlpagos[] = $controlpago;

        return $this;
    }

    /**
     * Remove controlpago
     *
     * @param \AppBundle\Entity\ControlPagos $controlpago
     */
    public function removeControlpago(\AppBundle\Entity\ControlPagos $controlpago)
    {
        $this->controlpagos->removeElement($controlpago);
    }

    /**
     * Get controlpagos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getControlpagos()
    {
        return $this->controlpagos;
    }

    /**
     * Add configsistema
     *
     * @param \AppBundle\Entity\ConfigSistema $configsistema
     *
     * @return SubSede
     */
    public function addConfigsistema(\AppBundle\Entity\ConfigSistema $configsistema)
    {
        $this->configsistema[] = $configsistema;

        return $this;
    }

    /**
     * Remove configsistema
     *
     * @param \AppBundle\Entity\ConfigSistema $configsistema
     */
    public function removeConfigsistema(\AppBundle\Entity\ConfigSistema $configsistema)
    {
        $this->configsistema->removeElement($configsistema);
    }

    /**
     * Get configsistema
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getConfigsistema()
    {
        return $this->configsistema;
    }

    /**
     * Add deposito
     *
     * @param \AppBundle\Entity\Depositos $deposito
     *
     * @return SubSede
     */
    public function addDeposito(\AppBundle\Entity\Depositos $deposito)
    {
        $this->depositos[] = $deposito;

        return $this;
    }

    /**
     * Remove deposito
     *
     * @param \AppBundle\Entity\Depositos $deposito
     */
    public function removeDeposito(\AppBundle\Entity\Depositos $deposito)
    {
        $this->depositos->removeElement($deposito);
    }

    /**
     * Get depositos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDepositos()
    {
        return $this->depositos;
    }

    /**
     * Add exonerado
     *
     * @param \AppBundle\Entity\Exonerados $exonerado
     *
     * @return SubSede
     */
    public function addExonerado(\AppBundle\Entity\Exonerados $exonerado)
    {
        $this->exonerados[] = $exonerado;

        return $this;
    }

    /**
     * Remove exonerado
     *
     * @param \AppBundle\Entity\Exonerados $exonerado
     */
    public function removeExonerado(\AppBundle\Entity\Exonerados $exonerado)
    {
        $this->exonerados->removeElement($exonerado);
    }

    /**
     * Get exonerados
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getExonerados()
    {
        return $this->exonerados;
    }

    /**
     * Add histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     *
     * @return SubSede
     */
    public function addHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado[] = $histmatriegresado;

        return $this;
    }

    /**
     * Remove histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     */
    public function removeHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado->removeElement($histmatriegresado);
    }

    /**
     * Get histmatriegresado
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getHistmatriegresado()
    {
        return $this->histmatriegresado;
    }

    /**
     * Add proceso
     *
     * @param \AppBundle\Entity\Procesos $proceso
     *
     * @return SubSede
     */
    public function addProceso(\AppBundle\Entity\Procesos $proceso)
    {
        $this->procesos[] = $proceso;

        return $this;
    }

    /**
     * Remove proceso
     *
     * @param \AppBundle\Entity\Procesos $proceso
     */
    public function removeProceso(\AppBundle\Entity\Procesos $proceso)
    {
        $this->procesos->removeElement($proceso);
    }

    /**
     * Get procesos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProcesos()
    {
        return $this->procesos;
    }

    /**
     * Add estudiante
     *
     * @param \AppBundle\Entity\EspeEstud $estudiante
     *
     * @return SubSede
     */
    public function addEstudiante(\AppBundle\Entity\EspeEstud $estudiante)
    {
        $this->estudiante[] = $estudiante;

        return $this;
    }

    /**
     * Remove estudiante
     *
     * @param \AppBundle\Entity\EspeEstud $estudiante
     */
    public function removeEstudiante(\AppBundle\Entity\EspeEstud $estudiante)
    {
        $this->estudiante->removeElement($estudiante);
    }

    /**
     * Get estudiante
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Add subsedeespe
     *
     * @param \AppBundle\Entity\SubSedeEspe $subsedeespe
     *
     * @return SubSede
     */
    public function addSubsedeespe(\AppBundle\Entity\SubSedeEspe $subsedeespe)
    {
        $this->subsedeespe[] = $subsedeespe;

        return $this;
    }

    /**
     * Remove subsedeespe
     *
     * @param \AppBundle\Entity\SubSedeEspe $subsedeespe
     */
    public function removeSubsedeespe(\AppBundle\Entity\SubSedeEspe $subsedeespe)
    {
        $this->subsedeespe->removeElement($subsedeespe);
    }

    /**
     * Get subsedeespe
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSubsedeespe()
    {
        return $this->subsedeespe;
    }


     /**
     * Add subsedeusu
     *
     * @param \AppBundle\Entity\SubSedeUsuario $subsedeusuario
     * @return SubSede
     */
    public function addSubsedeusu(\AppBundle\Entity\SubSedeUsuario $subsedeusuario)
    {
        $this->subsedeusuario[] = $subsedeusuario;
    
        return $this;
    }

    /**
     * Remove subsedeusu
     *
     * @param \AppBundle\Entity\SubSedeUsuario $subsedeusuario
     */
    public function removeSubsedeusu(\AppBundle\Entity\SubSedeUsuario $subsedeusuario)
    {
        $this->subsedeusuario->removeElement($subsedeusuario);
    }

    /**
     * Get subsedeusu
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSubsedeusuario()
    {
        return $this->subsedeusuario;
    }

    /**
     * Add subsedeusuario
     *
     * @param \AppBundle\Entity\SubSedeUsuario $subsedeusuario
     *
     * @return SubSede
     */
    public function addSubsedeusuario(\AppBundle\Entity\SubSedeUsuario $subsedeusuario)
    {
        $this->subsedeusuario[] = $subsedeusuario;

        return $this;
    }

    /**
     * Remove subsedeusuario
     *
     * @param \AppBundle\Entity\SubSedeUsuario $subsedeusuario
     */
    public function removeSubsedeusuario(\AppBundle\Entity\SubSedeUsuario $subsedeusuario)
    {
        $this->subsedeusuario->removeElement($subsedeusuario);
    }
}
