<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Autoridades;
use AppBundle\Form\AutoridadesType;

/**
 * Description of AutoridadesController
 *
 * @author jose
 */
class AutoridadesController extends Controller {
    


    /**
     *  @Route("/app/admin/autoridades", name="app_admin_autoridades_index")
     */
    public function indexAction()
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT l FROM AppBundle:Autoridades l "
                . "ORDER BY l.id DESC ";
        $entities = $em->createQuery($query);        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Autoridades:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     *  @Route("/app/admin/search/autoridades", name="app_admin_autoridades_search_index")
     */
    public function searchAction(Request $request)
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
        $query = "SELECT l FROM AppBundle:Autoridades l "
                . "WHERE "
                . "l.id LIKE :text "
                . "ORDER BY l.id DESC ";
        $entities = $em->createQuery($query);        
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Autoridades:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     * @Route("/app/admin/edit/autoridades/{id}", name="app_admin_autoridades_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Autoridades')->find($id);        
  	$form = $this->editForm($entity, $em);
        
        return $this->render('AppBundle:Autoridades:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/autoridades/{id}", name="app_admin_autoridades_update", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Autoridades')->find($id);        
	$form = $this->editForm($entity, $em);
        
        $form->handleRequest($request);
        
        if($form->isValid())
        {
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
            return $this->redirect($this->generateUrl('app_admin_autoridades_index'));
        }
        
        return $this->render('AppBundle:Autoridades:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editForm(Autoridades $entity, \Doctrine\ORM\EntityManager $em){
        $form = $this->createForm(new AutoridadesType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_autoridades_update', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/new/autoridades", name="app_admin_autoridades_new")
     */
    public function newAction()
    {
	$em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Autoridades();
        $form = $this->newForm($entity, $em);
        
        return $this->render('AppBundle:Autoridades:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/autoridades", name="app_admin_autoridades_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {

	$em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Autoridades();
        $form = $this->newForm($entity, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro creado con exito!');
            return $this->redirect($this->generateUrl('app_admin_autoridades_index'));
        }
        
        return $this->render('AppBundle:Autoridades:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function newForm(Autoridades $entity, \Doctrine\ORM\EntityManager $em) {
        $form = $this->createForm(new AutoridadesType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_autoridades_create'),
            'method'=>'POST'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
}
