<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Depositos;
use AppBundle\Form\DepositosType;
use AppBundle\Entity\Matricula;

use AppBundle\Utils\ReporteLayout;

/**
 * Description of BackenEstudiantes
 *
 * @author jose
 */
class BackendEstudiantesController extends Controller {
    
    public function includeHeadAlumnAction(){
        $datenow = new \DateTime();
        return $this->render('AppBundle:BackendEstudiantes:includes/head.html.twig', array('datenow'=>$datenow));
    }
    
    public function includeAsideLeftAlumnAction()
    {
        return $this->render('AppBundle:BackendEstudiantes:includes/aside_left.html.twig', array());
    }
    
    /**
     * @Route("/app/backend/estudiantes/index", name="app_homepage_estudiante")
     */ 
    public function indexAction(){
        $entity = $this->getUser()->getSede()->getCodigo();
        $this->get('session')->set('em', $entity);
        $this->get('session')->set('cedulaest', $this->getUser()->getCedula());
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $datosEstudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>  $this->get('session')->get('cedulaest')));        
        $lapsoActual = $em->getRepository('AppBundle:Lapso')->findOneBy(array('activo'=>1));
        
        $this->get('session')->set('datosEstudiante', $datosEstudiante);
        $this->get('session')->set('lapsoActual', $lapsoActual);
        
        return $this->render('AppBundle:BackendEstudiantes:views/index.html.twig', array(            
            
        ));
    }
    
    /**
     * @Route("/app/backend/estudiantes/{especialidad}/depositos", name="app_backend_estudiante_depositos")
     */
    public function depositosAction($especialidad, Request $request){
        
        $entity = new Depositos();
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $form = $this->formDepositoEstudiante($em,$entity, $especialidad);
        $lapsoac = $em->getRepository('AppBundle:Lapso')->find($this->get('session')->get('lapsoActual')->getId());
        
        $procesos = $em->getRepository('AppBundle:Procesos')->findProcesoActivoFech($lapsoac->getId(), 'PI');
                
        
        if(!$procesos){
            $this->get('session')->getFlashBag()->add('msg-error', 'Proceso cerrado para la fecha actual');
            return $this->redirect($this->generateUrl('app_homepage_estudiante'));
        }        
        
        if($request->getMethod() == 'POST')
        {
            $form->handleRequest($request);
            if($form->isValid())
            {
                $directorio = $this->container->getParameter('directorio.imagenes.baucher');
                $entity->subirFotoBauche($directorio);                
                $entity->setLapso($lapsoac);
                $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
                $entity->setEstudiante($espeestud);
                $condde = $em->getRepository('AppBundle:CondDepositos')->findOneBy(array('descripcion'=>'Deposito'));
                $entity->setConddepositos($condde);
                $em->persist($entity);
                $em->flush();
                
                $this->get('session')->getFlashBag()->add('msg-success', 'Registro insertado con exito!!');
                return $this->redirect($this->generateUrl('app_backend_estudiante_depositos', array(
                    'especialidad'=>$especialidad
                )));
                
            }
        }
        
        $depositosAnt = $em->getRepository('AppBundle:Depositos')->findBy(array('estudiante'=>$especialidad, 'lapso'=>$lapsoac->getId()));
        
        return $this->render('AppBundle:BackendEstudiantes:views/depositos/depositos.html.twig', array(
            'form'=>$form->createView(), 
            'depositos'=>$depositosAnt
        ));
       // echo "OK";
    }
    
    private function formDepositoEstudiante(\Doctrine\ORM\EntityManager $em, Depositos $entity, $especialidad)
    {
        $form = $this->createForm(new DepositosType($em), $entity, array(
            'method'=>'POST', 
            'action'=>$this->generateUrl('app_backend_estudiante_depositos', array('especialidad'=>$especialidad))
        ))
        ->add('submit', 'submit', array('label'=>'Insertar','attr'=>array('class'=>'btn btn-primary btn-flat')))
        ;
        return $form;
    }
    
    /**
     * @Route("/app/backend/estudiantes/delete/depositos/{especialidad}/{id}", name="app_backend_estudiante_delete_depositos")
     */
    public function deleteDepositoEstudianteAction($especialidad, $id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $directorio = $this->container->getParameter('directorio.imagenes.baucher');
        $entity = $em->getRepository('AppBundle:Depositos')->find($id);
        if(is_file($directorio.'/'.$entity->getFileBauche())){
            unlink($directorio.'/'.$entity->getFileBauche());
        }
        $em->remove($entity);
        $em->flush();
        $this->get('session')->getFlashBag()->add('msg-success', 'Registro eliminado con exito!');
        return $this->redirect($this->generateUrl('app_backend_estudiante_depositos', array('especialidad'=>$especialidad)));
    }
    
    /**
     * @Route("/app/backend/estudiantes/inscripcion/{especialidad}/", name="app_backend_estudiante_inscripcion")
     */
    public function inscripcionEstudianteAction($especialidad)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $lapsoac = $em->getRepository('AppBundle:Lapso')->find($this->get('session')->get('lapsoActual')->getId());
        $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
        
        $programa = $espeestud->getPrograma();
        $configPrograma = $em->getRepository('AppBundle:ConfigSistema')->findOneBy(array('programa'=>$programa->getId()));                
        $procesos = $em->getRepository('AppBundle:Procesos')->findProcesoActivoFech($lapsoac->getId(), 'PI');
                
        
        if(!$procesos){
            $this->get('session')->getFlashBag()->add('msg-error', 'Proceso cerrado para la fecha actual');
            return $this->redirect($this->generateUrl('app_homepage_estudiante'));
        }
        
        $depositado = $em->getRepository('AppBundle:Depositos')->findTotalDepositado($especialidad, $lapsoac->getId());
        $exoneracion = $em->getRepository('AppBundle:Exonerados')->getExeracionEstudiante($espeestud, $lapsoac);
        $cursosOfertados = $em->getRepository('AppBundle:OfertAcade')->findCursoOfertadoNew($espeestud->getEspecialidad()->getId(), $lapsoac->getId(), 0, $especialidad);
        $cursosInscritos = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($especialidad, $lapsoac->getId());
        
        $montoInscrito = $em->getRepository('AppBundle:Matricula')->getMontoInscritoEstudiante($cursosInscritos, $em, $configPrograma);
        
        $this->get('session')->set('config_act', array('configPrograma'=>$configPrograma, 'depositado'=>$depositado['depositado'],'montoInscrito'=>$montoInscrito, 'cursosInscritos'=>$cursosInscritos,'exonerado'=>$exoneracion));
        return $this->render('AppBundle:BackendEstudiantes:views/inscripcion/index.html.twig', array(
            'cursos'=>$cursosOfertados,
            'config'=>$configPrograma,            
            'cursosInscritos'=>$cursosInscritos,
            'especialidad'=>$especialidad,
            'depositado'=>$depositado,
            'montoInscrito'=>$montoInscrito
        ));    
    }
    
    /**
     * @Route("/app/backend/estudiantes/process/inscripcion/{especialidad}/", name="app_backend_estudiante_process_inscripcion")
     */
    public function processInscripcionEstudianteAction($especialidad, Request $request)
    {
        
        
        $cursosAInscri = json_decode($request->get('cursos'), true);
        $indexes = $request->get('indexes');
        $id = explode(',', $indexes);
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         
        $estudiante = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $config = $this->get('session')->get('config_act');
        $depositado = $config['depositado'];
        $montoInscripcion = $config['montoInscrito'];        
        $horarios = array();
        //echo $indexes;
        //var_dump($id);
        //var_dump($cursosAInscri);
        for($i = 0 ; $i < count($id); $i++)
        {
            
            $idofert = $cursosAInscri[$id[$i]]['oferta'];
            $idhorario = $cursosAInscri[$id[$i]]['horario'];            
            
            $horarios[$idofert]=array('oferta'=>$idofert, 'horario'=>$idhorario);
            $ofert = $em->getRepository('AppBundle:OfertAcade')->find($idofert); 
            $alumnos = $ofert->getCantidadAlumnos();
            $cupos = $ofert->getCantidadCupos();
            $montoInscripcion += $em->getRepository('AppBundle:Matricula')->getMontoUc($em, $ofert, $config['configPrograma']);
            
            if( $alumnos < $cupos ){                
                $matriculaExist = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudianteLapso($especialidad, $this->get('session')->get('lapsoActual')->getId(), $ofert->getCurso()->getId());
                
                if(!$matriculaExist){
                    
                    $matricula = new Matricula();                    
                    $condicion = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('nombre'=>'INSCRITO'));
                    $matricula->setOferta($ofert);
                    $matricula->setCondicion($condicion);
                    $matricula->setEstudiante($estudiante);
                    $em->persist($matricula);    
                    
                    
                }else{
                    $this->get('session')->getFlashBag()->add('msg-error', 'Curso señalado ya esta inscrito!');
                    $data['resp'] = true;        
                    $response[] = $data;
                    $respuesta = new Response(json_encode($response));
                    $respuesta->headers->set('Content-Type', 'application/json');
                    return $respuesta;
                }
            }else{
                $this->get('session')->getFlashBag()->add('msg-error', 'Curso señalado no tiene cupos disponibles');
                $data['resp'] = true;        
                $response[] = $data;
                $respuesta = new Response(json_encode($response));
                $respuesta->headers->set('Content-Type', 'application/json');
                return $respuesta;
            }
        }
        if(!$config['configPrograma']->getControlPago()){
            $sobrePasa = ($montoInscripcion<=$depositado)? 1 : 0;   
        }else{
            $sobrePasa = 1;
        }
        if(!$sobrePasa) {$this->get('session')->getFlashBag()->add('msg-error', 'El monto depositado es insuficiente para realizar la inscripción!');}        
        
        if($config['configPrograma']->getChoque()){
            $choque = $em->getRepository('AppBundle:OfertAcade')->choqueHorario($horarios, $config['cursosInscritos']);
        }else{
            $choque = 1;
        }
        
        if(!$choque){
            $this->get('session')->getFlashBag()->add('msg-error', 'Existe un choque de horario en los cursos señalados');
            $data['resp'] = true;        
            $response[] = $data;
            $respuesta = new Response(json_encode($response));
            $respuesta->headers->set('Content-Type', 'application/json');
            return $respuesta;
        }
        if($sobrePasa && $choque){
                $em->flush();
                foreach ($horarios as $o)
                {
                    $em->getRepository('AppBundle:OfertAcade')->updateOfertaMasUn($o['oferta']);
                }
                $this->get('session')->getFlashBag()->add('msg-success', 'Inscripción realizada con exito| '.$alumnos.'-'.$cupos.'!!');
        }        
        
        $data['resp'] = true;        
        $response[] = $data;
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }
    
    /**
     * @Route("/app/backend/estudiantes/delete/inscripcion/{especialidad}/{oferta}", name="app_backend_estudiante_delete_inscripcion")
     */
    public function deleteInscripcionEstudianteAction($especialidad, $oferta) {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $matricula = $em->getRepository('AppBundle:Matricula')->findOneBy(array('estudiante'=>$especialidad, 'oferta'=>$oferta));
        $em->remove($matricula);
        $em->getRepository('AppBundle:OfertAcade')->updateOfertaMenosUn($oferta);
        $em->flush();
        $this->get('session')->getFlashBag()->add('msg-success', 'Curso eliminado con exito!!');
        
        $data['resp'] = true;
        $response[] = $data;
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }
    
    /**
     * @Route("/app/backend/estudiantes/record/academico/{id}", name="app_backend_estudiante_record_academico")
     */
    public function reportRecordAcademicoAction(Request $request, $id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
     
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $entities = $em->getRepository('AppBundle:EspeEstud')->findHistMatri($espe_estud);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(15,25,85,10,10,20,25));
        //srand(microtime()*1000000);        
        $headerPage = array('Nombre y Apellido'=>$espe_estud->getEstudiante(), 
                        'Cédula'=>$espe_estud->getEstudiante()->getCedula(),
                        'Especialidad'=>$espe_estud->getEspecialidad()->getNombre(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Record Académico');
        $pdf->aligns = array('C','C', 'L', 'C', 'C', 'C', 'L');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Lapso', 'Código', 'Nombre del Curso', 'UC', 'Cal', 'UC*Cal', 'Condición');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $puntos = 0;
        $indiceac = 0;
        foreach ($entities as $value){
                 
             if($value->getCurso()->getComponentes()->getDescripcion()=='TRABAJO DE GRADO'){
              $nota = '';
              $uc = 0;
             $ucxnota = '';
            }else{
                 $nota = $value->getNota();
                 $uc = $value->getCurso()->getUc();
                 $ucxnota = $nota * $uc;
                 $puntos += $ucxnota;
                 $indiceac += $uc;
             } 
            $pdf->RowBorders(array($value->getLapso()->getCodigo(),
                                   $value->getCurso()->getCodigo(),
                                   $value->getCurso()->getNombre(),
                                   $uc,
                                   $nota,
                                   $ucxnota,
                                   $value->getCondicion()->getNombre(),
                            ), 0);
        }  
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(63,10,'Puntos: '.  number_format($puntos, 2, ',','.'),'T',0,'C');
        $pdf->Cell(64,10,'UC indice: '.$indiceac,'T',0,'C');
        $pdf->Cell(63,10,'IND*ACAD: '.@number_format($puntos/$indiceac,2,',','.'),'T',1,'C');
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $text1 = "UC= Unid. de Credito, IA= Indice Acad.(PTOS/UC), PTOS= Puntos(Suma de UC x C), C=Calificacion, CM= Cond. de Asig.; 3= Equiivalencia, 4= DOC. NoTrans.calf.,
6= Nota en Observa.,7= Prueba Extraor., 8= Sin Nota., 9= Inasistente.CM= 3,4,6,8 y 9 no afectan el Indice";
        $pdf->MultiCell(190, 3, $text1,0,'J');
        $text2 = "INDICE ACADEMICO CALCULADO SEGUN RESOLUCION No.2008.316.2818 EXAMINADA DEL CONSEJO UNIVERSIATRIO FECHA: 23 JULIO DE2008";
        $pdf->MultiCell(190, 3, $text2,0,'J');
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        $pdf->Cell(64,10,  utf8_decode('Jefe de la Sección de Control de Estudios'),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    
    /**
     * @Route("/app/backend/estudiantes/planilla/inscripcion/{id}", name="app_backend_estudiantes_planilla_inscripcion")
     */
    public function reportPlanillaInscripcionAction(Request $request, $id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
    


        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($this->get('session')->get('lapsoActual')->getId());
        $entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($espe_estud, $lapso);
                if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-success', 'No se encuentra inscrito para ese periodo!');
            return $this->redirect($this->generateUrl('app_homepage_estudiante'));
        }


        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(25,75,20,30,45));
        //srand(microtime()*1000000);        
        $headerPage = array('Nombre y Apellido'=>$espe_estud->getEstudiante(), 
                        'Cédula'=>$espe_estud->getEstudiante()->getCedula(),
                        'Especialidad'=>$espe_estud->getEspecialidad()->getNombre(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Planilla de Inscripción - '.$lapso->getCodigo());
        $pdf->aligns = array('C', 'L', 'C', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Código', 'Nombre del Curso', 'UC', 'Sección', 'Horario');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){
            $ucs+=$value->getOferta()->getCurso()->getUc();
            $pdf->RowBorders(array($value->getOferta()->getCurso()->getCodigo(),
                                   $value->getOferta()->getCurso()->getNombre(),
                                   $value->getOferta()->getCurso()->getUc(),
                                   $value->getOferta()->getSeccion(),
                                  
                                   $value->getOferta()->getHorario()
                            ), 0);
        }
         $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(100, 6,'Total UC: ','T',0,'R');
        $pdf->Cell(10, 6,$ucs,'T',0,'C');
        $pdf->Cell(80, 6,'','T',1,'L');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        $pdf->Cell(64,10,  utf8_decode('Jefe de la Sección de Control de Estudios'),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Planilla de Inscricipcion.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }


     

/**
     * @Route("/app/backend/estudiantes/planilla/constanciaestudio/{id}", name="app_backend_estudiantes_planilla_constancia")
     */
    public function reportPlanillaConstanciaAction(Request $request, $id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);

	$lapso = $em->getRepository('AppBundle:Lapso')->find($this->get('session')->get('lapsoActual')->getId());
//        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($espe_estud, $lapso);
       
        $subsedeausar = $espe_estud->getSubsede()->getId();
        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('subsede'=>$subsedeausar,'cargo'=>$cargo, 'activo'=>$activo));
        //$sede= $em->getRepository('AppBundle:Sede')->findByCodigo($ids);
        
        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-success', 'No se encuentra inscrito para ese periodo!');
            return $this->redirect($this->generateUrl('app_homepage_estudiante'));
        }
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();  
        $pdf->setSede($espe_estud->getSede());       
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(20,75,8,15,70));
        //srand(microtime()*1000000);        
        
         
        $pdf->titleReport(''.$espe_estud->getSede());
        
        $pdf->titleReport('Constancia de Estudios ');
         $pdf->Ln(6);
	
        $ucs = 0;
       

         foreach ($entities as $value){
            $ucs+=$value->getOferta()->getCurso()->getUc();
           
                  
        }

       // $fecha2 = new \DateTime();
       // $fecha2->format('d-m-Y');
        $pdf->Ln(2);

        //fecha en español*****************************************************
        $dia=date("l"); // dia en lunes martes etc
        
        if ($dia=="Monday") $dia="Lunes";
        if ($dia=="Tuesday") $dia="Martes";
        if ($dia=="Wednesday") $dia="Miércoles";
        if ($dia=="Thursday") $dia="Jueves";
        if ($dia=="Friday") $dia="Viernes";
        if ($dia=="Saturday") $dia="Sabado";
        if ($dia=="Sunday") $dia="Domingo";
        
        $mes=date("F"); //mes en enero febrero etc
        
        if ($mes=="January") $mes="Enero";
        if ($mes=="February") $mes="Febrero";
        if ($mes=="March") $mes="Marzo";
        if ($mes=="April") $mes="Abril";
        if ($mes=="May") $mes="Mayo";
        if ($mes=="June") $mes="Junio";
        if ($mes=="July") $mes="Julio";
        if ($mes=="August") $mes="Agosto";
        if ($mes=="September") $mes="Setiembre";
        if ($mes=="October") $mes="Octubre";
        if ($mes=="November") $mes="Noviembre";
        if ($mes=="December") $mes="Diciembre";
        
        $ano=date("Y"); // año completo 2017 
        $dia2=date("d");// solo dia en numero

        $fecha = date('j-m-Y');
        $nuevafecha = strtotime ( '+3 month' , strtotime ( $fecha ) ) ;
        $nuevafecha = date ( 'j/m/Y' , $nuevafecha );
        //fecha en español*****************************************************
        
        $text3 = "    Quien suscribe, ".$autoridad->getNombre().' '.$autoridad->getApellido() .' titular de la Cédula de identidad  N° '.$autoridad->getCedula() .' hace constar que el (la) ciudadano(a)  '.$espe_estud->getEstudiante()->getPrimerNombre().' '.$espe_estud->getEstudiante()->getSegundoNombre().' '.$espe_estud->getEstudiante()->getPrimerApellido(). ' '.$espe_estud->getEstudiante()->getSegundoApellido().
             " titular de la Cédula de identidad N°".$espe_estud->getEstudiante()->getCedula().
             ' cursa estudios en el '. $espe_estud->getSubsede()->getDescripcion() .' en la Especialidad de '.$espe_estud->getEspecialidad()->getNombre().
                '. Está inscrito(a) en el actual período académico ordinario '.$lapso->getCodigo().
                ' , hasta la fecha tiene '. $ucs  . ' Unidades Inscritas'.  ', Pertenece a la matrícula de ingreso '.$espe_estud->getCohorte().'.'.
        $pdf->SetFont('helvetica','',12);
        $pdf->MultiCell(190, 5,  utf8_decode($text3),0,'J');
  
                      
        $pdf->Ln(10);       
        $text4=   ' Constancia que se expide a solicitud de la parte interesada, a los '.$dia2.' días del mes de '. $mes  .' del año '.$ano .'.'.
                   
        $pdf->SetFont('helvetica','',12);
        $pdf->MultiCell(190, 5,  utf8_decode($text4),0,'J');
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(50);
        $pdf->Cell(63,10,'',0,0,'C');
        
        $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        $pdf->Ln(1);
        $pdf->Cell(0,0,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
        $pdf->Ln(8);
        
        $pdf->Cell(0,0,  utf8_decode('Sello'),'',0,'C');

        $pdf->Ln(40);
        $pdf->Cell(0,0,  utf8_decode('Vigente desde: '. $lapso->getFechaInicial().' hasta final del '.$lapso->getFechaFinal()),'',0,'');
        $pdf->Ln(4);
        $pdf->Cell(0,0,  utf8_decode('Va sin enmienda'),'',0,'');
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Constancia.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }




















}
