<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Procesos;
use AppBundle\Form\ProcesosType;
    

/**
 * Description of ProcesosController
 *
 * @author jose
 */
class ProcesosController extends Controller {
    
    /**
     * @Route("/app/admin/procesos", name="app_admin_procesos_index")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $query = "SELECT p FROM AppBundle:Procesos p "
                . "ORDER BY p.lapso DESC ";
        $entities = $em->createQuery($query);

        $fechanow = new \DateTime();        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                50          
        );
        
        return $this->render('AppBundle:Procesos:index.html.twig', array(
            'pagination'=>$pagination,
            'fechaactual'=>$fechanow
        ));
    }
    
    /**
     * @Route("/app/admin/edit/proceso/{id}", name="app_admin_edit_proceso")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Procesos')->find($id);
        $form = $this->editForm($entity, $em);
        
        return $this->render('AppBundle:Procesos:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/proceso/{id}", name="app_admin_update_proceso", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Procesos')->find($id);
        $form = $this->editForm($entity, $em);

        $fechaA = new \DateTime();
        $fechanow = $fechaA->format('Y-m-d');
        
        $form->handleRequest($request);
        if($form->isValid())
        {
        $data = $form->getData();
        $lapso = $data->getLapso();
        $codigo = $data->getCodigo();
        $procesoi= $em->getRepository('AppBundle:Procesos')->findOneByProcesoIN($fechanow, $codigo);
        $proceson= $em->getRepository('AppBundle:Procesos')->findOneByProcesoIN($fechanow, $codigo);
        $procesor= $em->getRepository('AppBundle:Procesos')->findOneByProcesoIN($fechanow, $codigo);
        $lapsoin = $em->getRepository('AppBundle:Procesos')->findLapsoIN($id, $lapso, $codigo);
        $lapsoeditar = $em->getRepository('AppBundle:Procesos')->findByLapsoEdit($id);
    
            if(!$procesoi && !$lapsoin && $codigo == 'PI'){

                $ids = $this->getUser()->getSede()->getCodigo();
                $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                $entity->setSede($sede);
                $em->persist($entity);
                $em->flush();
                $this->get('session')->getFlashBag()->add('msg-success','PROCESO DE INSCRIPCIÓN MODIFICADO');
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
            }

            if(!$proceson && !$lapsoin && $codigo == 'PN'){

                $ids = $this->getUser()->getSede()->getCodigo();
                $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                $entity->setSede($sede);
                $em->persist($entity);
                $em->flush();
                $this->get('session')->getFlashBag()->add('msg-success','PROCESO CARGA DE NOTAS MODIFICADO');
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
            }

            if(!$procesor && !$lapsoin && $codigo == 'PR'){

                $ids = $this->getUser()->getSede()->getCodigo();
                $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                $entity->setSede($sede);
                $em->persist($entity);
                $em->flush();
                $this->get('session')->getFlashBag()->add('msg-success','PROCESO DE RETIRO DE UNIDAD/EJE CURRICULAR MODIFICADO');
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
            }


            foreach ($procesoi as $proI){

                foreach ($lapsoeditar as $lapsoE){

                    if($lapso == $lapsoE->getLapso() && $proI->getLapso() == $lapsoE->getLapso() && !$lapsoin && $codigo == 'PI'){

                        $ids = $this->getUser()->getSede()->getCodigo();
                        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                        $entity->setSede($sede);

                        $em->persist($entity);
                        $em->flush();
                        $this->get('session')->getFlashBag()->add('msg-success', 'PROCESO DE INSCRIPCIÓN MODIFICADO');
                        return $this->redirect($this->generateUrl('app_admin_procesos_index'));
                    }   
                }
            }

            foreach ($proceson as $proN){

                foreach ($lapsoeditar as $lapsoE){

                    if($lapso == $lapsoE->getLapso() && $proN->getLapso() == $lapsoE->getLapso() && !$lapsoin && $codigo == 'PN'){

                        $ids = $this->getUser()->getSede()->getCodigo();
                        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                        $entity->setSede($sede);

                        $em->persist($entity);
                        $em->flush();
                        $this->get('session')->getFlashBag()->add('msg-success','PROCESO CARGA DE NOTAS MODIFICADO');
                        return $this->redirect($this->generateUrl('app_admin_procesos_index'));
                    }
                }
            }

            foreach ($procesor as $proR){

                foreach ($lapsoeditar as $lapsoE){

                    if($lapso == $lapsoE->getLapso() && $proR->getLapso() == $lapsoE->getLapso() && !$lapsoin && $codigo == 'PR'){

                        $ids = $this->getUser()->getSede()->getCodigo();
                        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                        $entity->setSede($sede);

                        $em->persist($entity);
                        $em->flush();
                        $this->get('session')->getFlashBag()->add('msg-success', 'PROCESO DE RETIRO DE UNIDAD/EJE CURRICULAR MODIFICADO');
                        return $this->redirect($this->generateUrl('app_admin_procesos_index'));
                    }   
                }
            }

            foreach ($procesoi as $proI){
                if($codigo == 'PI'){
                $this->get('session')->getFlashBag()->add('msg-error','PROCESO DE INSCRIPCIÓN ACTIVO: '.$proI->getLapso());
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
                }
            }

            foreach ($proceson as $proN){
                if($codigo == 'PN'){
                $this->get('session')->getFlashBag()->add('msg-error','PROCESO CARGA DE NOTAS ACTIVO: '.$proN->getLapso());
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
                }
            }

            foreach ($procesor as $proR){
                if($codigo == 'PR'){
                $this->get('session')->getFlashBag()->add('msg-error','PROCESO DE RETIRO DE UNIDAD/EJE CURRICULAR  ACTIVO: '.$proR->getLapso());
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
                }
            }
        
        }
        
        return $this->render('AppBundle:Procesos:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editForm(Procesos $entity, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new ProcesosType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_update_proceso', array('id'=>$entity->getId())),
            'method'=>'PUT'            
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        
        return $form;
    }


  /**
     * @Route("/app/admin/new/procesos", name="app_admin_procesos_new")
     */
    public function newAction()
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Procesos();
        $form = $this->newForm($entity, $em);
        
        return $this->render('AppBundle:Procesos:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/procesos", name="app_admin_procesos_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Procesos();
        $form = $this->newForm ($entity, $em);

        $fechanow = new \DateTime();
        $procesoi= $em->getRepository('AppBundle:Procesos')->findByProcesoI($fechanow);
        $proceson= $em->getRepository('AppBundle:Procesos')->findByProcesoN($fechanow);
        $procesor= $em->getRepository('AppBundle:Procesos')->findByProcesoR($fechanow);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $data = $form->getData();
            $lapso = $data->getLapso();
            $codigo = $data->getCodigo();
            $issetProcesoI = $em->getRepository('AppBundle:Procesos')->findOneByProcesoI($lapso);
            $issetProcesoN = $em->getRepository('AppBundle:Procesos')->findOneByProcesoN($lapso);
            $issetProcesoR = $em->getRepository('AppBundle:Procesos')->findOneByProcesoR($lapso);

            if($procesoi != NULL && $codigo == 'PI'){
                $this->get('session')->getFlashBag()->add('msg-error', 'EXISTE PROCESO DE INSCRIPCIÓN ACTIVO');
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
            }

            if($proceson != NULL && $codigo == 'PN'){
                $this->get('session')->getFlashBag()->add('msg-error', 'EXISTE PROCESO DE CARGA DE NOTA ACTIVO');
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
            }

            if($procesor != NULL && $codigo == 'PR'){
                $this->get('session')->getFlashBag()->add('msg-error', 'EXISTE PROCESO DE RETIRO DE UNIDAD/EJE CURRICULAR ACTIVO');
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
            }

            if(!$issetProcesoI && $codigo == 'PI'){
                $ids = $this->getUser()->getSede()->getCodigo();
                $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                $entity->setSede($sede);
                $em->persist($entity);
                $em->flush();
                $this->get('session')->getFlashBag()->add('msg-success', ' REGISTRO CREADO CON EXITO');
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
            }
            if(!$issetProcesoN && $codigo == 'PN'){
                $ids = $this->getUser()->getSede()->getCodigo();
                $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                $entity->setSede($sede);
                $em->persist($entity);
                $em->flush();
                $this->get('session')->getFlashBag()->add('msg-success', 'REGISTRO CREADO CON EXITO');
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
            }
            if(!$issetProcesoR && $codigo == 'PR'){
                $ids = $this->getUser()->getSede()->getCodigo();
                $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                $entity->setSede($sede);
                $em->persist($entity);
                $em->flush();
                $this->get('session')->getFlashBag()->add('msg-success', ' REGISTRO CREADO CON EXITO');
                return $this->redirect($this->generateUrl('app_admin_procesos_index'));
            }
            $this->get('session')->getFlashBag()->add('msg-error', 'REGISTRO YA EXISTE');
        }
        
        return $this->render('AppBundle:Procesos:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function newForm(Procesos $entity,  \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new ProcesosType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_procesos_create'),
            'method'=>'POST'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }





    
    
}
