<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Entity\Profesor;
use AppBundle\Form\ProfesorType;
use AppBundle\Utils\ReporteLayout;
use AppBundle\Utils\Util2;
use AppBundle\Utils\Util;
use UsersBundle\Entity\Users;
use Doctrine\ORM\EntityRepository;

/**
 * Description of ProfesoresController
 *
 * @author jose
 */
class ProfesoresController  extends Controller {
    
    /**
     * @Route("/app/admin/profesores", name="app_admin_profesores")
     */
    public function indexAction(){
        $form = $this->formConsultProfesor();
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT p FROM AppBundle:Profesor p "
                . "WHERE "
                . "p.cedula != 1 and p.activo != 0 "                                        
                . "ORDER BY p.cedula ASC ";
        $entities = $em->createQuery($query);        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Profesores:index.html.twig', array(
            'form'=>$form->createView(),
            'pagination'=>$pagination
        ));
    }
    
    private function formConsultProfesor(){
        $form = $this->createFormBuilder()
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/edit/profesor/{id}", name="app_admin_edit_profesor")
     */
    public function editProfesorAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Profesor')->find($id);
        $form = $this->formEditProfesor($entity, $em);
        $referer = $request->headers->get('referer');
        $this->get('session')->set('referer', $referer);
        
        return $this->render('AppBundle:Profesores:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }



/**
     * @Route("/app/admin/profesor", name="app_profesor_index")
     */
    public function indexProfesorAction()
    {
        $form = $this->formSearchProfesor();
        return $this->render('AppBundle:Profesores:index2.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/search/profesor", name="app_profesor_search", requirements={"_method":"GET"})
     */
    public function searchProfesorAction(Request $request)
    {

        $form = $request->get('form');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $lapsoid = $form['lapso'];
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $this->get('session')->set('periodoSelect', $lapso);

        $form = $this->formSearchProfesor();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $profesor = $em->getRepository('AppBundle:Profesor')->findOneBy(array('cedula'=>$cedula));
            $this->get('session')->set('datosProf', $profesor);
            
            if(!$profesor){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_profesor_index'));
            }
                   
            return $this->render('AppBundle:Profesores:result.html.twig', array(
                'datos'=>$profesor,
            ));
        
        }

        return $this->render('AppBundle:Profesores:index2.html.twig', array(
            'form'=>$form->createView()
        ));
    }
        
    private function formSearchProfesor()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_profesor_search'))
                ->setMethod('GET')
                ->add('cedula', 'text', array(
                    'attr'=>array('class'=>'form-control', 'style'=>'width:100%;')
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'mapped'=>false,
                    'em'=>$em,
                    'empty_value'=>'Seleccione',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('l');
                        $q->orderBy('l.codigo', 'DESC');
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:100%;'),                    
                ))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>' btn btn-default btn-flat fa fa-search')
                ))
                ->getForm()
            ;
        return $form;
    }






    /**
     * @Route("/app/admin/transcripcion/", name="app_admin_profesor_transcripcion")
     */
    public function cursosTranscripcionProfesorAction(Request $request)
    {
    
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));


        $profesor = $this->get('session')->get('datosProf');
        $lapsoSelect = $this->get('session')->get('periodoSelect');

        $cursosTransc = $em->getRepository('AppBundle:OfertAcade')->findCursoTransNew($profesor, $lapsoSelect);
        if(!$cursosTransc)
        {
            $this->get('session')->getFlashBag()->add('msg-error', 'NO TIENE CURSOS ASIGNADOS!');
            return $this->redirect($this->generateUrl('app_profesor_index'));
        }
        if($request->get('id')!==null)
        {
            $id = $request->get('id');
            $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
            $curso = $oferta->getCurso();
            $cursoEspecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
            $entities = $em->getRepository('AppBundle:Matricula')->findAlumnosByCursoA2($oferta);
            $condiciones = $em->getRepository('AppBundle:CondCurso')->findBy(array('codigo'=>array('APR', 'APLZ', 'PROC')));
            return $this->render('AppBundle:Profesores:result2.html.twig', array(
                'entities'=>$cursosTransc,
                'matricula'=>$entities, 
                'cursoisEspecial'=>$cursoEspecial,
                'conditions'=>$condiciones
            ));
        }
        
        return $this->render('AppBundle:Profesores:result2.html.twig', array(
            'entities'=>$cursosTransc
        ));
    }





 /**
     * @Route("/app/admin/profesor/process/transcripcion", name="app_admin_profesor_process_transcripcion")
     */
    public function procesarTranscripcionAdmin(Request $request )
    {
       $reqMatricula = $request->get('matricula');
        $reqNotas= $request->get('notas');
        $reqStatus= $request->get('status');
        $oferta_id = $request->get('ofertaid');

        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $conditionAprob = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'APR'));
        $conditionAplz  = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'APLZ'));
        $conditionProc  = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'PROC'));
        $oferta         = $em->getRepository('AppBundle:OfertAcade')->find($oferta_id);
        $curso          = $oferta->getCurso();
        $cursoEspecial  = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));

        $cualitativo = false;
        if($cursoEspecial)
            if($cursoEspecial->getModoTranscripcion()->getDescripcion()=='Cualitativo')
                $cualitativo = true;
            
        
        if(!$oferta)
            throw new Exception ("Oferta no encontrada");


        for ($i = 0; $i<count($reqMatricula); $i++)
        {
            $idM =  $reqMatricula[$i];
            $matricula = $em->getRepository('AppBundle:Matricula')->find($idM);
            $modificado = $matricula;

            if(!$matricula)
                throw new Exception ('No se encontro matricula seÃ±alada !!');
            $nota = $reqNotas[$i];

            if ($matricula->getNota()!=$nota){
                $matricula->setStatus('Modificado');
            }
           
            if(!$cualitativo){
                if($nota>=6)
                    $matricula->setCondicion($conditionAprob);
                elseif($nota<6)
                    $matricula->setCondicion($conditionAplz);

            }else{
                $condition = $em->getRepository('AppBundle:CondCurso')->find($nota);
                $matricula->setCondicion($condition);
            }

        //ACTUALIZAR Auditoria

            if ($matricula->getNota()!=$nota){
                    $cedula = $this->getUser()->getCedula();
                    $ids = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$cedula));
                    $usuarios = $em->getRepository('AppBundle:Usuarios')->find($ids); 
                    $auditoria = $em->getRepository('AppBundle:Auditoria')->findOneByMatricula($matricula->getId());
                    $matricula->setNota($nota);
                
                    $newAuditoria = new \AppBundle\Entity\Auditoria();
                    $newAuditoria->setMatricula($matricula);
                    $newAuditoria->setCondicion($matricula->getCondicion());
                    $newAuditoria->setCurso($matricula->getOferta()->getCurso());
                    $newAuditoria->setEspecialidad($matricula->getEstudiante()->getEspecialidad());
                    $newAuditoria->setUsuario($usuarios);
                    $newAuditoria->setEstudiante($matricula->getEstudiante());
                    $newAuditoria->setLapso($matricula->getOferta()->getLapso());
                    $newAuditoria->setNota($matricula->getNota());
                    $newAuditoria->setProceso('Proceso Modificacion ');
                    $newAuditoria->setPrograma($matricula->getOferta()->getPrograma());
                    $newAuditoria->setSede($matricula->getOferta()->getSede());
                    $newAuditoria->setFechaHora(new \DateTime("now"));
                    $newAuditoria->setSeccion($matricula->getOferta()->getSeccion());
                    $em->persist($newAuditoria);
            }
                 
        $em->persist($matricula);
            
            //ACTUALIZAR HIST_MATRI
            $histExist = $em->getRepository('AppBundle:HistMatri')->findOneByMatricula($matricula->getId());
                   if(!$histExist)
        {

            $newHistMatri = new \AppBundle\Entity\HistMatri();
                $newHistMatri->setMatricula($matricula);
                $newHistMatri->setCondicion($matricula->getCondicion());
                $newHistMatri->setCurso($matricula->getOferta()->getCurso());
                $newHistMatri->setEspecialidad($matricula->getEstudiante()->getEspecialidad());
                $newHistMatri->setEstudiante($matricula->getEstudiante());
                $newHistMatri->setLapso($matricula->getOferta()->getLapso());
                $newHistMatri->setNota($matricula->getNota());
                $newHistMatri->setObs('Pasado Matricula '.$matricula->getOferta()->getLapso()->getCodigo());
                $newHistMatri->setPrograma($matricula->getOferta()->getPrograma());
                $newHistMatri->setSede($matricula->getOferta()->getSede());
                $newHistMatri->setUc($matricula->getOferta()->getCurso()->getUc());
                $newHistMatri->setSeccion($matricula->getOferta()->getSeccion());
                $em->persist($newHistMatri);
          
        
            }else{
                $histExist->setMatricula($matricula);
                $histExist->setCondicion($matricula->getCondicion());
                $histExist->setCurso($matricula->getOferta()->getCurso());
                $histExist->setEspecialidad($matricula->getEstudiante()->getEspecialidad());
                $histExist->setEstudiante($matricula->getEstudiante());
                $histExist->setLapso($matricula->getOferta()->getLapso());
                $histExist->setNota($matricula->getNota());
                $histExist->setObs('Pasado Matricula '.$matricula->getOferta()->getLapso()->getCodigo());
                $histExist->setPrograma($matricula->getOferta()->getPrograma());
                $histExist->setSede($matricula->getOferta()->getSede());
                $histExist->setUc($matricula->getOferta()->getCurso()->getUc());
                $histExist->setSeccion($matricula->getOferta()->getSeccion());
                $em->persist($histExist);
            }
        }
        $em->persist($oferta);
        
        $em->flush();

        $this->get('session')->getFlashBag()->add('msg-success', 'Calificaciones Modificadas con Exito!');
        return $this->redirect($this->generateUrl('app_admin_profesor_transcripcion', array('id'=>$oferta->getId())));
    }






    /**
     * @Route("/app/admin/profesor/reportes/acta/{id}", name="app_admin_profesor_reporte_acta")
     */
    public function reportListadoClasesAdminAction($id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $curso          = $oferta->getCurso();
        $cursoEspecial  = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
        $cualitativo = false;
        if($cursoEspecial)
            if($cursoEspecial->getModoTranscripcion()->getDescripcion()=='Cualitativo')
                $cualitativo = true;
        
    
        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('cargo'=>$cargo, 'activo'=>$activo));
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesByOferta($oferta);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->setActa($oferta->getNumeroActa());
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(10,20,52,52,10,23,23));
        $pdf->SetAligns(array('C','C','L', 'L', 'C', 'C','C'));
        //srand(microtime()*1000000);
        
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->titleReport('Acta de Modificación');

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getPrograma()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(99,10,utf8_decode(''.$oferta->getEspecialidad()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Sección: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(20,10,utf8_decode(''.$oferta->getSeccion()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(11,10,utf8_decode('Curso: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(109,10,utf8_decode(''.$oferta->getCurso()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getLapso()),0,'L');
            $pdf->Ln(10);
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('N°','Cédula', 'Nombre', 'Apellidos', 'Nota','Condicion','Status');
        $pdf->RowTitles($titles); 
        
        $index = 1;
        $aplaz = 0;
        $aprob = 0;
        $proc = 0;

        foreach ($entities as $value){
            $nota = ($cualitativo) ? '':$value->getNota();

            if($value->getStatus()=='Modificado'){
           
            $pdf->RowBorders(array($index,
                    $value->getEstudiante()->getEstudiante()->getCedula(),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getEstudiante()->getSegundoNombre()),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getEstudiante()->getSegundoApellido()),
                    $nota,
                    $value->getCondicion(),
                    $value->getStatus(),

             ), 1);
            if($value->getCondicion()->getCodigo()=='APLZ'){
                $aplaz++;
            }elseif($value->getCondicion()->getCodigo()=='APR'){
                $aprob++;
            }elseif($value->getCondicion()->getCodigo()=='PROC'){
                $proc++;
            }
            
            $index++;
            }
        }  
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(($cualitativo)? 47.5: 120, 6,'Total estudiantes: '.count($entities), '',0,'L');
        $pdf->Cell(($cualitativo)? 47.5: 35, 6,'Total Aprobados: '.$aprob, '',0,'R');
        $pdf->Cell(($cualitativo)? 47.5: 35, 6,'Total Aplazado: '.($aplaz), '',0,'R');
        if($cualitativo)
            $pdf->Cell(47.5, 6,'Total En Proceso: '.($proc), '',1,'C');

        $pdf->SetFont('helvetica','B',9);
    $pdf->Ln(30);
        $pdf->Cell(63,10,  utf8_decode($oferta->getProfesor()),'T',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
    $pdf->Ln(5);
    $pdf->Cell(63,10,utf8_decode('C.I.: '.number_format($oferta->getProfesor()->getCedula(), 0, '', '.')),'',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
        $pdf->Cell(64, 10,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
    $pdf->Ln(5);
        $pdf->Cell(63,10,  utf8_decode(' Profesor(a)'),'',0,'C');
    $pdf->Ln(5);
    $pdf->Cell(63,10,'',0,0,'C');
    $pdf->Cell(64, 10,  utf8_decode('Sello'),'',0,'C');
    $pdf->Ln(5);
        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }





 /**
     * @Route("/app/admin/profesor/inclusion", name="app_profesor_inclusion")
     */
    public function indexProfesorInclusionAction()
    {
        $form = $this->formSearchProfesorinclusion();
        return $this->render('AppBundle:Profesores:inclusion/index2.html.twig', array(
            'form'=>$form->createView()
        ));
    }



    /**
     * @Route("/app/admin/search/profesor/inclusion", name="app_profesor_search_inclusion", requirements={"_method":"GET"})
     */
    public function searchProfesorinclusionAction(Request $request)
    {
        $form = $request->get('form');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $lapsoid = $form['lapso'];
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $this->get('session')->set('periodoSelect', $lapso);

        $form = $this->formSearchProfesorinclusion();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $profesor = $em->getRepository('AppBundle:Profesor')->findOneBy(array('cedula'=>$cedula));
            $this->get('session')->set('datosProf', $profesor);

            if(!$profesor){
                    $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                    return $this->redirect($this->generateUrl('app_profesor_inclusion'));
                }
    
            return $this->render('AppBundle:Profesores:inclusion/result.html.twig', array(
                'datos'=>$profesor,
            ));
        
        }

        return $this->render('AppBundle:Profesores:inclusion/index2.html.twig', array(
            'form'=>$form->createView()
        ));
    }
        
    private function formSearchProfesorinclusion()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_profesor_search_inclusion'))
                ->setMethod('GET')
                ->add('cedula', 'text', array(
                    'attr'=>array('class'=>'form-control', 'style'=>'width:100%;')
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'mapped'=>false,
                    'em'=>$em,
                    'empty_value'=>'Seleccione',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('l');
                        $q->orderBy('l.codigo', 'DESC');
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:100%;'),                    
                ))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>' btn btn-default btn-flat fa fa-search')
                ))
                ->getForm()
            ;
        return $form;
    }






 /**
     * @Route("/app/admin/inclusion/", name="app_admin_profesor_inclusion")
     */
    public function cursosInclusionProfesorAction(Request $request)
    {
    
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));


        $profesor = $this->get('session')->get('datosProf');
        $lapsoSelect = $this->get('session')->get('periodoSelect');

        $cursosTransc = $em->getRepository('AppBundle:OfertAcade')->findCursoTransNew($profesor, $lapsoSelect);
        if(!$cursosTransc)
        {
            $this->get('session')->getFlashBag()->add('msg-error', 'NO TIENE CURSOS ASIGNADOS!');
            return $this->redirect($this->generateUrl('app_profesor_inclusion'));
        }
        if($request->get('id')!==null)
        {
            $id = $request->get('id');
            $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
            $curso = $oferta->getCurso();
            $cursoEspecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
            $entities = $em->getRepository('AppBundle:Matricula')->findAlumnosByCursoA3($oferta);
            if(!$entities){
                $entities = $em->getRepository('AppBundle:Matricula')->findAlumnosByCursoA4($oferta);
            }

            $condiciones = $em->getRepository('AppBundle:CondCurso')->findBy(array('codigo'=>array('APR', 'APLZ', 'PROC')));
            return $this->render('AppBundle:Profesores:inclusion/result2.html.twig', array(
                'entities'=>$cursosTransc,
                'matricula'=>$entities, 
                'cursoisEspecial'=>$cursoEspecial,
                'conditions'=>$condiciones
            ));
        }
        
        return $this->render('AppBundle:Profesores:inclusion/result2.html.twig', array(
            'entities'=>$cursosTransc
        ));
    }





 /**
     * @Route("/app/admin/profesor/process/inclusion", name="app_admin_profesor_process_inclusion")
     */
    public function procesarInclusionAdmin(Request $request)
    {
        $reqMatricula = $request->get('matricula');
        $reqNotas= $request->get('notas');
        $reqStatus= $request->get('status');
        $oferta_id = $request->get('ofertaid');

        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $conditionAprob = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'APR'));
        $conditionAplz  = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'APLZ'));
        $conditionProc  = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'PROC'));
        $oferta         = $em->getRepository('AppBundle:OfertAcade')->find($oferta_id);
        $curso          = $oferta->getCurso();
        $cursoEspecial  = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));

        $cualitativo = false;
        if($cursoEspecial)
            if($cursoEspecial->getModoTranscripcion()->getDescripcion()=='Cualitativo')
                $cualitativo = true;
            
        
        if(!$oferta)
            throw new Exception ("Oferta no encontrada");


        for ($i = 0; $i<count($reqMatricula); $i++)
        {
            $idM =  $reqMatricula[$i];
            $matricula = $em->getRepository('AppBundle:Matricula')->find($idM);
            if(!$matricula)
                throw new Exception ('No se encontro matricula señalada !!');
            $nota = $reqNotas[$i];

            if(!$cualitativo){
                if($nota>=6)
                    $matricula->setCondicion($conditionAprob);
                elseif($nota<6)
                    $matricula->setCondicion($conditionAplz);
            }else{
                $condition = $em->getRepository('AppBundle:CondCurso')->find($nota);
                $matricula->setCondicion($condition);

            }

            //ACTUALIZAR Auditoria
            $cedula = $this->getUser()->getCedula();
            $ids = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$cedula));
            $usuarios = $em->getRepository('AppBundle:Usuarios')->find($ids); 
            $auditoria = $em->getRepository('AppBundle:Auditoria')->findOneByMatricula($matricula->getId());
            $matricula->setNota($nota);
            if(!$auditoria)
            {

                $newAuditoria = new \AppBundle\Entity\Auditoria();
                $newAuditoria->setMatricula($matricula);
                $newAuditoria->setCondicion($matricula->getCondicion());
                $newAuditoria->setCurso($matricula->getOferta()->getCurso());
                $newAuditoria->setEspecialidad($matricula->getEstudiante()->getEspecialidad());
                $newAuditoria->setUsuario($usuarios);
                $newAuditoria->setEstudiante($matricula->getEstudiante());
                $newAuditoria->setLapso($matricula->getOferta()->getLapso());
                $newAuditoria->setNota($matricula->getNota());
                $newAuditoria->setProceso('Proceso Inclusion ');
                $newAuditoria->setPrograma($matricula->getOferta()->getPrograma());
                $newAuditoria->setSede($matricula->getOferta()->getSede());
                $newAuditoria->setFechaHora(new \DateTime("now"));
                $newAuditoria->setSeccion($matricula->getOferta()->getSeccion());
                $em->persist($newAuditoria);
          
        
            }else{
                $this->get('session')->getFlashBag()->add('msg-error', 'NO PUEDE VOLVER A CARGAR CALIFICACIONES! '. $matricula->getId());
            return $this->redirect($this->generateUrl('app_admin_profesor_inclusion', array('id'=>$oferta->getId())));
            }

            $entity = $em->getRepository('AppBundle:Matricula')->find($idM);

            
            $entity->setStatus('Incluido');
            $em->persist($matricula);
            
            //ACTUALIZAR HIST_MATRI
            $histExist = $em->getRepository('AppBundle:HistMatri')->findOneByMatricula($matricula->getId());
                   if(!$histExist)
        {

            $newHistMatri = new \AppBundle\Entity\HistMatri();
                $newHistMatri->setMatricula($matricula);
                $newHistMatri->setCondicion($matricula->getCondicion());
                $newHistMatri->setCurso($matricula->getOferta()->getCurso());
                $newHistMatri->setEspecialidad($matricula->getEstudiante()->getEspecialidad());
                $newHistMatri->setEstudiante($matricula->getEstudiante());
                $newHistMatri->setLapso($matricula->getOferta()->getLapso());
                $newHistMatri->setNota($matricula->getNota());
                $newHistMatri->setObs('Pasado Matricula '.$matricula->getOferta()->getLapso()->getCodigo());
                $newHistMatri->setPrograma($matricula->getOferta()->getPrograma());
                $newHistMatri->setSede($matricula->getOferta()->getSede());
                $newHistMatri->setUc($matricula->getOferta()->getCurso()->getUc());
                $newHistMatri->setSeccion($matricula->getOferta()->getSeccion());
                $em->persist($newHistMatri);
          
        
            }else{
                  $this->get('session')->getFlashBag()->add('msg-error', 'NO PUEDE VOLVER A CARGAR CALIFICACIONES! 2');
            return $this->redirect($this->generateUrl('app_admin_profesor_inclusion', array('id'=>$oferta->getId())));
                
            }
        }
        $em->persist($oferta);
        
        $em->flush();
        
        $this->get('session')->getFlashBag()->add('msg-success', 'Datos Incluidos con Exito !');
        return $this->redirect($this->generateUrl('app_admin_profesor_inclusion', array('id'=>$oferta->getId())));
    }






    /**
     * @Route("/app/admin/profesor/reportes/inclusion/{id}", name="app_admin_profesor_reporte_inclusion")
     */
    public function reportListadoInclusionAdminAction($id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $curso          = $oferta->getCurso();
        $cursoEspecial  = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
        $cualitativo = false;
        if($cursoEspecial)
            if($cursoEspecial->getModoTranscripcion()->getDescripcion()=='Cualitativo')
                $cualitativo = true;
        
    
        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('cargo'=>$cargo, 'activo'=>$activo));
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesByOferta($oferta);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->setActa($oferta->getNumeroActa());
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(10,20,52,52,10,23,23));
        $pdf->SetAligns(array('C','C','L', 'L', 'C', 'C','C'));
        //srand(microtime()*1000000);
        
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->titleReport('Acta de Inclusión');

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getPrograma()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(99,10,utf8_decode(''.$oferta->getEspecialidad()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Sección: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(20,10,utf8_decode(''.$oferta->getSeccion()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(11,10,utf8_decode('Curso: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(109,10,utf8_decode(''.$oferta->getCurso()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getLapso()),0,'L');
            $pdf->Ln(10);
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('N°','Cédula', 'Nombre', 'Apellidos', 'Nota','Condicion','Status');
        $pdf->RowTitles($titles); 
        
        $index = 1;
        $aplaz = 0;
        $aprob = 0;
        $proc = 0;

        foreach ($entities as $value){
            $nota = ($cualitativo) ? '':$value->getNota();

            if($value->getStatus()=='Incluido'){
           
            $pdf->RowBorders(array($index,
                    $value->getEstudiante()->getEstudiante()->getCedula(),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getEstudiante()->getSegundoNombre()),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getEstudiante()->getSegundoApellido()),
                    $nota,
                    $value->getCondicion(),
                    $value->getStatus(),

             ), 1);
            if($value->getCondicion()->getCodigo()=='APLZ'){
                $aplaz++;
            }elseif($value->getCondicion()->getCodigo()=='APR'){
                $aprob++;
            }elseif($value->getCondicion()->getCodigo()=='PROC'){
                $proc++;
            }
            
            $index++;
            }
        }  
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(($cualitativo)? 47.5: 120, 6,'Total estudiantes: '.count($entities), '',0,'L');
        $pdf->Cell(($cualitativo)? 47.5: 35, 6,'Total Aprobados: '.$aprob, '',0,'R');
        $pdf->Cell(($cualitativo)? 47.5: 35, 6,'Total Aplazado: '.($aplaz), '',0,'R');
        if($cualitativo)
            $pdf->Cell(47.5, 6,'Total En Proceso: '.($proc), '',1,'C');

        $pdf->SetFont('helvetica','B',9);
    $pdf->Ln(30);
        $pdf->Cell(63,10,  utf8_decode($oferta->getProfesor()),'T',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
    $pdf->Ln(5);
    $pdf->Cell(63,10,utf8_decode('C.I.: '.number_format($oferta->getProfesor()->getCedula(), 0, '', '.')),'',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
        $pdf->Cell(64, 10,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
    $pdf->Ln(5);
        $pdf->Cell(63,10,  utf8_decode(' Profesor(a)'),'',0,'C');
    $pdf->Ln(5);
    $pdf->Cell(63,10,'',0,0,'C');
    $pdf->Cell(64, 10,  utf8_decode('Sello'),'',0,'C');
    $pdf->Ln(5);
        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }



    
    /**
     * @Route("/app/admin/update/profesor/{id}", name="app_admin_update_profesor", requirements={"_method":"PUT"})
     */








    
    /**
     * @Route("/app/admin/update/profesor/{id}", name="app_admin_update_profesor", requirements={"_method":"PUT"})
     */
    public function updateProfesorAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Profesor')->find($id);

        $em2 = $this->getDoctrine()->getManager();
        $cedulaprofesor = $entity->getCedula();
    //echo $cedulausuario;die();
        $entity2 = $em2->getRepository('UsersBundle:Users')->findOneBy(array('cedula'=>$cedulaprofesor, 'email'=>$entity->getEmail()));
//  var_dump($iduser); die();
     //   $entities2 = $em2->getRepository('UsersBundle:Users')->find($iduser->getId());


        $form = $this->formEditProfesor($entity, $em);
        
    
        $form->handleRequest($request);
        if($form->isValid())
        {
            if ($form->get('submit')->isClicked()) {
            $em->persist($entity);
            $em->flush();

            //$password = $this->get('request')->request->get('password');
            $password = $entity->getPassword();
            $email = $entity->getEmail();
            $cedula = $entity->getCedula();
            $encoder  = $this->get('security.encoder_factory')->getEncoder($entity2);
            $entity2->setSalt(md5(time()));
            $passwordCodifi = $encoder->encodePassword($password, $entity2->getSalt());
            $entity2->setPassword($passwordCodifi);
            $entity2->setEmail($email);
            $entity2->setCedula($cedula);

            $em2->persist($entity2);
            $em2->flush();

            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
          } 
        
            //return $this->redirect($this->generateUrl('app_admin_profesores'));
            return $this->redirect($this->get('session')->get('referer'));
        }
        
        return $this->render('AppBundle:Profesores:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }



    private function formEditProfesor(Profesor $entity, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new ProfesorType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_update_profesor', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/new/profesor", name="app_admin_new_profesor")
     */
    public function newProfesorAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Profesor();
        $form = $this->formCreateProfesor($entity, $em);
        
        return $this->render('AppBundle:Profesores:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/profesor", name="app_admin_create_profesor", requirements={"_method":"POST"})
     */
    public function createProfesorAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getManager();
        $user = new Users();
        
        $entity = new Profesor();
        $form = $this->formCreateProfesor($entity, $em);
        
        $form->handleRequest($request);
        $util = new Util2();
        
        
        if($form->isValid())
        {
            $data = $form->getData();
            $cedula = $data->getCedula();
            $nombre = $data->getPrimerNombre().' '.$data->getPrimerApellido();
            $email = $data->getEmail();            
            $password = $util->generarPassword(10);            
            $encoder  = $this->get('security.encoder_factory')->getEncoder($user);
            $user->setSalt(md5(time()));
            $passwordCodifi = $encoder->encodePassword($password, $user->getSalt());
            $issetUsuarioE = $em2->getRepository('UsersBundle:Users')->findBy(['email'=>$email]);
            $issetUsuarioC = $em->getRepository('AppBundle:Profesor')->findBy(['cedula'=>$cedula]);
        if(!$issetUsuarioE and !$issetUsuarioC){
              $user->setNombre($nombre);
              $user->setCedula($cedula);
              $user->setEmail($email);
              $user->setPassword($passwordCodifi);
              $role = $em2->getRepository('UsersBundle:Role')->findOneBy(array('name'=>'ROLE_PROF'));
              $user->addUserRole($role);
              $user->setSede($this->getUser()->getSede());
              $user->setActive(1);
            
              $entity->setPassword($password);
              $em2->persist($user);
            }else if ($issetUsuarioE){
               $this->get('session')->getFlashBag()->add('msg-error', 'CORREO YA REGISTRADO');
               return $this->redirect($this->generateUrl('app_admin_new_profesor'));
            }else{
               $this->get('session')->getFlashBag()->add('msg-error', 'CÉDULA YA REGISTRADA');
               return $this->redirect($this->generateUrl('app_admin_new_profesor'));
            }
            
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
            $entity->setSede($sede);
            $em->persist($entity);
            $em->flush();
            $em2->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro guardado con exito!');
            return $this->redirect($this->generateUrl('app_admin_profesores'));
        }
        
        return $this->render('AppBundle:Profesores:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formCreateProfesor(Profesor $entity, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new ProfesorType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_create_profesor'),
            'method'=>'POST'            
        ))
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/search/profesores", name="app_admin_profesores_search")
     */
    public function searchAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
        $query = "SELECT p FROM AppBundle:Profesor p "
                . "WHERE "
                . "p.cedula != 1 AND "
                . "p.cedula LIKE :text OR "
                . "p.primer_nombre LIKE :text OR "                                       
                . "p.primer_apellido LIKE :text "                                                       
                . "ORDER BY p.cedula ASC ";
        $entities = $em->createQuery($query);
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Profesores:index.html.twig', array(            
            'pagination'=>$pagination
        ));
    }

    //CLAVE POR DEFECTO//

    /**
     * @Route("/app/admin/defaultprofeores/profe", name="app_profesor_default")
     */
    public function defaultProfesoresAction()
    {
        $form = $this->formSearchProfesores();
        return $this->render('AppBundle:Profesores:profdefault.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    private function formSearchProfesores()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_profe_default_search'))
                ->setMethod('POST')
                ->add('cedula', 'number', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat pull-center')))
                ->getForm()
            ;
        return $form;
    }

    /**
     * @Route("/app/admin/search/defaultprofe/usuario", name="app_profe_default_search", requirements={"_method":"POST"})
     */
    public function searchDefaultProfeAction(Request $request)
    {
        $form = $this->formSearchProfesores();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $profesor = $em->getRepository('AppBundle:Profesor')->findOneBy(array('cedula'=>$cedula));
             $this->get('session')->set('datos', $profesor);
            if(!$profesor){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_profesor_default'));
            }
            
            return $this->redirect($this->generateUrl('app_profesores_default', array('id'=>$profesor->getId())));
        }

        $this->get('session')->getFlashBag()->add('msg-error', 'INGRESAR SÓLO DATOS NUMÉRICOS!');
        return $this->render('AppBundle:Profesores:profdefault.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/profesor/default/", name="app_profesores_default")
     */
    public function defaultAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $id = $request->get('id');
        $entities = $em->getRepository('AppBundle:Profesor')->find($id);
        $form = $this->formDefault($entities, $em);
                    
        return $this->render('AppBundle:Profesores:default.html.twig', array(
            'form'=>$form->createView()
        ));
    }

     private function formDefault(Profesor $entities, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new ProfesorType($em), $entities, array(
            'action'=>$this->generateUrl('app_profesor_update_default', array('id'=>$entities->getId())),
            'method'=>'PUT')) 
             ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')));
             
        return $form;
    }

    /**
     * @Route("/app/admin/profesor/pordefecto/{id}", name="app_profesor_update_default", requirements={"_method":"PUT"})
     */
    public function updateDefaultAction($id, Request $request)
    {

        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:Profesor')->find($id);

        $em2 = $this->getDoctrine()->getManager();
        $cedulausuario = $entities->getCedula();
        $user = new Users();

        $form = $this->formDefault($entities, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            
            if ($form->get('submit')->isClicked()) {

                $email = $entities->getEmail();
                $cedula = $entities->getCedula();
                $nombre = $entities->getPrimerNombre().' '.$entities->getPrimerApellido();
                $issetUsuario = $em2->getRepository('UsersBundle:Users')->findBy(['email'=>$email]);

                    if(!$issetUsuario){

                        $user->setPassword('Uf1vaGnEInV9dFNFQJzqbcqFAHMVwMgULoo+gjhnb5jufBqQ26sqGI4kk0q7HENNZ/9nI2Azd5N/VRQI+TdE1w==');
                        $user->setSalt('fa34eb5f39aff72e95c8437eda86882b');
                        $user->setEmail($email);
                        $user->setCedula($cedula);
                        $user->setNombre($nombre);

                        $role = $em2->getRepository('UsersBundle:Role')->findOneBy(array('name'=>'ROLE_PROF'));
                        $user->addUserRole($role);
                        $user->setSede($this->getUser()->getSede());
                        $user->setActive(1);

                        $em2->persist($user);
                        $em2->flush();

                    }else{

                        $this->get('session')->getFlashBag()->add('msg-error', 'Correo ya registrado');

                        return $this->redirect($this->generateUrl('app_profesor_default'));
                    }

                $entities->setPassword('23181');
                $em->persist($entities);
                $em->flush();
                $em2->flush();

            }

            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
            return $this->redirect($this->generateUrl('app_admin_profesores'));
        }
        
        return $this->render('AppBundle:Profesores:default.html.twig', array(
            'form'=>$form->createView()
        ));
    }
                
} 
