<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\SubSede;
use AppBundle\Form\SubSedeType;

/**
 * Description of SubSedeController
 *
 * @author jose
 */
class SubSedeController extends Controller {
    


    /**
     *  @Route("/app/admin/subsede", name="app_admin_subsede_index")
     */
    public function indexAction()
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT l FROM AppBundle:SubSede l "
                . "ORDER BY l.codigo DESC ";
        $entities = $em->createQuery($query);        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:SubSede:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     *  @Route("/app/admin/search/subsede", name="app_admin_subsede_search_index")
     */
    public function searchAction(Request $request)
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
        $query = "SELECT l FROM AppBundle:SubSede l "
                . "WHERE "
                . "l.codigo LIKE :text "
                . "ORDER BY l.codigo DESC ";
        $entities = $em->createQuery($query);        
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:SubSede:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     * @Route("/app/admin/edit/subsede/{id}", name="app_admin_subsede_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:SubSede')->find($id);        
        $form = $this->editForm($entity);
        
        return $this->render('AppBundle:SubSede:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/subsede/{id}", name="app_admin_subsede_update", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:SubSede')->find($id);        
        $form = $this->editForm($entity);
        
        $form->handleRequest($request);
        
        if($form->isValid())
        {
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
            return $this->redirect($this->generateUrl('app_admin_subsede_index'));
        }
        
        return $this->render('AppBundle:SubSede:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editForm(SubSede $entity)
    {
        $form = $this->createForm(new SubSedeType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_subsede_update', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/new/subsede", name="app_admin_subsede_new")
     */
    public function newAction()
    {
        $entity = new SubSede();
        $form = $this->newForm($entity);
        
        return $this->render('AppBundle:SubSede:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/subsede", name="app_admin_subsede_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $entity = new SubSede();
        $form = $this->newForm($entity);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro creado con exito!');
            return $this->redirect($this->generateUrl('app_admin_subsede_index'));
        }
        
        return $this->render('AppBundle:SubSede:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function newForm(SubSede $entity)
    {
        $form = $this->createForm(new SubSedeType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_subsede_create'),
            'method'=>'POST'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
}