<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AuditoriaEspe
 *
 * @ORM\Table(name="auditoria_retiro")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\AuditoriaRetiroRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class AuditoriaRetiro
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**

     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="auditoria_retiro")

     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")

     */
    private $estudiante;

    /**

     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="auditoria_retiro")

     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")

     */
    private $lapso;

    /**

     * @ORM\ManyToOne(targetEntity="Cursos", inversedBy="auditoria_retiro")

     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")

     */
    private $curso;

    /**
     * @ORM\ManyToOne(targetEntity="Usuarios", inversedBy="auditoria_retiro")

     * @ORM\JoinColumn(name="usuario_id", referencedColumnName="id")
     */
    private $usuarios;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fecha_hora", type="datetime")
     */
    private $fechaHora;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo", type="string", length=50)
     */
    private $tipo;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set estudiante
     *
     * @param integer $estudiante
     *
     * @return AuditoriaRetiro
     */
    public function setEstudiante($estudiante)
    {
        $this->estudiante = $estudiante;

        return $this;
    }

    /**
     * Get estudiante
     *
     * @return integer
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set lapso
     *
     * @param integer $lapso
     *
     * @return AuditoriaRetiro
     */
    public function setLapso($lapso)
    {
        $this->lapso = $lapso;

        return $this;
    }

    /**
     * Get lapso
     *
     * @return integer
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set curso
     *
     * @param integer $curso
     *
     * @return AuditoriaRetiro
     */
    public function setCurso($curso)
    {
        $this->curso = $curso;

        return $this;
    }

    /**
     * Get curso
     *
     * @return integer
     */
    public function getCurso()
    {
        return $this->curso;
    }

    /**
     * Set usuarios
     *
     * @param integer $usuarios
     *
     * @return AuditoriaRetiro
     */
    public function setUsuarios($usuarios)
    {
        $this->usuarios = $usuarios;

        return $this;
    }

    /**
     * Get usuarios
     *
     * @return integer
     */
    public function getUsuarios()
    {
        return $this->usuarios;
    }

    /**
     * Set fechaHora
     *
     * @param \DateTime $fechaHora
     *
     * @return AuditoriaRetiro
     */
    public function setFechaHora($fechaHora)
    {
        $this->fechaHora = $fechaHora;

        return $this;
    }

    /**
     * Get fechaHora
     *
     * @return \DateTime
     */
    public function getFechaHora()
    {
        return $this->fechaHora;
    }

    /**
     * Set tipo
     *
     * @param string $tipo
     *
     * @return AuditoriaRetiro
     */
    public function setTipo($tipo)
    {
        $this->tipo = $tipo;

        return $this;
    }

    /**
     * Get tipo
     *
     * @return string
     */
    public function getTipo()
    {
        return $this->tipo;
    }
}

