<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="cond_depositos")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\CondDepositosRepository")
 */
class CondDepositos {
   
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=35)
     */
    protected $descripcion;
    
    /**
     * @ORM\OneToMany(targetEntity="Depositos", mappedBy="conddepositos")
     */
    protected $depositos;
    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->depositos = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     * @return CondDepositos
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;
    
        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string 
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Add depositos
     *
     * @param AppBundle\Entity\Depositos $depositos
     * @return CondDepositos
     */
    public function addDeposito(\AppBundle\Entity\Depositos $depositos)
    {
        $this->depositos[] = $depositos;
    
        return $this;
    }

    /**
     * Remove depositos
     *
     * @param AppBundle\Entity\Depositos $depositos
     */
    public function removeDeposito(\AppBundle\Entity\Depositos $depositos)
    {
        $this->depositos->removeElement($depositos);
    }

    /**
     * Get depositos
     *
     * @return Doctrine\Common\Collections\Collection 
     */
    public function getDepositos()
    {
        return $this->depositos;
    }
    
    // Metodo Para Mostrar Condicion
    
    public function __toString(){
        return $this->getDescripcion();
    }
}
