<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\File\UploadedFile;

use AppBundle\Utils\TVimageManipulation;

/**
 * @ORM\Table(name="depositos")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\DepositosRepository")
 */
class Depositos {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="depositos")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;
    
    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="depositos")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;
    
    /**
     * @ORM\Column(type="string", length=10)
     */
    protected $num_deposito;

    /**
     * @ORM\Column(type="float", scale=2)
     */
    protected $monto;

    /**
     * @ORM\ManyToOne(targetEntity="CondDepositos", inversedBy="depositos")
     * @ORM\JoinColumn(name="conddeposidos_id", referencedColumnName="id")
     */
    protected $conddepositos;
    
    /**
     * @ORM\Column(type="date")
     */
    protected $fecha_deposito;

    /**
     * @ORM\ManyToOne(targetEntity="Sessiones", inversedBy="depositos")
     * @ORM\JoinColumn(name="session_id", referencedColumnName="id")
     */
    protected $session;
    
    /**
     * @ORM\Column(type="string", length=100, nullable=true)  
     */
    protected $file_bauche;
    
    /**
     * @Assert\File(mimeTypes={"image/png", "image/jpeg", "image/jpg", "image/gif"}, mimeTypesMessage = "Archivos Aceptados PNG,JPEG,JPG,GIF")
     */
    private $file;

    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="depositos")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;

    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="depositos")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;
    
    // METODOS GENERADOS PARA LAS CONSULTAS //
    

    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set monto
     *
     * @param float $monto
     * @return Depositos
     */
    public function setMonto($monto)
    {
        $this->monto = $monto;
    
        return $this;
    }

    /**
     * Get monto
     *
     * @return float 
     */
    public function getMonto()
    {
        return $this->monto;
    }

    /**
     * Set estudiante
     *
     * @param AppBundle\Entity\EspeEstud $estudiante
     * @return Depositos
     */
    public function setEstudiante(\AppBundle\Entity\EspeEstud $estudiante = null)
    {
        $this->estudiante = $estudiante;
    
        return $this;
    }

    /**
     * Get estudiante
     *
     * @return AppBundle\Entity\EspeEstud 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set lapso
     *
     * @param AppBundle\Entity\Lapso $lapso
     * @return Depositos
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return AppBundle\Entity\Lapso 
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set conddepositos
     *
     * @param AppBundle\Entity\CondDepositos $conddepositos
     * @return Depositos
     */
    public function setConddepositos(\AppBundle\Entity\CondDepositos $conddepositos = null)
    {
        $this->conddepositos = $conddepositos;
    
        return $this;
    }

    /**
     * Get conddepositos
     *
     * @return AppBundle\Entity\CondDepositos 
     */
    public function getConddepositos()
    {
        return $this->conddepositos;
    }

    /**
     * Set num_deposito
     *
     * @param string $numDeposito
     * @return Depositos
     */
    public function setNumDeposito($numDeposito)
    {
        $this->num_deposito = $numDeposito;
    
        return $this;
    }

    /**
     * Get num_deposito
     *
     * @return string 
     */
    public function getNumDeposito()
    {
        return $this->num_deposito;
    }

    /**
     * Set fecha_deposito
     *
     * @param \DateTime $fechaDeposito
     * @return Depositos
     */
    public function setFechaDeposito($fechaDeposito)
    {
        $this->fecha_deposito = $fechaDeposito;
    
        return $this;
    }

    /**
     * Get fecha_deposito
     *
     * @return \DateTime 
     */
    public function getFechaDeposito()
    {
        return $this->fecha_deposito;
    }

    /**
     * Set session
     *
     * @param \AppBundle\Entity\Sessiones $session
     * @return Depositos
     */
    public function setSession(\AppBundle\Entity\Sessiones $session = null)
    {
        $this->session = $session;
    
        return $this;
    }

    /**
     * Get session
     *
     * @return \AppBundle\Entity\Sessiones 
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Set fileBauche
     *
     * @param string $fileBauche
     *
     * @return Depositos
     */
    public function setFileBauche($fileBauche)
    {
        $this->file_bauche = $fileBauche;

        return $this;
    }

    /**
     * Get fileBauche
     *
     * @return string
     */
    public function getFileBauche()
    {
        return $this->file_bauche;
    }
    
    public function subirFotoBauche($directorio)
    {
        if (null === $this->getFile()) {
            return;
        }

        if(is_file($directorio.'/'.$this->getFileBauche())){
            unlink($directorio.'/'.$this->getFileBauche);
        }
        $nombreArchivoFoto = md5(time()).'.'.$this->getFile()->guessExtension();
        $this->getFile()->move($directorio, $nombreArchivoFoto);
        $this->crop($directorio, $nombreArchivoFoto);
        $this->file_bauche = $nombreArchivoFoto;
        
        $this->file = null;
    }
    
    public function crop($dir, $filenam){
        try
        {			
                $TVimageManipulation = new TVimageManipulation($dir.$filenam);
                $TVimageManipulation->resize(500);
                $TVimageManipulation->save($dir.$filenam);
                return true;
        }catch(Exception $e){
                return false;
        }
    }
    
    public function getFile()
    {
        return $this->file;
    }
    
    public function setFile(UploadedFile $file = null)
    {
        $this->file = $file;
        return $this;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     *
     * @return Depositos
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;

        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return Depositos
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
