<?php
namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="item")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ItemRepository")
 */
class Item {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $menu;
    
    /**
     * @ORM\OneToMany(targetEntity="SubItem", mappedBy="item")
     */
    protected $subitem;
    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set menu
     *
     * @param string $menu
     * @return Item
     */
    public function setMenu($menu)
    {
        $this->menu = $menu;
    
        return $this;
    }

    /**
     * Get menu
     *
     * @return string 
     */
    public function getMenu()
    {
        return $this->menu;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->subitem = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add subitem
     *
     * @param \AppBundle\Entity\SubItem $subitem
     * @return Item
     */
    public function addSubitem(\AppBundle\Entity\SubItem $subitem)
    {
        $this->subitem[] = $subitem;
    
        return $this;
    }

    /**
     * Remove subitem
     *
     * @param \AppBundle\Entity\SubItem $subitem
     */
    public function removeSubitem(\AppBundle\Entity\SubItem $subitem)
    {
        $this->subitem->removeElement($subitem);
    }

    /**
     * Get subitem
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSubitem()
    {
        return $this->subitem;
    }
}
