<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="menu_usuario")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\MenuUsuarioRepository")
 */
class MenuUsuario {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="SubItem", inversedBy="menusu")
     * @ORM\JoinColumn(name="submenu_id", referencedColumnName="id")
     */
    protected $subitem;
   
    /**
     * @ORM\ManyToOne(targetEntity="Usuarios", inversedBy="menusu")
     * @ORM\JoinColumn(name="usuario_id", referencedColumnName="id")
     */
    protected $usuario;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set subitem
     *
     * @param \AppBundle\Entity\SubItem $subitem
     * @return MenuUsuario
     */
    public function setSubitem(\AppBundle\Entity\SubItem $subitem = null)
    {
        $this->subitem = $subitem;
    
        return $this;
    }

    /**
     * Get subitem
     *
     * @return \AppBundle\Entity\SubItem 
     */
    public function getSubitem()
    {
        return $this->subitem;
    }

    /**
     * Set usuario
     *
     * @param \AppBundle\Entity\Usuarios $usuario
     * @return MenuUsuario
     */
    public function setUsuario(\AppBundle\Entity\Usuarios $usuario = null)
    {
        $this->usuario = $usuario;
    
        return $this;
    }

    /**
     * Get usuario
     *
     * @return \AppBundle\Entity\Usuarios 
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
}
