<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="niveles")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\NivelesRepository")
 */
class Niveles {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $descripcion;

    /**
     * @ORM\OneToMany(targetEntity="PlanEstudio", mappedBy="niveles")
     */
    protected $planestudio;
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->planestudio = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
   
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return Niveles
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     *
     * @return Niveles
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Add planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     *
     * @return Niveles
     */
    public function addPlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio[] = $planestudio;

        return $this;
    }

    /**
     * Remove planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     */
    public function removePlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio->removeElement($planestudio);
    }

    /**
     * Get planestudio
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPlanestudio()
    {
        return $this->planestudio;
    }


public function __toString()
    {
        return $this->descripcion;
    }



}
