<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="procesos")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ProcesosRepository")
 */
class Procesos {
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=5)
     */
    protected $codigo;
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $descripcion;
    
    /**
     * @ORM\Column(type="datetime")
     */
    protected $fechainicial;
    
    /**
     * @ORM\Column(type="datetime")
     */
    protected $fechafinal;
    
    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    protected $estado;
    
    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="procesos")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="procesos")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="procesos")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     * @return Procesos
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;
    
        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string 
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Set fechainicial
     *
     * @param \DateTime $fechainicial
     * @return Procesos
     */
    public function setFechainicial($fechainicial)
    {
        $this->fechainicial = $fechainicial;
    
        return $this;
    }

    /**
     * Get fechainicial
     *
     * @return \DateTime 
     */
    public function getFechainicial()
    {
        return $this->fechainicial;
    }

    /**
     * Set fechafinal
     *
     * @param \DateTime $fechafinal
     * @return Procesos
     */
    public function setFechafinal($fechafinal)
    {
        $this->fechafinal = $fechafinal;
    
        return $this;
    }

    /**
     * Get fechafinal
     *
     * @return \DateTime 
     */
    public function getFechafinal()
    {
        return $this->fechafinal;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     * @return Procesos
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;
    
        return $this;
    }

    /**
     * Get estado
     *
     * @return boolean 
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set lapso
     *
     * @param AppBundle\Entity\Lapso $lapso
     * @return Procesos
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return AppBundle\Entity\Lapso 
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set sede
     *
     * @param AppBundle\Entity\Sede $sede
     * @return Procesos
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return Procesos
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return Procesos
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
