<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\ResultSetMapping;



/**
 * DepositosRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class DepositosRepository extends EntityRepository
{
    public function findByDepositosEstudiante($estudiante, $lapso){
        $query = "SELECT d 
                  FROM AppBundle:Depositos d 
                  WHERE d.estudiante = :estudiante AND 
                        d.lapso = :lapso";
        $qb = $this->getEntityManager()->createQuery($query)
                   ->setParameter('estudiante', $estudiante)
                   ->setParameter('lapso', $lapso);
        
        return $qb->getResult();
                
    }
    
    public function findTotalDepositado($estudiante, $lapso){
        $query = "SELECT SUM(d.monto) as depositado 
                  FROM AppBundle:Depositos d 
                  WHERE d.estudiante = :estudiante AND 
                        d.lapso = :lapso";
        $qb = $this->getEntityManager()->createQuery($query)
                   ->setParameter('estudiante', $estudiante)
                   ->setParameter('lapso', $lapso);
        
        return $qb->getSingleResult();                
    }
    
    public function findByDepositosEstudianteAll($especialidad ,$lapso, $tipo){
        $query = "SELECT e, d   
                  FROM AppBundle:EspeEstud e 
                  LEFT JOIN e.estudiante ee 
                  LEFT JOIN e.depositos d 
                  WHERE 
                  e.especialidad = :especialidad AND 
                  d.lapso = :lapso AND 
                  d.conddepositos = :tipo 
                  ORDER BY ee.cedula ASC ";
        $qb = $this->getEntityManager()->createQuery($query)
                   ->setParameter('especialidad', $especialidad)
                   ->setParameter('lapso', $lapso)
                   ->setParameter('tipo', $tipo);
        
        return $qb->getResult();
                
    }
    
    public function findTotalDepositoPorPrograma($programa, $lapso, $tipo)
    {

        $sql = "SELECT e.nombre, SUM( d.monto ) AS montod
                FROM especialidad AS e
                LEFT JOIN espe_estud AS ee ON ( ee.especialidad_id = e.id )
                LEFT JOIN depositos AS d ON ( ee.id = d.estudiante_id )
                WHERE e.programa_id = :programa
                AND d.conddeposidos_id = :tipo
                AND d.lapso_id = :lapso
                GROUP BY e.id";
        $em = $this->getEntityManager();
        $connection = $em->getConnection();
        $statement = $connection->prepare($sql);
        $statement->bindValue('programa', $programa);
        $statement->bindValue('tipo', $tipo);
        $statement->bindValue('lapso', $lapso);
        $statement->execute();
        
        return $statement->fetchAll();        
    }
    
    //  NUEVOS METODOS
    public function findByDepositosByEspecialidad($especialidad ,$lapso){
        $query = "SELECT e, d   
                  FROM AppBundle:EspeEstud e 
                  LEFT JOIN e.estudiante ee 
                  LEFT JOIN e.depositos d 
                  WHERE 
                  e.especialidad = :especialidad AND 
                  d.lapso = :lapso 
                  ORDER BY ee.cedula ASC ";
        $qb = $this->getEntityManager()->createQuery($query)
                   ->setParameter('especialidad', $especialidad)
                   ->setParameter('lapso', $lapso)
                ;
        
        return $qb->getResult();
    }
    
}
