<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\ResultSetMapping;

/**
 * EspeEstudRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class EspeEstudRepository extends EntityRepository
{
    public function actualizarEstudiante($estudiante, $lapso = '', $tipo_ingreso){
     $matricula = $this->getEntityManager()->createQuery("
          SELECT m FROM AppBundle:Matricula m 
          WHERE m.estudiante = :estudiante 
          ")->setParameter('estudiante', $estudiante)->getResult()
             ;
     
      $query = $this->createQueryBuilder('e')
                     ->update('AppBundle:EspeEstud', 'e');   
     if(count($matricula) > 3){
                    $query->set('e.ingreso', 1);
                    $query->set('e.cod_situa', $tipo_ingreso->getId());
         
     }
                      if($lapso == ''){
                       $query->set('e.cod_lapso', $estudiante->getCodLapso()->getId());                       
                      }else{
                          $query->set('e.cod_lapso', $lapso->getId());
                      }
                      $query->where('e.id = :id')
                      ->setParameter('id', $estudiante)
                      ->getQuery()->execute();
     }
     
     public function actEstudiante($estudiante, $situacion)
     {
         $query = $this->createQueryBuilder('e')
                     ->update('AppBundle:EspeEstud', 'e');   
    
         $query->set('e.cod_situa', $situacion);   
                      
         $query->where('e.id = :id')
        ->setParameter('id', $estudiante)
        ->getQuery()->execute();
     }
     
     public function findEspeEstudRecord($estudiante)
     {
         $query = $this->getEntityManager()
                 ->createQuery(
                  "SELECT e, h FROM AppBundle:EspeEstud e 
                   LEFT JOIN e.histmatri h 
                   WHERE 
                   e.id = :estudiante 
                   ORDER BY h.lapso ASC"       
                 )
                 ->setParameter('estudiante', $estudiante)
                 ;
         return $query->getSingleResult();
     }
     
     public function findEspeEstudRecordGradoComp($estudiante, $componente)
     {     
         $sql = "SELECT DISTINCT(hist_matri.curso_id), cursos.nombre, cursos.codigo as codigoc, componentes.descripcion, lapso.codigo, cursos.uc, hist_matri.nota, hist_matri.obs, cod_curso.id as idcond  
                    FROM 
                    hist_matri
                    LEFT JOIN plan_estudio ON (hist_matri.curso_id = plan_estudio.curso_id) 
                    LEFT JOIN cursos ON (hist_matri.curso_id = cursos.id )  
                    LEFT JOIN componentes ON (plan_estudio.componente_id = componentes.id )
                    LEFT JOIN lapso ON (hist_matri.lapso_id = lapso.id ) 
                    LEFT JOIN cod_curso ON (cod_curso.id = hist_matri.condicion_id )
                    WHERE 
                    hist_matri.estudiante_id = $estudiante AND 
                    hist_matri.condicion_id = 3 AND 
                    plan_estudio.componente_id = $componente 
                    ORDER BY lapso.codigo ASC";

         
           $con = $this->getEntityManager()->getConnection();
           $st = $con->executeQuery($sql);
           $rs = $st->fetchAll();
         return $rs;
     }
     
     public function findEspeEstudRecordGradoComp2($estudiante, $componente)
     {     
         $sql = "SELECT DISTINCT(hist_matri.curso_id), cursos.nombre, cursos.codigo as codigoc, componentes.descripcion, lapso.codigo, cursos.uc, hist_matri.nota, hist_matri.obs, cod_curso.id as idcond
                    FROM 
                    hist_matri
                    LEFT JOIN plan_estudio ON (hist_matri.curso_id = plan_estudio.curso_id) 
                    LEFT JOIN cursos ON (hist_matri.curso_id = cursos.id )  
                    LEFT JOIN componentes ON (plan_estudio.componente_id = componentes.id )
                    LEFT JOIN lapso ON (hist_matri.lapso_id = lapso.id )
                    LEFT JOIN cod_curso ON (cod_curso.id = hist_matri.condicion_id)
                    WHERE 
                    hist_matri.estudiante_id = $estudiante AND 
                    plan_estudio.componente_id = $componente AND 
                    hist_matri.condicion_id = 3
                    ORDER BY lapso.codigo ASC";

         
           $con = $this->getEntityManager()->getConnection();
           $st = $con->executeQuery($sql);
           $rs = $st->fetchAll();
         return $rs;
     }
     
     public function findAllEstudiantes($especialidad, $sede)
     {
         $query = $this->getEntityManager()
                 ->createQuery(
                 "SELECT e FROM AppBundle:Estudiante e 
                  JOIN e.espeestud esp 
                  WHERE 
                  esp.especialidad = :especialidad AND 
                  esp.sede = :sede "        
                 )
                 ->setParameter('especialidad', $especialidad)
                 ->setParameter('sede', $sede);
         return $query->getResult();
     }
     
     
     
     public function findAllEstudiantesRegular($programa, $sede)
     {
         $condicion = array(8,9);
         $query = $this->getEntityManager()->createQuery(
                 "SELECT e, esp FROM AppBundle:Especialidad e 
                  JOIN e.espeestud esp 
                  JOIN esp.estudiante est 
                  WHERE 
                  e.sede = :sede AND 
                  e.programa = :programa AND 
                  esp.cod_situa = :situacion
                  ORDER BY est.primer_apellido, est.segundo_apellido ASC
                  "
                 )
                 ->setParameter('sede', $sede)
                 ->setParameter('programa', $programa)
                 ->setParameter('situacion', 1 )                 
                 ;
         return $query->getResult();
     }
     
     public function findAllEstudianteGraduandos($programa, $sede)
     {
         $query = $this->getEntityManager()->createQuery(
                 "SELECT e, esp FROM AppBundle:Especialidad e 
                  JOIN e.espeestud esp 
                  JOIN esp.estudiante est
                  WHERE 
                  e.sede = :sede AND 
                  e.programa = :programa AND 
                  esp.cod_situa = :situacion 
                  ORDER BY est.primer_apellido, est.segundo_apellido ASC
                  "
                 )
                 ->setParameter('sede', $sede)
                 ->setParameter('programa', $programa)
                 ->setParameter('situacion', 8)                 
                 ;
         return $query->getResult();
     }
     
     public function findAllEstudianteGraduandosIndices($programa, $sede)
     {
         $query = $this->getEntityManager()->createQuery(
                 "SELECT ee,est FROM AppBundle:EspeEstud ee 
                  JOIN ee.especialidad esp 
                  JOIN ee.estudiante est
                  WHERE 
                  ee.sede = :sede AND 
                  ee.programa = :programa AND 
                  ee.cod_situa = :situacion 
                  ORDER BY est.primer_apellido, est.segundo_apellido ASC
                  "
                 )
                 ->setParameter('sede', $sede)
                 ->setParameter('programa', $programa)
                 ->setParameter('situacion', 8)                 
                 ;
         return $query->getResult();
     }
     
     public function findAllEstudianteGraduandos2($sede)
     {
         $query = "SELECT esp.* FROM espe_estud AS esp 
                   WHERE esp.situa_id = 8
                   ORDER BY (CASE WHEN esp.indice<=10 THEN esp.indice ELSE (esp.indice/2) END) DESC";
           $con = $this->getEntityManager()->getConnection();
           $st = $con->executeQuery($query);
           return $rs = $st->fetchAll();
     }
     
     public function findAllEstudianteGraduandos3($sede)
     {
            $query = 'CREATE TEMPORARY TABLE brrprueba AS 
                    SELECT esp.especialidad_id, count( * ) as total   
                    FROM espe_estud AS esp 
                    WHERE 
                    esp.situa_id = 8
                    GROUP BY esp.especialidad_id';
            $query2 = 'SELECT hist.*, esp.especialidad_id,tot.total
                    FROM hist_egresado as hist, espe_estud AS esp, brrprueba as tot
                    WHERE esp.situa_id=8 
                    and esp.id = hist.estudiante_id 
                    and esp.especialidad_id=tot.especialidad_id 
                    order by esp.especialidad_id,(case when esp.indice<=10 then esp.indice else (esp.indice/2) end) desc 
                    ';
         
              $conn = $this->getEntityManager()->getConnection();
              $st = $conn->executeQuery($query);
              $st2 = $conn->executeQuery($query2);
              
            
            return $st2->fetchAll();
     }
     
     public function findAllEstudianteGraduandosEstadist($programa, $sede)
     {
         $query = $this->getEntityManager()->createQuery(
                 "SELECT e FROM AppBundle:Especialidad e 
                  LEFT JOIN e.espeestud esp 
                  LEFT JOIN esp.estudiante est
                  WHERE 
                  e.sede = :sede AND 
                  e.programa = :programa AND 
                  esp.cod_situa = :situacion                   
                  ORDER BY est.primer_apellido, est.segundo_apellido ASC
                  "
                 )
                 ->setParameter('sede', $sede)
                 ->setParameter('programa', $programa)
                 ->setParameter('situacion', 8)                 
                 ;
         return $query->getResult();
     }
     
     public function countSexoGraduando($especialidad, $sexo)
     {
         $sql = "SELECT * FROM estudiante  
                 LEFT JOIN espe_estud ON (estudiante.id = espe_estud.estudiante_id) 
                 WHERE 
                 espe_estud.especialidad_id = $especialidad AND 
                 espe_estud.situa_id = 8 AND 
                 estudiante.sexo = '$sexo' ";
         $conn = $this->getEntityManager()->getConnection();
         $st = $conn->executeQuery($sql);
         $rs = $st->fetchAll();
         return $rs;
     }
     
     public function findByAllEstudianteInform($programa, $especialidad, $sede)
     {
         $query = $this->getEntityManager()->createQuery(
                 "SELECT esp FROM AppBundle:EspeEstud esp 
                  JOIN esp.estudiante est
                  WHERE 
                  esp.sede = :sede AND 
                  esp.programa = :programa AND 
                  esp.especialidad = :especialidad AND 
                  esp.cod_situa = :situacion 
                  ORDER BY est.primer_apellido, est.segundo_apellido ASC
                  "
                 )
                 ->setParameter('sede', $sede)
                 ->setParameter('programa', $programa)
                 ->setParameter('especialidad', $especialidad)
                 ->setParameter('situacion', 8)
                 ;
         return $query->getResult();
     }
     
     //usado
     public function obtIndice($estudiante,$programa)
     {
         $totuc=0;
         $totuccal=0;
         $query = $this->getEntityManager()->createQuery(
                 "SELECT h FROM AppBundle:HistMatri h 
                  WHERE 
                  h.estudiante = :estudiante "
                 )
                 ->setParameter('estudiante', $estudiante);
         $result = $query->getResult();
                 
         foreach ($result as $value)
                {          
                    if($value->getCondicion()->getId()!=4){
                    $uc = $value->getCurso()->getUc();            
                    $nota = $value->getNota();
                    $curso = $this->getEntityManager()->createQuery(
                            "SELECT p FROM AppBundle:PlanEstudio p 
                             WHERE 
                             p.curso = :curso AND 
                             p.componentes = :componente "
                            )
                            ->setParameter('curso', $value->getCurso()->getId())
                            ->setParameter('componente', 4)
                            ;
                    //$cursopla = $em->getRepository('AppBundle:PlanEstudio')->findBy(array('curso'=>$value->getCurso()->getId(), 'componentes'=>4));
                    $cursopla = @$curso->getResult();
                    if(($cursopla)){

                    }else{
                      $cursonovalid = array(7, 10);
                      if(!in_array($value->getCondicion()->getId(), $cursonovalid)){ 
                        $totuc += $uc;
                        $totuccal += ($uc*$nota);
                      }
                    }                      
                }
                }
                
                @$indice = $totuccal / $totuc;
                
                $indice = ($totuc === 0) ? $indice = 0: $indice = $indice;
                if($programa == 3){
                    if($indice <9){
                        $this->actEstudiante($estudiante, 3);
                    } 
                }else{
                    if($indice <8){
                        $this->actEstudiante($estudiante, 3);
                    }                    
                }
         return $indice;
     }
     
     
     public function findByEspeEstudEgresados($cedula)
     {
        
         $query = 'SELECT e.id, pm.nombre as nombrepm, pm.fechapromocion, esp.nombre as nombreesp FROM espe_estud AS e 
                  JOIN estudiante AS est ON (est.id = e.estudiante_id )
                  JOIN especialidad AS esp ON (esp.id = e.especialidad_id )
                  JOIN hist_egresado AS he ON (he.estudiante_id = e.id ) 
                  JOIN promociones AS pm ON (pm.id = he.promocion_id ) 
                  WHERE 
                  e.situa_id = 5 AND 
                  est.cedula = "'.$cedula.'"
                  ';
         $conn = $this->getEntityManager()->getConnection();
         $st = $conn->executeQuery($query);
         
         return $st->fetchAll();        
     }
     
     public function findEspeEstudNotasComp($estudiante, $componente)
     {     
//         $sql = "SELECT DISTINCT(hist_matri_egresado.curso_id), cursos.nombre, cursos.codigo as codigoc, componentes.descripcion, lapso.codigo, cursos.uc, hist_matri_egresado.nota, hist_matri_egresado.obs 
//                    FROM 
//                    hist_matri_egresado
//                    LEFT JOIN plan_estudio ON (hist_matri_egresado.curso_id = plan_estudio.curso_id) 
//                    LEFT JOIN cursos ON (hist_matri_egresado.curso_id = cursos.id )  
//                    LEFT JOIN componentes ON (plan_estudio.componente_id = componentes.id )
//                    LEFT JOIN  lapso ON (hist_matri_egresado.lapso_id = lapso.id )
//                    WHERE 
//                    hist_matri_egresado.estudiante_id = $estudiante AND 
//                    plan_estudio.componente_id = $componente 
//                    ORDER BY lapso.codigo ASC";
         
         $sql = "SELECT DISTINCT(hist_matri_egresado.curso_id), cursos.nombre, cursos.codigo as codigoc, componentes.descripcion, lapso.codigo, cursos.uc, hist_matri_egresado.nota, hist_matri_egresado.obs 
                    FROM 
                    hist_matri_egresado
                    LEFT JOIN plan_estudio ON (hist_matri_egresado.curso_id = plan_estudio.curso_id) 
                    LEFT JOIN cursos ON (hist_matri_egresado.curso_id = cursos.id )  
                    LEFT JOIN componentes ON (plan_estudio.componente_id = componentes.id )
                    LEFT JOIN  lapso ON (hist_matri_egresado.lapso_id = lapso.id )
                    WHERE 
                    hist_matri_egresado.estudiante_id = $estudiante AND 
                    plan_estudio.componente_id = $componente 
                    ORDER BY lapso.codigo ASC";

         
           $con = $this->getEntityManager()->getConnection();
           $st = $con->executeQuery($sql);
           $rs = $st->fetchAll();
         return $rs;
     }
     
     public function findEspeEstudNotasComp2($estudiante, $componente)
     {     
         $sql = "SELECT DISTINCT(hist_matri_egresado.curso_id), cursos.nombre, cursos.codigo as codigoc, componentes.descripcion, lapso.codigo, cursos.uc, hist_matri_egresado.nota, hist_matri_egresado.obs 
                    FROM 
                    hist_matri_egresado 
                    LEFT JOIN plan_estudio ON (hist_matri_egresado.curso_id = plan_estudio.curso_id) 
                    LEFT JOIN cursos ON (hist_matri_egresado.curso_id = cursos.id )  
                    LEFT JOIN componentes ON (plan_estudio.componente_id = componentes.id )
                    LEFT JOIN lapso ON (hist_matri_egresado.lapso_id = lapso.id )
                    WHERE 
                    hist_matri_egresado.estudiante_id = $estudiante AND 
                    plan_estudio.componente_id = $componente AND 
                    hist_matri_egresado.condicion_id = 3
                    ORDER BY lapso.codigo ASC";
         
         


         
           $con = $this->getEntityManager()->getConnection();
           $st = $con->executeQuery($sql);
           $rs = $st->fetchAll();
         return $rs;
     }
     
     ////////////////// NUEVOS METODOS //////////////
     
     
     public function getEspecialidadesByEstudiante($cedula){
         $em = $this->getEntityManager();
         $query = "SELECT ee FROM AppBundle:EspeEstud ee "
                 . "LEFT JOIN ee.estudiante e "
                 . "WHERE "
                 . "e.cedula = :cedula"
                 ;
         $consulta = $em->createQuery($query);
         $consulta->setParameter('cedula', $cedula);
         return $consulta->getResult();
     }
     
     public function findHistMatri($estudiante)
     {
         $query = $this->getEntityManager()
                 ->createQuery(
                  "SELECT h FROM AppBundle:HistMatri h
                   WHERE 
                   h.estudiante = :estudiante
                   ORDER BY h.lapso ASC"       
                 )
                 ->setParameter('estudiante', $estudiante)
                 ;
         return $query->getResult();
     }
     
     public function findEspeEstudPregrado($estudiante)
     {
         $query = $this->getEntityManager()
                 ->createQuery(
                  "SELECT ee FROM AppBundle:EspeEstud ee
                   WHERE 
                   ee.estudiante = :estudiante"       
                 )
                 ->setParameter('estudiante', $estudiante)
                 ;
         return $query->getResult();
     }

     public function findHistMatriMax($estudiante)
     {
         $query = $this->getEntityManager()
                 ->createQuery(
                  "SELECT h FROM AppBundle:HistMatri h
                   WHERE 
                   h.estudiante = :estudiante AND
                   h.nota > :nota
                   ORDER BY h.lapso ASC"       
                 )
                 ->setParameter('estudiante', $estudiante)
                 ->setParameter('nota', 5)
                 ;
         return $query->getResult();
     }

     public function getUltimoPeriodoBy($estudiante)
    {
        $query =  "SELECT m, o FROM AppBundle:Matricula m " 
                . "LEFT JOIN m.oferta o "
                . "WHERE "
                . "m.estudiante = :estudiante "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('estudiante', $estudiante)
                ;
        return $consulta->getResult();
    }

    public function findHistMatriUCA($estudiante)
     {
         $query = $this->getEntityManager()
                 ->createQuery(
                  "SELECT h FROM AppBundle:HistMatri h
                   WHERE 
                   h.estudiante = :estudiante AND
                   h.condicion = :condicion
                   ORDER BY h.lapso ASC"       
                 )
                 ->setParameter('estudiante', $estudiante)
                 ->setParameter('condicion', 3)
                 ;
         return $query->getResult();
     }

     public function findOneByActivo($id)
     {
         $query = $this->getEntityManager()
                 ->createQuery(
                  "SELECT ee FROM AppBundle:EspeEstud ee
                   WHERE 
                   ee.estudiante = :id  AND
                   ee.activo = :activo"     
                 )
                 ->setParameter('id', $id)
                 ->setParameter('activo', 1)
                 ;
         return $query->getResult();
     }

     public function getEstudiantesPreInscritos($cohorte, $lapso, $subsede)
    {
        $query =  "SELECT ee, e FROM AppBundle:Estudiante ee "
                . "LEFT JOIN ee.espeestud e "
                . "WHERE "
                . "e.subsede = :subsede AND "
                . "e.cohorte = :cohorte AND "
                . "e.cod_lapso = :lapso "
                . "ORDER BY e.especialidad ASC "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('cohorte', $cohorte)
                ->setParameter('lapso', $lapso)
                ->setParameter('subsede', $subsede)
                ;
        return $consulta->getResult();
    }
    

    public function getEstudianteEspeEstud($id){

        $query =  "SELECT ee FROM AppBundle:Espeestud ee "
                . "WHERE "
                . "ee.estudiante = :id "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('id', $id)
                ->setMaxResults(1)
                ;
        return $consulta->getResult();
    }

}
