<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="sessiones_detalles")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\SessionesDetallesRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class SessionesDetalles {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sessiones", inversedBy="sessiondet")
     * @ORM\JoinColumn(name="session_id", referencedColumnName="id")
     */
    protected $session;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $modulo;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $accion;
    
    /**
     * @ORM\Column(type="text")
     */
    protected $observacion;
    
    /**
     * @ORM\Column(type="datetime")
     */
    protected $fecha;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set modulo
     *
     * @param string $modulo
     * @return SessionesDetalles
     */
    public function setModulo($modulo)
    {
        $this->modulo = $modulo;
    
        return $this;
    }

    /**
     * Get modulo
     *
     * @return string 
     */
    public function getModulo()
    {
        return $this->modulo;
    }

    /**
     * Set accion
     *
     * @param string $accion
     * @return SessionesDetalles
     */
    public function setAccion($accion)
    {
        $this->accion = $accion;
    
        return $this;
    }

    /**
     * Get accion
     *
     * @return string 
     */
    public function getAccion()
    {
        return $this->accion;
    }

    /**
     * Set observacion
     *
     * @param string $observacion
     * @return SessionesDetalles
     */
    public function setObservacion($observacion)
    {
        $this->observacion = $observacion;
    
        return $this;
    }

    /**
     * Get observacion
     *
     * @return string 
     */
    public function getObservacion()
    {
        return $this->observacion;
    }

    /**
     * Set fecha
     *
     * @param \DateTime $fecha
     * @return SessionesDetalles
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;
    
        return $this;
    }

    /**
     * Get fecha
     *
     * @return \DateTime 
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set session
     *
     * @param \AppBundle\Entity\Sessiones $session
     * @return SessionesDetalles
     */
    public function setSession(\AppBundle\Entity\Sessiones $session = null)
    {
        $this->session = $session;
    
        return $this;
    }

    /**
     * Get session
     *
     * @return \AppBundle\Entity\Sessiones 
     */
    public function getSession()
    {
        return $this->session;
    }
    
    /**
     * @ORM\PrePersist
     */
    public function setValues()
    {
        $this->setFecha(new \DateTime());
    }
}
