<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Traslado
 *
 * @ORM\Table(name="traslado")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\TrasladoRepository")
 */
class Traslado
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Cursos", inversedBy="traslado")
     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")
     */
    protected $curso;

    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="traslado")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;
    
    /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="traslado")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    protected $especialidad;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set curso
     *
     * @param AppBundle\Entity\Cursos $curso
     * @return OfertAcade
     */
    public function setCurso(\AppBundle\Entity\Cursos $curso = null)
    {
        $this->curso = $curso;
    
        return $this;
    }

    /**
     * Get curso
     *
     * @return AppBundle\Entity\Cursos 
     */
    public function getCurso()
    {
        return $this->curso;
    }

    /**
     * Set lapso
     *
     * @param AppBundle\Entity\Lapso $lapso
     * @return OfertAcade
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return AppBundle\Entity\Lapso 
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set especialidad
     *
     * @param AppBundle\Entity\Especialidad $especialidad
     * @return OfertAcade
     */
    public function setEspecialidad(\AppBundle\Entity\Especialidad $especialidad = null)
    {
        $this->especialidad = $especialidad;
    
        return $this;
    }

    /**
     * Get especialidad
     *
     * @return AppBundle\Entity\Especialidad 
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }
}

