<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Doctrine\ORM\EntityManager;
use AppBundle\Form\EventListener\AddEstadoFieldSubscriber;
use AppBundle\Form\EventListener\AddCiudadFieldSubscriber;
use AppBundle\Form\EventListener\AddMunicipioFieldSubscriber;


class EstudianteType extends AbstractType
{
    private $em;
    
    public function __construct(EntityManager $em) {
        $this->em = $em;
    }
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $factory = $builder->getFormFactory();
        $estadoSubscriber = new AddEstadoFieldSubscriber($factory, $this->em);
        $builder->addEventSubscriber($estadoSubscriber);
        $ciudadSubscriber = new AddCiudadFieldSubscriber($factory, $this->em);
        $builder->addEventSubscriber($ciudadSubscriber);
        $municipioSubscriber = new AddMunicipioFieldSubscriber($factory, $this->em);
        $builder->addEventSubscriber($municipioSubscriber);
        
        $builder
            ->add('cedula')
            ->add('primer_nombre')
            ->add('segundo_nombre')
            ->add('primer_apellido')
            ->add('segundo_apellido')
            ->add('nacionalidad')
            ->add('fecha_nacimiento','date', array(
                'input' => 'datetime',
                'widget'=> 'single_text',
                'format'=> 'dd-MM-yyyy',
                'attr' => array('placeholder' => 'dd-mm-yyyy','readonly'=>'readonly')
             ))
            ->add('sexo', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array( 'f'=>'Femenino',
                                                                                            'm'=>'Masculino',
                                                                                            'F'=>'Femenino',
                                                                                            'M'=>'Masculino',
                                                                                            'Femenino'=>'Femenino',
                                                                                            'Masculino'=>'Masculino')))
            ->add('estado_civil', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array( 'Soltero(a)'=>'Soltero(a)',
                                                                                                    'Casado(a)'=>'Casado(a)', 
                                                                                                    'Divorciado(a)'=>'Divorciado(a)',
                                                                                                    'Viudo(a)'=>'Viudo(a)',
                                                                                                    'Soltero'=>'Soltero(a)', 
                                                                                                    'Casado'=>'Casado(a)',
                                                                                                    'Divorcia'=>'Divorciado(a)',
                                                                                                    'Viudo'=>'Viudo(a)', 
                                                                                                    'Otro'=>'Otro',
                                                                                                    's'=>'Soltero(a)',
                                                                                                    'c'=>'Casado(a)', 
                                                                                                    'd'=>'Divorciado(a)', 
                                                                                                    'v'=>'Viudo(a)')))
            ->add('direccion')
            ->add('telefono_movil')
            ->add('telefono_local')
            ->add('email')
            ->add('twitter')            
            ->add('pais', 'entity', array(
                'class'=>'AppBundle:Pais',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',                
                'required'=>false
            ))
            ->add('estado', 'entity', array(
                'class'=>'AppBundle:Estados',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',
                'required'=>false
            ))
            ->add('ciudad', 'entity', array(
                'class'=>'AppBundle:Ciudades',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',
                'required'=>false
            ))
            ->add('municipio', 'entity', array(
                'class'=>'AppBundle:Municipios',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',
                'required'=>false
            ))
            ->add('etnia', 'entity', array(
                'class'=>'AppBundle:Etnia',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',
                'required'=>false
            ))
            ->add('discapacidad', 'entity', array(
                'class'=>'AppBundle:Discapacidades',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',
                'required'=>false
            ))
           /* ->add('universidad', 'entity', array(
                'class'=>'AppBundle:Universidades',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',
                'required'=>false
            ))
            */
            ->add('espeestud', 'collection', array(
                'type'=>new EspeEstudType($this->em),
                'allow_add'   => true,
                'prototype'   => true
            ))
             ->add('tipoestudiante', 'entity', array(
                'class'=>'AppBundle:TipoEstudiante',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',
                'required'=>false
            ))
            
            ->add('condi_residencia', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('1'=>'Residente',
                                                                                                       '2'=>'Transeúnte',)))

            ->add('priv_libertad', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('n'=>'NO', 's'=>'SI')))
            ->add('plantel_graduado')
            ->add('clasif_plantel', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('1'=>'Público',
                                                                                                     '2'=>'Privado',
                                                                                                     '3'=>'Mixto')))
            ->add('fecha_graduado','date', array(
                'input' => 'datetime',
                'widget'=> 'single_text',
                'format'=> 'dd-MM-yyyy',
                'attr' => array('placeholder' => 'dd-mm-yyyy','readonly'=>'readonly')
             ))

             ->add('beca', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('0'=>'No Posee Beca', 
                                                                                            '1'=>'Becado por la Institución',
                                                                                            '2'=>'Becado por la Alcaldía o Gobernación',
                                                                                            '3'=>'Por un Ministerio',
                                                                                            '4'=>'Por Fundayacucho',
                                                                                            '5'=>'Por un Ente Privado',
                                                                                            '6'=>'Por la Opsu' )))
             
             ->add('num_rusnies')
             ->add('nivel_economico', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('1'=>'Ingresos mensuales inferiores a 40.000 Bs',
                                                                                                       '2'=>'Ingresos mensuales entre 40.000 y 80.000 Bs',
                                                                                                       '3'=>'Ingresos mensuales entre 80.000 y 130.000 Bs',
                                                                                                       '4'=>'Ingresos mensuales entre 130.000 y 180.000 Bs',
                                                                                                       '5'=>'Ingresos mensaules superiores a 180.000 Bs' )))

        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Estudiante',         
            'em'=>null,
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_estudiante';
    }
}
