<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Doctrine\ORM\EntityManager;

class ProcesosType extends AbstractType
{
    private $em;
    
    public function __construct(EntityManager $em) {
        $this->em = $em;
    }
    
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
             
	        ->add('codigo', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('PI'=>'PROCESO DE INSCRIPCIÓN', 'PN'=>'PROCESO DE NOTAS', 'PR'=>'PROCESO DE RETIRO')))
            //->add('descripcion', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('Proceso De Inscripcion'=>'Proceso De Inscripcion', 'Proceso De Notas'=>'Proceso De Notas' )))
            ->add('fechainicial','date', array(
                'input' => 'datetime',
                'widget'=> 'single_text',
                'format'=> 'dd-MM-yyyy',
                'attr' => array('placeholder' => 'dd-mm-yyyy', 'class'=>'form-control','readonly'=>'readonly'),
                'required'=>true))
            ->add('fechafinal','date', array(
                'input' => 'datetime',
                'widget'=> 'single_text',
                'format'=> 'dd-MM-yyyy',
                'attr' => array('placeholder' => 'dd-mm-yyyy', 'class'=>'form-control','readonly'=>'readonly'),
                'required'=>true))
            //->add('estado')
            ->add('lapso', 'entity', array(
                'class'=>'AppBundle:Lapso',
                'em'=>$this->em,
                'query_builder'=>function(\Doctrine\ORM\EntityRepository $er) {
                    $q = $er->createQueryBuilder('l')
                            ->orderBy('l.codigo', 'DESC')
                            ->setMaxResults('50');
                            ;
                            
                    return $q;
                },
            ))
            //->add('sede')
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Procesos'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_procesos';
    }
}
