<?php

namespace UsersBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="subsede")
 * @ORM\Entity(repositoryClass="UsersBundle\Entity\Repository\SubSedeRepository")
 */
class SubSede {
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $descripcion;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $vigente;

    /**
     * @ORM\ManyToOne(targetEntity="UsersBundle\Entity\TipoSubSede", inversedBy="subsede")
     * @ORM\JoinColumn(name="tiposubsede_id", referencedColumnName="id")
     */
    protected $tiposubsede;


    /**
     * @ORM\OneToMany(targetEntity="SubSedeUser", mappedBy="subsede")
     */
    protected $subsedeuser;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return SubSede
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     *
     * @return SubSede
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Set vigente
     *
     * @param boolean $vigente
     *
     * @return SubSede
     */
    public function setVigente($vigente)
    {
        $this->vigente = $vigente;

        return $this;
    }

    /**
     * Get vigente
     *
     * @return boolean
     */
    public function getVigente()
    {
        return $this->vigente;
    }

    /**
     * Set tiposubsede
     *
     * @param \UsersBundle\Entity\TipoSubSede $tiposubsede
     *
     * @return SubSede
     */
    public function setTiposubsede(\UsersBundle\Entity\TipoSubSede $tiposubsede = null)
    {
        $this->tiposubsede = $tiposubsede;

        return $this;
    }

    /**
     * Get tiposubsede
     *
     * @return \UsersBundle\Entity\TipoSubSede
     */
    public function getTiposubsede()
    {
        return $this->tiposubsede;
    }

    public function __toString()
    {
        return $this->descripcion;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->subsedeuser = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add subsedeuser
     *
     * @param \UsersBundle\Entity\SubSedeUser $subsedeuser
     *
     * @return SubSede
     */
    public function addSubsedeuser(\UsersBundle\Entity\SubSedeUser $subsedeuser)
    {
        $this->subsedeuser[] = $subsedeuser;

        return $this;
    }

    /**
     * Remove subsedeuser
     *
     * @param \UsersBundle\Entity\SubSedeUser $subsedeuser
     */
    public function removeSubsedeuser(\UsersBundle\Entity\SubSedeUser $subsedeuser)
    {
        $this->subsedeuser->removeElement($subsedeuser);
    }

    /**
     * Get subsedeuser
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSubsedeuser()
    {
        return $this->subsedeuser;
    }
}
