<?php

namespace UsersBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="tipo_subsede")
 * @ORM\Entity(repositoryClass="UsersBundle\Entity\Repository\TipoSubSedeRepository")
 */
class TipoSubSede {
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $descripcion;

    /**
     * @ORM\OneToMany(targetEntity="UsersBundle\Entity\SubSede", mappedBy="tiposubsede")
     */
    protected $subsede;
   
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->subsede = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     *
     * @return TipoSubSede
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Add subsede
     *
     * @param \UsersBundle\Entity\SubSede $subsede
     *
     * @return TipoSubSede
     */
    public function addSubsede(\UsersBundle\Entity\SubSede $subsede)
    {
        $this->subsede[] = $subsede;

        return $this;
    }

    /**
     * Remove subsede
     *
     * @param \UsersBundle\Entity\SubSede $subsede
     */
    public function removeSubsede(\UsersBundle\Entity\SubSede $subsede)
    {
        $this->subsede->removeElement($subsede);
    }

    /**
     * Get subsede
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSubsede()
    {
        return $this->subsede;
    }

   public function __toString()
    {
        return $this->descripcion;
    } 
}
