<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\CursosEspeciales;
use AppBundle\Form\CursosEspecialesType;

class CursosEspecialesController extends Controller {
    
    /**
     * @Route("/app/admin/cursos/especiales", name="app_cursos_especiales")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT c, cu, m FROM AppBundle:CursosEspeciales c "
                . "LEFT JOIN c.curso cu "
                . "LEFT JOIN c.modo_transcripcion m "                                        
                . "ORDER BY cu.codigo ASC";
        $entities = $em->createQuery($query);        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:CursosEspeciales:index.html.twig', array(
            'pagination'=>$pagination
        ));               
    }
    
    /**
     * @Route("/app/admin/cursos/especiales/search", name="app_cursos_especiales_search")
     */
    public function searchAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
       $query = "SELECT c, cu, m FROM AppBundle:CursosEspeciales c "
                ."LEFT JOIN c.curso cu "
                ."LEFT JOIN c.modo_transcripcion m "
               . "WHERE "
               . "cu.codigo LIKE :text OR "
               . "cu.nombre LIKE :text OR "
               . "m.descripcion LIKE :text "                                        
                . "ORDER BY cu.codigo ASC";
        $entities = $em->createQuery($query);        
        $entities->setParameter('text', '%'.$text.'%');
        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:CursosEspeciales:index.html.twig', array(
            'pagination'=>$pagination
        ));               
    }
    
    /**
     * @Route("/app/admin/new/cursos/especiales", name="app_cursos_especiales_new")
     */
    public function newAction()
    {
        $entity = new CursosEspeciales();
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->createFormCursosEspeciales($entity, $em);        
        
        return $this->render('AppBundle:CursosEspeciales:new.html.twig', array(
           'form'=>$form->createView(), 
        ));
    }
    
    /**
     * @Route("/app/admin/create/cursos/especiales", name="app_cursos_especiales_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $entity = new CursosEspeciales();
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->createFormCursosEspeciales($entity, $em);        
        
        $form->handleRequest($request);
        
        if($form->isValid())
        {   
            $em->persist($entity);
            $em->flush();
            
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro guardado exitosamente!!');
            return  $this->redirect($this->generateUrl('app_cursos_especiales'));
        }
        
        return $this->render('AppBundle:CursosEspeciales:new.html.twig', array(
           'form'=>$form->createView(), 
        ));
    }
    
    private function createFormCursosEspeciales(CursosEspeciales $entity, \Doctrine\ORM\EntityManager $em)
    {
        $form =$this->createForm(new CursosEspecialesType($em), $entity, array(
                    'action'=>$this->generateUrl('app_cursos_especiales_create'),
                    'method'=>'POST'
                ))
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/edit/curso/especiales/{id}", name="app_cursos_especiales_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:CursosEspeciales')->find($id);
        $form = $this->editFormCursosEspeciales($entity, $em);
        
        return $this->render('AppBundle:CursosEspeciales:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/curso/especialies/{id}", name="app_cursos_especiales_update", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:CursosEspeciales')->find($id);
        $form = $this->editFormCursosEspeciales($entity, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {   
            $em->persist($entity);
            $em->flush();
            
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado exitosamente!!');
            return  $this->redirect($this->generateUrl('app_cursos_especiales'));
        }
        
        return $this->render('AppBundle:CursosEspeciales:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editFormCursosEspeciales(CursosEspeciales $entity, \Doctrine\ORM\EntityManager $em)
    {
        $form =$this->createForm(new CursosEspecialesType($em), $entity, array(
                    'action'=>$this->generateUrl('app_cursos_especiales_update', array('id'=>$entity->getId())),
                    'method'=>'PUT'
                ))
                ->add('submit', 'submit', array('label'=>'Modificar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
}