<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Form\EstudianteType;  
use AppBundle\Entity\Estudiante;
use AppBundle\Entity\EspeEstud;
use AppBundle\Form\EspeEstudType;
/**
 * Description of Estudiantes
 *
 * @author josemorlet
 */
class EstudiantesController extends Controller {
    
    /**
     * @Route("/app/admin/estudiantes", name="app_estudiantes_index")
     */
    public function indexAction()
    {
        $form = $this->formSearchEstudiante();
        return $this->render('AppBundle:Estudiantes:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/search/estudiante", name="app_estudiante_search", requirements={"_method":"POST"})
     */
    public function searchEstudiantesAction(Request $request)
    {
        $form = $this->formSearchEstudiante();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_estudiantes_index'));
            }
            
            return $this->render('AppBundle:Estudiantes:result.html.twig', array(
                'datos'=>$estudiante
            ));
        }
        
        return $this->render('AppBundle:Estudiantes:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formSearchEstudiante()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_estudiante_search'))
                ->setMethod('POST')
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>' btn btn-default btn-flat fa fa-search')))
                ->getForm()
            ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/edit/estudiante/{id}", name="app_estudiante_edit")
     */
    public function editEstudianteAction($id){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Estudiante')->find($id);
        $form = $this->formEditEstudiante($entity, $em);
        
        return $this->render('AppBundle:Estudiantes:edit.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    
    /**
     * @Route("/app/admin/update/estudiante/{id}", name="app_estudiante_update", requirements={"_method":"POST"})
     */
    public function updateEstudianteAction(Request $request, $id)
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Estudiante')->find($id);
        $form = $this->formEditEstudiante($entity, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
           $em->persist($entity);
           $em->flush();
           $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado sastifactoriamente!');
           return $this->render('AppBundle:Estudiantes:result.html.twig', array(
                'datos'=>$entity
            ));
        }else{
            $this->get('session')->getFlashBag()->add('msg-error','Verifique que los datos estan correctos!');
        }
        return $this->render('AppBundle:Estudiantes:edit.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    
    private function formEditEstudiante(Estudiante $entity, \Doctrine\ORM\EntityManager $em){
        $form = $this->createForm(new EstudianteType($em), $entity, array(
                    'em'=>$em,
                    'action' =>$this->generateUrl('app_estudiante_update', array('id'=>$entity->getId())),
                    'method' =>'POST'
                ))
                ->add('submit', 'submit', array( 'attr'=> array(
                    'class'=>'btn btn-primary btn-flat',
                                        )))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/new/estudiante/", name="app_estudiante_new")
     */
    public function newAction()
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Estudiante();   
        $espeEstud = new EspeEstud();
        $entity->getEspeestud()->add($espeEstud);
        $form = $this->formCreateEstudianteDatosBasic($entity, $em);        
        
        return $this->render('AppBundle:Estudiantes:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/estudiante", name="app_estudiante_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Estudiante();        
        $form = $this->formCreateEstudianteDatosBasic($entity, $em); 
        
        $form->handleRequest($request);
        if($form->isValid()){            
            $em->persist($entity);
            $em->flush();
            
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro guardado exitosamente!');
            return $this->redirect($this->generateUrl('app_estudiantes_index'));
        }
        
        return $this->render('AppBundle:Estudiantes:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }


    private function formCreateEstudianteDatosBasic(Estudiante $entity,  \Doctrine\ORM\EntityManager $em){
        
       
        $form = $this->createForm(new EstudianteType($em), $entity, array(
                    'action' =>$this->generateUrl('app_estudiante_create'),
                    'method' =>'POST'
                ))
                ->add('submit', 'submit', array('label'=>'Guardar Cambios', 'attr'=> array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }    
    
    /**
     * @Route("/app/admin/select/especialidad", name="select_especialidad")
     */
     public function selectEspecialidadAction(Request $request)
     {
         $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         $programa = $request->get('programa_id');
         $especialidades= $em->getRepository('AppBundle:Especialidad')->findBy(array('programa'=>$programa));

         foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
     }
     
    /**
     * @Route("/app/admin/select/estados", name="select_estados")
     */
     public function selectEstadosAction(Request $request)
     {
         $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         $programa = $request->get('pais_id');
         $especialidades= $em->getRepository('AppBundle:Estados')->findBy(array('pais'=>$programa));

         foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
     }
     
    /**
     * @Route("/app/admin/select/ciudades", name="select_ciudades")
     */
     public function selectCiudadesAction(Request $request)
     {
         $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         $programa = $request->get('estado_id');
         $especialidades= $em->getRepository('AppBundle:Ciudades')->findBy(array('estado'=>$programa));

         foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
     }
    /**
     * @Route("/app/admin/select/municipios", name="select_municipios")
     */
     public function selectMunicipiosAction(Request $request)
     {
         $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         $programa = $request->get('estado_id');
         $especialidades= $em->getRepository('AppBundle:Municipios')->findBy(array('estado'=>$programa));

         foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
     }
    
}