<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Form\UsuariosType;  
use AppBundle\Entity\Usuarios;
use UsersBundle\Entity\Users;
use AppBundle\Entity\MenuUsuario;

use AppBundle\Utils\Util2;

use Doctrine\ORM\EntityRepository;

/**
 * Description of MenuUsuario
 *
 * @author josemorlet
 */
class MenuUsuariosController extends Controller {
    
    /**
     * @Route("/app/admin/menu/usuarios", name="app_menuusuarios_index")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:MenuUsuario')->findAll();
        
        
        
        return $this->render('AppBundle:MenuUsuarios:index.html.twig', array(
            'entities' => $entities
        ));
        
        
    }
    
    /**
     * @Route("/app/admin/menu/usuarios/consultmenu", name="app_menuusuarios_search", requirements={"_method":"POST"})
     */
     public function consultMenuUsuarioAction()
    {
        $request = $this->getRequest();
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getManager();
        $cedula = $request->get('cedulausu');
        $usuario = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$cedula));
        $users = $em2->getRepository('UsersBundle:Users')->findOneBy(array('cedula'=>$cedula)); 
          
            $menugen = $em->getRepository('AppBundle:SubItem')->consultMenuGen();     
            $menusu = $em->getRepository('AppBundle:SubItem')->consultMenuUsu($usuario->getId()); 
            
            return $this->render('AppBundle:MenuUsuarios:result.html.twig', array(
            'menug'=>$menugen, 'menuusu'=>$menusu, 'idusu'=>$usuario->getId(), 'usuario'=>$usuario, 'users'=>$users,
        ));      
    }
 
    /**
     * @Route("/app/admin/menu/usuarios/editmenu", name="app_menuusuarios_edit", requirements={"_method":"POST"})
     */
    public function editMenuUsuarioAction()
    {
        $request = $this->getRequest();
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $id = $request->get('id');
        $item = $request->get('item');
        $exit = $em->getRepository('AppBundle:MenuUsuario')->findOneBy(array('usuario'=>$id, 'subitem'=>$item));
        if($exit){
            $em->remove($exit); 
        }else{
            $menu = new MenuUsuario();
            $usuario = $em->getRepository('AppBundle:Usuarios')->find($id);
            $items = $em->getRepository('AppBundle:SubItem')->find($item);
            $menu->setUsuario($usuario);
            $menu->setSubitem($items);
            $em->persist($menu);
        }
        $em->flush();
        
        $menugen = $em->getRepository('AppBundle:SubItem')->consultMenuGen(); 
        $menusu = $em->getRepository('AppBundle:SubItem')->consultMenuUsu($id);
        return $this->render('AppBundle:MenuUsuarios:result.html.twig', array(
            'menug'=>$menugen, 'menuusu'=>$menusu, 'idusu'=>$id,
        ));
    }

}
