<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="componentes")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ComponentesRepository")
 */
class Componentes {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $descripcion;

    /**
     * @ORM\OneToMany(targetEntity="Cursos", mappedBy="componentes")
     */
    protected $componentes;
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->cursos = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return Componentes
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     * @return Componentes
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;
    
        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string 
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Add cursos
     *
     * @param \AppBundle\Entity\Cursos $cursos
     * @return Componentes
     */
    public function addCursos(\AppBundle\Entity\Cursos $cursos)
    {
        $this->cursos[] = $cursos;
    
        return $this;
    }

    /**
     * Remove cursos
     *
     * @param \AppBundle\Entity\Cursos $cursos
     */
    public function removeCursos(\AppBundle\Entity\Cursos $cursos)
    {
        $this->cursos->removeElement($cursos);
    }

    /**
     * Get cursos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCursos()
    {
        return $this->cursos;
    }
    
    public function __toString() {
        return $this->getDescripcion();
    }

    /**
     * Add componente
     *
     * @param \AppBundle\Entity\Cursos $componente
     *
     * @return Componentes
     */
    public function addComponente(\AppBundle\Entity\Cursos $componente)
    {
        $this->componentes[] = $componente;

        return $this;
    }

    /**
     * Remove componente
     *
     * @param \AppBundle\Entity\Cursos $componente
     */
    public function removeComponente(\AppBundle\Entity\Cursos $componente)
    {
        $this->componentes->removeElement($componente);
    }

    /**
     * Get componentes
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getComponentes()
    {
        return $this->componentes;
    }
}
