<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="especialidad")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\EspecialidadRepository")
 */
class Especialidad {
    
     /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=255)
     */
    protected $nombre;
    
    /**
     * @ORM\OneToMany(targetEntity="EspeEstud", mappedBy="especialidad")
     */    
    protected $espeestud;

    /**
     * @ORM\OneToMany(targetEntity="PlanEstudio", mappedBy="especialidad")
     */
    protected $planestudio;
    
    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="especialidad")
     */
    protected $oferacade;

    /**
     * @ORM\OneToMany(targetEntity="HistMatri", mappedBy="especialidad")
     */
    protected $histmatri;

    /**
     * @ORM\OneToMany(targetEntity="HistMatriEgresado", mappedBy="especialidad")
     */
    protected $histmatriegresado;
    
    /**
     * @ORM\ManyToOne(targetEntity="Programa", inversedBy="especialidad")
     * @ORM\JoinColumn(name="programa_id", referencedColumnName="id")
     */
    protected $programa;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="especialidad")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\OneToMany(targetEntity="CreditosGraduando", mappedBy="especialidad")
     */
    protected $creditos;
    
    /**
     * @ORM\OneToMany(targetEntity="ExtensionesUsuarios", mappedBy="especialidad")
     */
    protected $extension;
    
    /**
     * @ORM\OneToMany(targetEntity="SubSedeEspe", mappedBy="especialidad")
     */    
    protected $subsedeespe;


    // METODOS GENERADOS PARA LAS CONSULTAS //

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->espeestud = new \Doctrine\Common\Collections\ArrayCollection();
        $this->planestudio = new \Doctrine\Common\Collections\ArrayCollection();
        $this->oferacade = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatri = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatriegresado = new \Doctrine\Common\Collections\ArrayCollection();
        $this->creditos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->extension = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return Especialidad
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return Especialidad
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return string 
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Add espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     * @return Especialidad
     */
    public function addEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud[] = $espeestud;
    
        return $this;
    }

    /**
     * Remove espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     */
    public function removeEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud->removeElement($espeestud);
    }

    /**
     * Get espeestud
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEspeestud()
    {
        return $this->espeestud;
    }

    /**
     * Add planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     * @return Especialidad
     */
    public function addPlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio[] = $planestudio;
    
        return $this;
    }

    /**
     * Remove planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     */
    public function removePlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio->removeElement($planestudio);
    }

    /**
     * Get planestudio
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPlanestudio()
    {
        return $this->planestudio;
    }

    /**
     * Add oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     * @return Especialidad
     */
    public function addOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade[] = $oferacade;
    
        return $this;
    }

    /**
     * Remove oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     */
    public function removeOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade->removeElement($oferacade);
    }

    /**
     * Get oferacade
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getOferacade()
    {
        return $this->oferacade;
    }

    /**
     * Add histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     * @return Especialidad
     */
    public function addHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri[] = $histmatri;
    
        return $this;
    }

    /**
     * Remove histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     */
    public function removeHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri->removeElement($histmatri);
    }

    /**
     * Get histmatri
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatri()
    {
        return $this->histmatri;
    }

    /**
     * Add histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     * @return Especialidad
     */
    public function addHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado[] = $histmatriegresado;
    
        return $this;
    }

    /**
     * Remove histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     */
    public function removeHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado->removeElement($histmatriegresado);
    }

    /**
     * Get histmatriegresado
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatriegresado()
    {
        return $this->histmatriegresado;
    }

    /**
     * Set programa
     *
     * @param \AppBundle\Entity\Programa $programa
     * @return Especialidad
     */
    public function setPrograma(\AppBundle\Entity\Programa $programa = null)
    {
        $this->programa = $programa;
    
        return $this;
    }

    /**
     * Get programa
     *
     * @return \AppBundle\Entity\Programa 
     */
    public function getPrograma()
    {
        return $this->programa;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     * @return Especialidad
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Add creditos
     *
     * @param \AppBundle\Entity\CreditosGraduando $creditos
     * @return Especialidad
     */
    public function addCredito(\AppBundle\Entity\CreditosGraduando $creditos)
    {
        $this->creditos[] = $creditos;
    
        return $this;
    }

    /**
     * Remove creditos
     *
     * @param \AppBundle\Entity\CreditosGraduando $creditos
     */
    public function removeCredito(\AppBundle\Entity\CreditosGraduando $creditos)
    {
        $this->creditos->removeElement($creditos);
    }

    /**
     * Get creditos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCreditos()
    {
        return $this->creditos;
    }

    /**
     * Add extension
     *
     * @param \AppBundle\Entity\ExtensionesUsuarios $extension
     * @return Especialidad
     */
    public function addExtension(\AppBundle\Entity\ExtensionesUsuarios $extension)
    {
        $this->extension[] = $extension;
    
        return $this;
    }

    /**
     * Remove extension
     *
     * @param \AppBundle\Entity\ExtensionesUsuarios $extension
     */
    public function removeExtension(\AppBundle\Entity\ExtensionesUsuarios $extension)
    {
        $this->extension->removeElement($extension);
    }

    /**
     * Get extension
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getExtension()
    {
        return $this->extension;
    }
    
    public function __toString() {
        return $this->getNombre();
    }

    /**
     * Add subsedeespe
     *
     * @param \AppBundle\Entity\SubSedeEspe $subsedeespe
     *
     * @return Especialidad
     */
    public function addSubsedeespe(\AppBundle\Entity\SubSedeEspe $subsedeespe)
    {
        $this->subsedeespe[] = $subsedeespe;

        return $this;
    }

    /**
     * Remove subsedeespe
     *
     * @param \AppBundle\Entity\SubSedeEspe $subsedeespe
     */
    public function removeSubsedeespe(\AppBundle\Entity\SubSedeEspe $subsedeespe)
    {
        $this->subsedeespe->removeElement($subsedeespe);
    }

    /**
     * Get subsedeespe
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSubsedeespe()
    {
        return $this->subsedeespe;
    }
}
