<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ofer_acade")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\OfertAcadeRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class OfertAcade {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Cursos", inversedBy="oferacade")
     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")
     */
    protected $curso;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $seccion;

    
    
    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $horario;
    
    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $descripc_horario;
    
    /**
     * @ORM\ManyToOne(targetEntity="Profesor", inversedBy="oferacade")
     * @ORM\JoinColumn(name="profesor_id", referencedColumnName="id")
     */
    protected $profesor;
    
    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $cantidad_cupos;
    
    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $cantidad_alumnos;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $estado_ofeta;
    
    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    protected $fecha_trans;
    
    /**
     * @ORM\Column(type="datetime")
     */
    protected $fecha_inclusion;
    
    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="oferacade")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;
    
    /**
     * @ORM\ManyToOne(targetEntity="Programa", inversedBy="oferacade")
     * @ORM\JoinColumn(name="programa_id", referencedColumnName="id")
     */
    protected $programa;
    
  
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="oferacade")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $impresa;
    
    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    protected $numero_acta;

    /**
     * @ORM\ManyToOne(targetEntity="Sessiones", inversedBy="oferacade")
     * @ORM\JoinColumn(name="session_id", referencedColumnName="id")
     */
    protected $session;
    
    /**
     * @ORM\OneToMany(targetEntity="Matricula", mappedBy="oferta")
     */
    protected $matricula;
    
    /**
     * @ORM\ManyToOne(targetEntity="Cohorte", inversedBy="oferacade")
     * @ORM\JoinColumn(name="cohorte_id", referencedColumnName="id")
     */
    protected $cohorte;
    
    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="oferacade")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;
    
    
     /**
     * @ORM\ManyToOne(targetEntity="Modalidad", inversedBy="oferacade")
     * @ORM\JoinColumn(name="modalidad_id", referencedColumnName="id")
     */
    protected $modalidad;
    
         /**
     * @ORM\ManyToOne(targetEntity="Ambiente", inversedBy="oferacade")
     * @ORM\JoinColumn(name="ambiente_id", referencedColumnName="id")
     */
    protected $ambiente;
    
     /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="oferacade")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    protected $especialidad;

    // METODOS GENERADOS PARA LAS CONSULTAS //    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set seccion
     *
     * @param string $seccion
     * @return OfertAcade
     */
    public function setSeccion($seccion)
    {
        $this->seccion = $seccion;
    
        return $this;
    }

    /**
     * Get seccion
     *
     * @return string 
     */
    public function getSeccion()
    {
        return $this->seccion;
    }

   
   

    /**
     * Set horario
     *
     * @param string $horario
     * @return OfertAcade
     */
    public function setHorario($horario)
    {
        $this->horario = $horario;
    
        return $this;
    }

    /**
     * Get horario
     *
     * @return string 
     */
    public function getHorario()
    {
        return $this->horario;
    }

    /**
     * Set cantidad_cupos
     *
     * @param integer $cantidadCupos
     * @return OfertAcade
     */
    public function setCantidadCupos($cantidadCupos)
    {
        $this->cantidad_cupos = $cantidadCupos;
    
        return $this;
    }

    /**
     * Get cantidad_cupos
     *
     * @return integer 
     */
    public function getCantidadCupos()
    {
        return $this->cantidad_cupos;
    }

    /**
     * Set cantidad_alumnos
     *
     * @param integer $cantidadAlumnos
     * @return OfertAcade
     */
    public function setCantidadAlumnos($cantidadAlumnos)
    {
        $this->cantidad_alumnos = $cantidadAlumnos;
    
        return $this;
    }

    /**
     * Get cantidad_alumnos
     *
     * @return integer 
     */
    public function getCantidadAlumnos()
    {
        return $this->cantidad_alumnos;
    }

    /**
     * Set estado_ofeta
     *
     * @param boolean $estadoOfeta
     * @return OfertAcade
     */
    public function setEstadoOfeta($estadoOfeta)
    {
        $this->estado_ofeta = $estadoOfeta;
    
        return $this;
    }

    /**
     * Get estado_ofeta
     *
     * @return boolean 
     */
    public function getEstadoOfeta()
    {
        return $this->estado_ofeta;
    }

    /**
     * Set fecha_trans
     *
     * @param \DateTime $fechaTrans
     * @return OfertAcade
     */
    public function setFechaTrans($fechaTrans)
    {
        $this->fecha_trans = $fechaTrans;
    
        return $this;
    }

    /**
     * Get fecha_trans
     *
     * @return \DateTime 
     */
    public function getFechaTrans()
    {
        return $this->fecha_trans;
    }

    /**
     * Set fecha_inclusion
     *
     * @param \DateTime $fechaInclusion
     * @return OfertAcade
     */
    public function setFechaInclusion($fechaInclusion)
    {
        $this->fecha_inclusion = $fechaInclusion;
    
        return $this;
    }

    /**
     * Get fecha_inclusion
     *
     * @return \DateTime 
     */
    public function getFechaInclusion()
    {
        return $this->fecha_inclusion;
    }

    /**
     * Set impresa
     *
     * @param boolean $impresa
     * @return OfertAcade
     */
    public function setImpresa($impresa)
    {
        $this->impresa = $impresa;
    
        return $this;
    }

    /**
     * Get impresa
     *
     * @return boolean 
     */
    public function getImpresa()
    {
        return $this->impresa;
    }

    /**
     * Set curso
     *
     * @param AppBundle\Entity\Cursos $curso
     * @return OfertAcade
     */
    public function setCurso(\AppBundle\Entity\Cursos $curso = null)
    {
        $this->curso = $curso;
    
        return $this;
    }

    /**
     * Get curso
     *
     * @return AppBundle\Entity\Cursos 
     */
    public function getCurso()
    {
        return $this->curso;
    }

    /**
     * Set profesor
     *
     * @param AppBundle\Entity\Profesor $profesor
     * @return OfertAcade
     */
    public function setProfesor(\AppBundle\Entity\Profesor $profesor = null)
    {
        $this->profesor = $profesor;
    
        return $this;
    }

    /**
     * Get profesor
     *
     * @return AppBundle\Entity\Profesor 
     */
    public function getProfesor()
    {
        return $this->profesor;
    }

    /**
     * Set lapso
     *
     * @param AppBundle\Entity\Lapso $lapso
     * @return OfertAcade
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return AppBundle\Entity\Lapso 
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set programa
     *
     * @param AppBundle\Entity\Programa $programa
     * @return OfertAcade
     */
    public function setPrograma(\AppBundle\Entity\Programa $programa = null)
    {
        $this->programa = $programa;
    
        return $this;
    }

    /**
     * Get programa
     *
     * @return AppBundle\Entity\Programa 
     */
    public function getPrograma()
    {
        return $this->programa;
    }



    /**
     * Set sede
     *
     * @param AppBundle\Entity\Sede $sede
     * @return OfertAcade
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->matricula = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add matricula
     *
     * @param AppBundle\Entity\Matricula $matricula
     * @return OfertAcade
     */
    public function addMatricula(\AppBundle\Entity\Matricula $matricula)
    {
        $this->matricula[] = $matricula;
    
        return $this;
    }

    /**
     * Remove matricula
     *
     * @param AppBundle\Entity\Matricula $matricula
     */
    public function removeMatricula(\AppBundle\Entity\Matricula $matricula)
    {
        $this->matricula->removeElement($matricula);
    }

    /**
     * Get matricula
     *
     * @return Doctrine\Common\Collections\Collection 
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
    
    /**
     *@ORM\PrePersist 
     */
    public function setValueOff(){
        $this->setEstadoOfeta(1);
        $this->setFechaInclusion(new \DateTime());
        $this->setImpresa(0);
        $this->setCantidadAlumnos(0);
                
    }

    /**
     * Set numero_acta
     *
     * @param integer $numeroActa
     * @return OfertAcade
     */
    public function setNumeroActa($numeroActa)
    {
        $this->numero_acta = $numeroActa;
    
        return $this;
    }

    /**
     * Get numero_acta
     *
     * @return integer 
     */
    public function getNumeroActa()
    {
        return $this->numero_acta;
    }

    /**
     * Set session
     *
     * @param \AppBundle\Entity\Sessiones $session
     * @return OfertAcade
     */
    public function setSession(\AppBundle\Entity\Sessiones $session = null)
    {
        $this->session = $session;
    
        return $this;
    }

    /**
     * Get session
     *
     * @return \AppBundle\Entity\Sessiones 
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Set descripc_horario
     *
     * @param string $descripcHorario
     * @return OfertAcade
     */
    public function setDescripcHorario($descripcHorario)
    {
        $this->descripc_horario = $descripcHorario;
    
        return $this;
    }

    /**
     * Get descripc_horario
     *
     * @return string 
     */
    public function getDescripcHorario()
    {
        return $this->descripc_horario;
    }

    /**
     * Set cohorte
     *
     * @param \AppBundle\Entity\Cohorte $cohorte
     * @return OfertAcade
     */
    public function setCohorte(\AppBundle\Entity\Cohorte $cohorte = null)
    {
        $this->cohorte = $cohorte;
    
        return $this;
    }

    /**
     * Get cohorte
     *
     * @return \AppBundle\Entity\Cohorte 
     */
    public function getCohorte()
    {
        return $this->cohorte;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     * @return OfertAcade
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;
    
        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede 
     */
    public function getSubsede()
    {
        return $this->subsede;
    }

    /**
     * Set modalidad
     *
     * @param \AppBundle\Entity\Modalidad $modalidad
     *
     * @return OfertAcade
     */
    public function setModalidad(\AppBundle\Entity\Modalidad $modalidad = null)
    {
        $this->modalidad = $modalidad;

        return $this;
    }

    /**
     * Get modalidad
     *
     * @return \AppBundle\Entity\Modalidad
     */
    public function getModalidad()
    {
        return $this->modalidad;
    }
    
    /**
     * Set especialidad
     *
     * @param AppBundle\Entity\Especialidad $especialidad
     * @return OfertAcade
     */
    public function setEspecialidad(\AppBundle\Entity\Especialidad $especialidad = null)
    {
        $this->especialidad = $especialidad;
    
        return $this;
    }

    /**
     * Get especialidad
     *
     * @return AppBundle\Entity\Especialidad 
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }
    
    
    /**
     * Set ambiente
     *
     * @param \AppBundle\Entity\Ambiente $ambiente
     *
     * @return OfertAcade
     */
    public function setAmbiente(\AppBundle\Entity\Ambiente $ambiente = null)
    {
        $this->ambiente = $ambiente;

        return $this;
    }

    /**
     * Get ambiente
     *
     * @return \AppBundle\Entity\Ambiente
     */
    public function getAmbiente()
    {
        return $this->ambiente;
    }
    
    
    
}
