<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * PlanEstudioRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PlanEstudioRepository extends EntityRepository
{
    public function consultMaterias($programa, $especialidad, $sede)
    {
        $em = $this->getEntityManager();
        $query = $em->createQuery(' '
                . 'SELECT p FROM AppBundle:PlanEstudio p '
                . 'LEFT JOIN p.curso cu '                                
                . 'WHERE '
                . 'p.programa = :programa AND '
                . 'p.especialidad = :especialidad AND '
                . 'p.sede = :sede '
                . 'ORDER BY p.semestre ASC');
        $query->setParameter('programa',$programa);
        $query->setParameter('especialidad',$especialidad);
        $query->setParameter('sede',$sede);        
        
        return $query->getResult();
    }

    public function consultMateriasOferta($programa, $especialidad, $sede)
    {
        $em = $this->getEntityManager();
        $query = $em->createQuery(' '
                . 'SELECT p FROM AppBundle:PlanEstudio p '
                . 'LEFT JOIN p.curso cu '                                
                . 'WHERE '
                . 'p.programa = :programa AND '
                . 'p.especialidad = :especialidad AND '
                . 'p.sede = :sede '
                . 'ORDER BY p.semestre ASC');
        $query->setParameter('programa',$programa);
        $query->setParameter('especialidad',$especialidad);
        $query->setParameter('sede',$sede);        
        
        return $query->getResult();
    }                            
    
   
}
