<?php

namespace AppBundle\Entity;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="tipo_exoneracion")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\TipoExoneracionRepository")
 */
class TipoExoneracion {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=100)
     */
    protected $descripcion;
    
    /**
     * @ORM\OneToMany(targetEntity="Exonerados", mappedBy="tipo")
     */
    protected $exonerados;
    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->exonerados = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     * @return TipoExoneracion
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;
    
        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string 
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Add exonerados
     *
     * @param \AppBundle\Entity\Exonerados $exonerados
     * @return TipoExoneracion
     */
    public function addExonerado(\AppBundle\Entity\Exonerados $exonerados)
    {
        $this->exonerados[] = $exonerados;
    
        return $this;
    }

    /**
     * Remove exonerados
     *
     * @param \AppBundle\Entity\Exonerados $exonerados
     */
    public function removeExonerado(\AppBundle\Entity\Exonerados $exonerados)
    {
        $this->exonerados->removeElement($exonerados);
    }

    /**
     * Get exonerados
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getExonerados()
    {
        return $this->exonerados;
    }
    
    public function __toString() {
        return $this->getDescripcion();
    }
}
