<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="uc")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\UcRepository")
 */
class Uc {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="integer", length=1)
     */
    protected $unidad;
    
    /**
     * @ORM\Column(type="float", scale=2)
     */
    protected $monto;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="uc")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set unidad
     *
     * @param integer $unidad
     * @return Uc
     */
    public function setUnidad($unidad)
    {
        $this->unidad = $unidad;
    
        return $this;
    }

    /**
     * Get unidad
     *
     * @return integer 
     */
    public function getUnidad()
    {
        return $this->unidad;
    }

    /**
     * Set monto
     *
     * @param float $monto
     * @return Uc
     */
    public function setMonto($monto)
    {
        $this->monto = $monto;
    
        return $this;
    }

    /**
     * Get monto
     *
     * @return float 
     */
    public function getMonto()
    {
        return $this->monto;
    }

    /**
     * Set sede
     *
     * @param AppBundle\Entity\Sede $sede
     * @return Uc
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }
}
