<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * @ORM\Table(name="usuarios")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\UsuariosRepository")
 */
class Usuarios implements UserInterface{
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=12, unique=true)
     */
    protected $cedula;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $nombre;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $apellido;
    
    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $salf;
    
    /**
     * @ORM\Column(type="string")
     */
    protected $password;
    
    /**
     * @ORM\Column(type="string")
     */
    protected $email;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="usuario")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\OneToMany(targetEntity="Sessiones", mappedBy="usuario")
     */
    protected $session;
    
    /**
     * @ORM\OneToMany(targetEntity="MenuUsuario", mappedBy="usuario")
     */
    protected $menusu;

    /**
     * @ORM\OneToMany(targetEntity="SubSedeUsuario", mappedBy="usuario")
     */
    protected $subsedeusuario;
    
    /**
     * @ORM\OneToMany(targetEntity="ExtensionesUsuarios", mappedBy="usuario")
     */
    protected $extensiones;


    // METODOS GENERADOS PARA LAS CONSULTAS //


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set cedula
     *
     * @param string $cedula
     * @return Usuarios
     */
    public function setCedula($cedula)
    {
        $this->cedula = $cedula;
    
        return $this;
    }

    /**
     * Get cedula
     *
     * @return string 
     */
    public function getCedula()
    {
        return $this->cedula;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return Usuarios
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return string 
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set apellido
     *
     * @param string $apellido
     * @return Usuarios
     */
    public function setApellido($apellido)
    {
        $this->apellido = $apellido;
    
        return $this;
    }

    /**
     * Get apellido
     *
     * @return string 
     */
    public function getApellido()
    {
        return $this->apellido;
    }

    /**
     * Set salf
     *
     * @param string $salf
     * @return Usuarios
     */
    public function setSalf($salf)
    {
        $this->salf = $salf;
    
        return $this;
    }

    /**
     * Get salf
     *
     * @return string 
     */
    public function getSalf()
    {
        return $this->salf;
    }

    /**
     * Set password
     *
     * @param string $password
     * @return Usuarios
     */
    public function setPassword($password)
    {
        $this->password = $password;
    
        return $this;
    }

    /**
     * Get password
     *
     * @return string 
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Set email
     *
     * @param string $email
     * @return Usuarios
     */
    public function setEmail($email)
    {
        $this->email = $email;
    
        return $this;
    }

    /**
     * Get email
     *
     * @return string 
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set sede
     *
     * @param AppBundle\Entity\Sede $sede
     * @return Usuarios
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    public function eraseCredentials() {
        
    } 
    
    public function getRoles() {
        if($this->getCedula()=='18897528' || $this->getCedula()=='12699101' || $this->getCedula()=='13643819'){
        return array('ROLE_SUPER_ADMIN');
        }else
        {
        return array('ROLE_ADMIN');   
        }
        }
    public function getSalt() {

        }
    public function getUsername() {
        return $this->nombre.' '.$this->apellido;
        }
        
    public function equals(UserInterface $user){
        return md5($this->getCedula()) == md5($user->getUsername());
        }
    
    
    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->session = new \Doctrine\Common\Collections\ArrayCollection();
        $this->subsedeusuario = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add session
     *
     * @param \AppBundle\Entity\Sessiones $session
     * @return Usuarios
     */
    public function addSession(\AppBundle\Entity\Sessiones $session)
    {
        $this->session[] = $session;
    
        return $this;
    }

    /**
     * Remove session
     *
     * @param \AppBundle\Entity\Sessiones $session
     */
    public function removeSession(\AppBundle\Entity\Sessiones $session)
    {
        $this->session->removeElement($session);
    }

    /**
     * Get session
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Add menusu
     *
     * @param \AppBundle\Entity\MenuUsuario $menusu
     * @return Usuarios
     */
    public function addMenusu(\AppBundle\Entity\MenuUsuario $menusu)
    {
        $this->menusu[] = $menusu;
    
        return $this;
    }

    /**
     * Remove menusu
     *
     * @param \AppBundle\Entity\MenuUsuario $menusu
     */
    public function removeMenusu(\AppBundle\Entity\MenuUsuario $menusu)
    {
        $this->menusu->removeElement($menusu);
    }

    /**
     * Get menusu
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getMenusu()
    {
        return $this->menusu;
    }
    
   /**
     * Add subsedeusu
     *
     * @param \AppBundle\Entity\SubSedeUsuario $subsedeusuario
     * @return Usuarios
     */
    public function addSubsedeusuario(\AppBundle\Entity\SubSedeUsuario $subsedeusuario)
    {
        $this->subsedeusuario[] = $subsedeusuario;
    
        return $this;
    }

    /**
     * Remove subsedeusu
     *
     * @param \AppBundle\Entity\SubSedeUsuario $subsedeusuario
     */
    public function removeSubsedeusuario(\AppBundle\Entity\SubSedeUsuario $subsedeusuario)
    {
        $this->subsedeusuario->removeElement($subsedeusuario);
    }

    /**
     * Get subsedeusu
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSubsedeusuario()
    {
        return $this->subsedeusuario;
    }

    /**
     * Add extensiones
     *
     * @param \AppBundle\Entity\ExtensionesUsuarios $extensiones
     * @return Usuarios
     */
    public function addExtensione(\AppBundle\Entity\ExtensionesUsuarios $extensiones)
    {
        $this->extensiones[] = $extensiones;
    
        return $this;
    }

    /**
     * Remove extensiones
     *
     * @param \AppBundle\Entity\ExtensionesUsuarios $extensiones
     */
    public function removeExtensione(\AppBundle\Entity\ExtensionesUsuarios $extensiones)
    {
        $this->extensiones->removeElement($extensiones);
    }

    /**
     * Get extensiones
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getExtensiones()
    {
        return $this->extensiones;
    }
}
