<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Utils\ReporteLayout;
use AppBundle\Utils\Util2;
use AppBundle\Utils\Util;
use UsersBundle\Entity\Users;
use UsersBundle\Entity\Role;
use AppBundle\Entity\Profesor;
use AppBundle\Form\ProfesorType;

use Doctrine\ORM\EntityRepository;
/**
 * Description of BackendProfesorController
 *
 * @author jose
 */

class BackendProfesorController extends Controller {
    
    public function includeHeadProfAction(){
        $datenow = new \DateTime();
        return $this->render('AppBundle:BackendProfesores:includes/head.html.twig', array('datenow'=>$datenow));
    }
    
    public function includeAsideLeftProfAction()
    {
        return $this->render('AppBundle:BackendProfesores:includes/aside_left.html.twig', array());
    }
    
    /**
     * @Route("/app/backend/profesor/index", name="app_homepage_profesor")
     */
    public function indexAction(){
        $entity = $this->getUser()->getSede()->getCodigo();
        $this->get('session')->set('em', $entity);
        $this->get('session')->set('cedulaprof', $this->getUser()->getCedula());

        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $cedula = $this->getUser()->getCedula();
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $datosProf = $em->getRepository('AppBundle:Profesor')->findOneBy(array('cedula'=>  $this->get('session')->get('cedulaprof')));        
        $ProcesoInsc = $em->getRepository('AppBundle:Procesos')->findByProcesoI($fechanow);
        $ProcesoNota = $em->getRepository('AppBundle:Procesos')->findByProcesoN($fechanow);
        
        $lapso = 'Desactivado';

        if ($ProcesoInsc != null){
            foreach ($ProcesoInsc as $lapsoI){
                $lapso = $lapsoI->getLapso();
            }
        }        
        
        $this->get('session')->set('lapsoInsc', $ProcesoInsc);
        $this->get('session')->set('lapsoNota', $ProcesoNota);
        $this->get('session')->set('datosProf', $datosProf);
        
        return $this->render('AppBundle:BackendProfesores:views/index.html.twig', array(            
            'lapso'=>$lapso,
            'cedula'=>$cedula,
        ));
    }

    /**
     * @Route("/app/backend/edit/profesor/{id}", name="app_backend_profesor_edit")
     */
    public function editProfesorAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Profesor')->find($id);
        $form = $this->formEditProfesor($entity, $em);
        
        return $this->render('AppBundle:BackendProfesores:views/edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }

 /**
     * @Route("/app/backend/update/profesor/{id}", name="app_backend_update_profesor", requirements={"_method":"PUT"})
     */
    public function updateProfesorAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Profesor')->find($id);

        $em2 = $this->getDoctrine()->getManager();
        $cedulaprofesor = $entity->getCedula();
	//echo $cedulausuario;die();
        $entity2 = $em2->getRepository('UsersBundle:Users')->findOneBy(array('cedula'=>$cedulaprofesor));
// 	var_dump($iduser); die();
     //   $entities2 = $em2->getRepository('UsersBundle:Users')->find($iduser->getId());


        $form = $this->formEditProfesor($entity, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            if ($form->get('submit')->isClicked()) {
            $em->persist($entity);
            $em->flush();

            //$password = $this->get('request')->request->get('password');
            $password = $entity->getPassword();
            $email = $entity->getEmail();
            $cedula = $entity->getCedula();
            $encoder  = $this->get('security.encoder_factory')->getEncoder($entity2);
            $entity2->setSalt(md5(time()));
            $passwordCodifi = $encoder->encodePassword($password, $entity2->getSalt());
            $entity2->setPassword($passwordCodifi);
            $entity2->setEmail($email);
            $entity2->setCedula($cedula);

            $em2->persist($entity2);
            $em2->flush();

            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
          } 
            return $this->redirect($this->generateUrl('app_homepage_profesor'));
        }
        
        return $this->render('AppBundle:BackendProfesores:views/edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formEditProfesor(Profesor $entity, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new ProfesorType($em), $entity, array(
            'action'=>$this->generateUrl('app_backend_update_profesor', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/backend/profesor/transcripcion", name="app_backend_profesor_transcripcion")
     */
    public function cursosTranscripcionAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $lapsoN = $this->get('session')->get('lapsoNota');

        $profesor = $this->get('session')->get('datosProf');
        
        if(!$lapsoN){
            $this->get('session')->getFlashBag()->add('msg-error', 'PROCESO CERRADO PARA LA FECHA ACTUAL');
            return $this->redirect($request->headers->get('referer'));
        }

        foreach ($lapsoN as $value){
            $lapso = $value->getLapso();
        
        $cursosTransc = $em->getRepository('AppBundle:OfertAcade')->findCursoTransNew($profesor, $lapso);
        }

        if(!$cursosTransc)
        {
            $this->get('session')->getFlashBag()->add('msg-error', 'No tiene curso asignados!');
            return $this->redirect($this->generateUrl('app_homepage_profesor'));
        }
        if($request->get('id')!==null)
        {
            $id = $request->get('id');
            $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
            $curso = $oferta->getCurso();
            $cursoEspecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
            $entities = $em->getRepository('AppBundle:Matricula')->findAlumnosByCursoA($oferta);
            $condiciones = $em->getRepository('AppBundle:CondCurso')->findBy(array('codigo'=>array('APR', 'APLZ', 'PROC')));
            return $this->render('AppBundle:BackendProfesores:views/transcripcion/index.html.twig', array(
                'entities'=>$cursosTransc,
                'matricula'=>$entities, 
                'cursoisEspecial'=>$cursoEspecial,
                'conditions'=>$condiciones
            ));
        }
        
        return $this->render('AppBundle:BackendProfesores:views/transcripcion/index.html.twig', array(
            'entities'=>$cursosTransc,
            'lapso'=>$lapso,
        ));
    }
    
    /**
     * @Route("/app/backend/profesor/process/transcripcion", name="app_backend_profesor_process_transcripcion")
     */
    public function procesarTranscripcion(Request $request)
    {
        $reqMatricula = $request->get('matricula');
        $reqNotas= $request->get('notas');
        $oferta_id = $request->get('ofertaid');
        $id_histM = '';
        $cargas = '';
        $profesor_id = $this->get('session')->get('datosProf');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $profesor = $em->getRepository('AppBundle:Profesor')->find($profesor_id); 
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $conditionAprob = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'APR'));
        $conditionAplz  = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'APLZ'));
        $conditionProc  = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('codigo'=>'PROC'));
        $oferta         = $em->getRepository('AppBundle:OfertAcade')->find($oferta_id);
        $curso          = $oferta->getCurso();
        $cursoEspecial  = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
        $cualitativo = false;
        if($cursoEspecial)
            if($cursoEspecial->getModoTranscripcion()->getDescripcion()=='Cualitativo')
                $cualitativo = true;        
        
        if(!$oferta)
            throw new Exception ("Oferta no encontrada");


        for ($i = 0; $i<count($reqMatricula); $i++)
        {
            $idM =  $reqMatricula[$i];
            $matricula = $em->getRepository('AppBundle:Matricula')->find($idM);
            if(!$matricula)
                throw new Exception ('No se encontro matricula señalada !!');
            $cargas = $matricula->getCargas();

            if($cargas == 5){
                $this->get('session')->getFlashBag()->add('msg-error',' NO PUEDE VOLVER A CARGAR CALIFICACIONES!');
                return $this->redirect($request->headers->get('referer'));
            }
                
            $nota = $reqNotas[$i];

            if ($matricula->getNota()!=$nota && $cargas == 1){

                $matricula->setStatus('Actualizado');

                $newAuditoria = new \AppBundle\Entity\AuditoriaNotas();
                $newAuditoria->setEstudiante($matricula->getEstudiante());
                $newAuditoria->setMatricula($matricula);
                $newAuditoria->setEspecialidad($matricula->getEstudiante()->getEspecialidad());
                $newAuditoria->setCurso($matricula->getOferta()->getCurso());
                $newAuditoria->setCondicion($matricula->getCondicion());
                $newAuditoria->setSeccion($matricula->getOferta()->getSeccion());           
                $newAuditoria->setProfesor($profesor);                
                $newAuditoria->setLapso($matricula->getOferta()->getLapso());
                $newAuditoria->setNota($matricula->getNota());
                $newAuditoria->setProceso('Carga de Notas Actualizada');
                $newAuditoria->setNotaActual($nota);
                $newAuditoria->setFechaHora(new \DateTime("now"));
                
                $em->persist($newAuditoria);
            }

            if(!$cualitativo){
                $cargas += '1';
                $matricula->setCargas($cargas);
                if($nota>=6)
                    $matricula->setCondicion($conditionAprob);
                elseif($nota<6)
                    $matricula->setCondicion($conditionAplz);
            }else{
                $condition = $em->getRepository('AppBundle:CondCurso')->find($nota);
                $matricula->setCondicion($condition);
            }

            $matricula->setNota($nota);
            $em->persist($matricula);
            
            //ACTUALIZAR HIST_MATRI
            $histExist = $em->getRepository('AppBundle:HistMatri')->findOneByMatricula($matricula->getId());

            if(!$histExist)
            {

                $newHistMatri = new \AppBundle\Entity\HistMatri();
                $newHistMatri->setMatricula($matricula);
                $newHistMatri->setCondicion($matricula->getCondicion());
                $newHistMatri->setCurso($matricula->getOferta()->getCurso());
                $newHistMatri->setEspecialidad($matricula->getEstudiante()->getEspecialidad());
                $newHistMatri->setEstudiante($matricula->getEstudiante());
                $newHistMatri->setLapso($matricula->getOferta()->getLapso());
                $newHistMatri->setNota($matricula->getNota());
                $newHistMatri->setObs('Pasado Matricula '.$matricula->getOferta()->getLapso()->getCodigo());
                $newHistMatri->setPrograma($matricula->getOferta()->getPrograma());
                $newHistMatri->setSede($matricula->getOferta()->getSede());
                $newHistMatri->setUc($matricula->getOferta()->getCurso()->getUc());
                $newHistMatri->setSeccion($matricula->getOferta()->getSeccion());
                $em->persist($newHistMatri);
          
        
            }else{

                $id_histM = $histExist->getId();

                $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
                $entity = $em->getRepository('AppBundle:HistMatri')->find($id_histM);

                $entity->setMatricula($matricula);
                $entity->setCondicion($matricula->getCondicion());
                $entity->setNota($matricula->getNota());
                $em->persist($entity);
                $em->flush();                
            }
        }
        
        $oferta->setFechaTrans(new \DateTime());
        $em->persist($oferta);
        
        $em->flush();
        
        $this->get('session')->getFlashBag()->add('msg-success','Datos guardadados con exito !');
        return $this->redirect($this->generateUrl('app_backend_profesor_transcripcion', array('id'=>$oferta->getId())));
    }
    
    /**
     * @Route("/app/backend/profesor/reportes/acta/{id}", name="app_backend_profesor_reporte_acta")
     */
    public function reportActaAction($id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $curso          = $oferta->getCurso();
        $subsedeausar = $oferta->getSubSede()->getId();
        $cursoEspecial  = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso'=>$curso->getId()));
        $cualitativo = false;
        if($cursoEspecial)
            if($cursoEspecial->getModoTranscripcion()->getDescripcion()=='Cualitativo')
                $cualitativo = true;
        
	
        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('subsede'=>$subsedeausar,'cargo'=>$cargo, 'activo'=>$activo));
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesByOferta($oferta);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->setActa($oferta->getNumeroActa());
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(10,20,60,60,10,30));
        $pdf->SetAligns(array('C','C','L', 'L', 'C', 'C'));
        //srand(microtime()*1000000);
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->titleReport('Acta de Calificaciones');

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getPrograma()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(26,10,utf8_decode('Sede/Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getSubSede()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$oferta->getEspecialidad()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(11,10,utf8_decode('Curso: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(128,10,utf8_decode(''.$oferta->getCurso()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Sección: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(20,10,utf8_decode(''.$oferta->getSeccion()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(13,10,utf8_decode('Horario: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(126,10,utf8_decode(''.$oferta->getHorario()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Cohorte: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getCohorte()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(16,10,utf8_decode('Ambiente: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(123,10,utf8_decode(''.$oferta->getAmbiente()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getLapso()),0,'L');
            $pdf->Ln(10);
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('N°','Cédula', 'Nombre', 'Apellidos', 'Nota','Condicion');
        $pdf->RowTitles($titles); 
        
        $index = 1;
        $aplaz = 0;
        $aprob = 0;
        $proc = 0;
       
        foreach ($entities as $value){

            $nota = ($cualitativo) ? '':$value->getNota();

            $pdf->RowBorders(array($index,
                    $value->getEstudiante()->getEstudiante()->getCedula(),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getEstudiante()->getSegundoNombre()),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getEstudiante()->getSegundoApellido()),
                    $nota,
                    $value->getCondicion(),
            ), 1);
            if($value->getCondicion()->getCodigo()=='APLZ'){
                $aplaz++;
            }elseif($value->getCondicion()->getCodigo()=='APR'){
                $aprob++;
            }elseif($value->getCondicion()->getCodigo()=='PROC'){
                $proc++;
            }
            
            $index++;

        }  

        $pdf->Ln(5);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(($cualitativo)? 47.5: 120, 6,'Total estudiantes: '.count($entities), '',0,'L');
        $pdf->Cell(($cualitativo)? 47.5: 35, 6,'Total Aprobados: '.$aprob, '',0,'R');
        $pdf->Cell(($cualitativo)? 47.5: 35, 6,'Total Aplazado: '.($aplaz), '',0,'R');
        if($cualitativo)
            $pdf->Cell(47.5, 6,'Total En Proceso: '.($proc), '',1,'C');

        $pdf->SetFont('helvetica','B',9);
    $pdf->Ln(30);
        $pdf->Cell(63,10,  utf8_decode($oferta->getProfesor()),'T',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
    $pdf->Ln(5);
    $pdf->Cell(63,10,utf8_decode('C.I.: '.number_format($oferta->getProfesor()->getCedula(), 0, '', '.')),'',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
        $pdf->Cell(64, 10,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
    $pdf->Ln(5);
        $pdf->Cell(63,10,  utf8_decode(' Profesor(a)'),'',0,'C');
    $pdf->Ln(5);
    $pdf->Cell(63,10,'',0,0,'C');
    $pdf->Cell(64, 10,  utf8_decode('Sello'),'',0,'C');
    $pdf->Ln(5);
        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }

    /**
     * @Route("/app/backend/profesor/reportes/listado/clases/", name="app_backend_profesor_listado_clase")
     */
    public function listadoInscritosClasesAction(){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $lapsoI = $this->get('session')->get('lapsoInsc');

        if(!$lapsoI){
            $this->get('session')->getFlashBag()->add('msg-error', 'PROCESO CERRADO');
            return $this->redirect($this->generateUrl('app_homepage_profesor'));
        }

        foreach ($lapsoI as $value){
            $lapso = $value->getLapso();
            $profesor = $this->get('session')->get('datosProf');
            $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaListadoClase($profesor, $lapso);

            if(!$oferta)
            {
                $this->get('session')->getFlashBag()->add('msg-error', 'No tiene curso asignados!');
                return $this->redirect($this->generateUrl('app_homepage_profesor'));
            }

        }
                
        return $this->render('AppBundle:BackendProfesores:views/listado_clase/index.html.twig', array(
            'oferta'=>$oferta,
            'lapso'=>$lapso
        ));
    }
    
    /**
     * @Route("/app/backend/profesor/reportes/listado/{id}", name="app_backend_profesor_reporte_listado")
     */
    public function reportListadoClasesAction($id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesByOferta($oferta);

        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('cargo'=>$cargo, 'activo'=>$activo));
        
        $cualitativo = false;
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(10,20,80,80));
        $pdf->SetAligns(array('C','C','L', 'L'));
        //srand(microtime()*1000000);
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->titleReport('Listado de Clases');

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getPrograma()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(26,10,utf8_decode('Sede/Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getSubSede()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$oferta->getEspecialidad()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(11,10,utf8_decode('Curso: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(128,10,utf8_decode(''.$oferta->getCurso()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Sección: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(20,10,utf8_decode(''.$oferta->getSeccion()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(13,10,utf8_decode('Horario: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(126,10,utf8_decode(''.$oferta->getHorario()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Cohorte: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getCohorte()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(16,10,utf8_decode('Ambiente: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(123,10,utf8_decode(''.$oferta->getAmbiente()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getLapso()),0,'L');
            $pdf->Ln(10);
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('N°','Cédula', 'Nombre', 'Apellidos');
        $pdf->RowTitles($titles); 
        
        $index = 1;
        $aplaz = 0;
        $aprob = 0;
        $proc = 0;
        $nota = '';
       
        foreach ($entities as $value){

            $calificacion = ($cualitativo) ? '':$value->getNota();

            if($value->getCondicion()!='INSCRITO'){
                $nota = $calificacion;
            }

            $pdf->RowBorders(array($index,
                    $value->getEstudiante()->getEstudiante()->getCedula(),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getEstudiante()->getSegundoNombre()),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getEstudiante()->getSegundoApellido()),
            ), 1);
            
            $index++;

        }  

        $pdf->Ln(5);
    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(19,10,utf8_decode('Profesor(a): '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(140,10,utf8_decode(''.utf8_decode($oferta->getProfesor())),0,'L');
    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(28,10,utf8_decode('Total Estudiantes: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(5,10,utf8_decode(''.count($entities)),0,'L');
        $pdf->Ln(5);

    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(13,10,utf8_decode('Cédula: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(118,10,utf8_decode(''.number_format($oferta->getProfesor()->getCedula(), 0, '', '.')),0,'L');

        $pdf->Ln(30);

        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }

}
