<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Lapso;
use AppBundle\Form\LapsoType;

/**
 * Description of LapsoController
 *
 * @author jose
 */
class LapsoController extends Controller {
    
    /**
     *  @Route("/app/admin/lapsos", name="app_admin_lapsos_index")
     */
    public function indexAction()
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT l FROM AppBundle:Lapso l "
                . "ORDER BY l.codigo DESC ";
        $entities = $em->createQuery($query);

        $fechanow = new \DateTime();        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Lapsos:index.html.twig', array(
            'pagination'=>$pagination,
            'fechaactual'=>$fechanow
        ));
    }
    
    /**
     *  @Route("/app/admin/search/lapsos", name="app_admin_lapsos_search_index")
     */
    public function searchAction(Request $request)
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
        $query = "SELECT l FROM AppBundle:Lapso l "
                . "WHERE "
                . "l.codigo LIKE :text "
                . "ORDER BY l.codigo DESC ";
        $entities = $em->createQuery($query);        
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Lapsos:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     * @Route("/app/admin/edit/lapsos/{id}", name="app_admin_lapsos_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Lapso')->find($id);        
        $form = $this->editForm($entity);
        
        return $this->render('AppBundle:Lapsos:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/lapsos/{id}", name="app_admin_lapsos_update", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Lapso')->find($id);        
        $form = $this->editForm($entity);
        $fechanow = new \DateTime();
        $lapsoActivo = $em->getRepository('AppBundle:Lapso')->findOneByPeriodo($fechanow);
        
        $form->handleRequest($request);
        if($form->isValid()){

        $data = $form->getData();
        $codigo = $data->getCodigo();

        $periodoD = $em->getRepository('AppBundle:Lapso')->findEditable($id, $codigo);
        $periodoeditar = $em->getRepository('AppBundle:Lapso')->findByPeriodoT($id);
    
            if(!$lapsoActivo && !$periodoD){

                $ids = $this->getUser()->getSede()->getCodigo();
                $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                $entity->setSede($sede);

                $em->persist($entity);
                $em->flush();
                $this->get('session')->getFlashBag()->add('msg-success','¡REGISTRO MODIFICADO CON EXITO!');
                return $this->redirect($this->generateUrl('app_admin_lapsos_index'));

            }

            foreach ($lapsoActivo as $LapsoA){

                foreach ($periodoeditar as $PeriodoE){

                    if($codigo == $PeriodoE->getCodigo() && $LapsoA->getCodigo() == $PeriodoE->getCodigo() && !$periodoD){

                        $ids = $this->getUser()->getSede()->getCodigo();
                        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                        $entity->setSede($sede);

                        $em->persist($entity);
                        $em->flush();
                        $this->get('session')->getFlashBag()->add('msg-success', '¡REGISTRO MODIFICADO CON EXITO!');
                        return $this->redirect($this->generateUrl('app_admin_lapsos_index'));

                    }
                    
                }
                
            }

            if($periodoD){
                $this->get('session')->getFlashBag()->add('msg-error','YA EXISTE EL PERÍODO '. $codigo);
                return $this->redirect($this->generateUrl('app_admin_lapsos_index'));
            }

            foreach ($lapsoActivo as $LapsoA){
                $this->get('session')->getFlashBag()->add('msg-error', $LapsoA->getCodigo() .' ACTIVO');
                return $this->redirect($this->generateUrl('app_admin_lapsos_index'));
            }
            
        }
        
        return $this->render('AppBundle:Lapsos:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editForm(Lapso $entity)
    {
        $form = $this->createForm(new LapsoType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_lapsos_update', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/new/lapsos", name="app_admin_lapsos_new")
     */
    public function newAction()
    {
        $entity = new Lapso();
        $form = $this->newForm($entity);
        
        return $this->render('AppBundle:Lapsos:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/lapsos", name="app_admin_lapsos_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $entity = new Lapso();
        $form = $this->newForm($entity);
        $em2 = $this->getDoctrine()->getManager();
        
        $form->handleRequest($request);

        if($form->isValid())
        {
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

            $data = $form->getData();
            $codigo = $data->getCodigo();
            $issetCodigo = $em->getRepository('AppBundle:Lapso')->findByCodigo($codigo);
                if(!$issetCodigo){
                    $ids = $this->getUser()->getSede()->getCodigo();
                    $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
                    $entity->setSede($sede);
                    $em->persist($entity);
                    $em->flush();
                    $this->get('session')->getFlashBag()->add('msg-success', 'REGISTRO CREADO CON EXITO!');
                    return $this->redirect($this->generateUrl('app_admin_lapsos_index'));
                }
            $this->get('session')->getFlashBag()->add('msg-error', 'REGISTRO '. $codigo .' YA EXISTE');
        }
        
        return $this->render('AppBundle:Lapsos:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function newForm(Lapso $entity)
    {
        $form = $this->createForm(new LapsoType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_lapsos_create'),
            'method'=>'POST'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
}