<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use Doctrine\ORM\EntityRepository;

use AppBundle\Entity\OfertAcade;
use AppBundle\Form\OfertAcadeType;

class OfertaAcademicaController extends Controller {
        
    /**
     * @Route("/app/admin/ofertacad/consult/{programa}/{especialidad}/{lapso}/{sede}/{subsede}/{cohorte}", name="app_consult_oferta_academica")
     */
    public function indexAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL, $cohorte = NULL)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getEntityManager();
        
                $idusuario = $this->get('security.token_storage')->getToken()->getUser()->getId();
                $nrocedula = $em2->getRepository('UsersBundle:Users')->findOneBy(array('id'=>$idusuario))->getCedula();
                $idusuario = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$nrocedula))->getId();
        
        $form = $this->formConsultOferta($em, $programa, $idusuario);
        
        if($programa==NULL && $especialidad==NULL && $lapso==NULL && $sede==NULL&&$subsede==NULL && $cohorte==NULL){
            $oferta = NULL;
        }else{            
            $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        }
        return $this->render('AppBundle:Oferta:index.html.twig', array(
            'form'=>$form->createView(),
            'oferta'=>$oferta,
            'programa'=>$programa,
            'especialidad'=>$especialidad,
            'lapso'=>$lapso,
            'subsede'=>$subsede,
            'cohorte'=>$cohorte,
        ));        
        
    }


  /**
     * @Route("/app/admin/ofertacad/consultcurri/{programa}/{especialidad}/{lapso}/{sede}/{subsede}/{cohorte}", name="app_consultcurri_oferta_academica")
     */
    public function indexcurriAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL, $cohorte = NULL)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getEntityManager();
        
                $idusuario = $this->get('security.token_storage')->getToken()->getUser()->getId();
                $nrocedula = $em2->getRepository('UsersBundle:Users')->findOneBy(array('id'=>$idusuario))->getCedula();
                $idusuario = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$nrocedula))->getId();
        
        $form = $this->formConsultOferta($em, $programa, $idusuario);
        
        if($programa==NULL && $especialidad==NULL && $lapso==NULL && $sede==NULL&&$subsede==NULL && $cohorte==NULL){
            $oferta = NULL;
        }else{            
            $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        }
        return $this->render('AppBundle:Oferta:indexcurri.html.twig', array(
            'form'=>$form->createView(),
            'oferta'=>$oferta,
            'programa'=>$programa,
            'especialidad'=>$especialidad,
            'lapso'=>$lapso,
            'subsede'=>$subsede,
            'cohorte'=>$cohorte,
        ));        
        
    }


    
    /**
     * @Route("/app/admin/ofertacad/show", name="app_show_oferta_academica")
     */
    public function showOfertaAction(Request $request)
    {
        $programa = $request->get('programa_id');
        $especialidad = $request->get('especialidad_id');
        $lapso = $request->get('lapso_id');
        $cohorte = $request->get('cohorte_id');
        $subsede = $request->get('subsede_id');
        $actions = $request->get('actions');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
        
        $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        
        return $this->render('AppBundle:Oferta:show.html.twig', array(
            'oferta'=>$oferta,'listado'=>$actions
        ));
    }
    
    private function formConsultOferta(\Doctrine\ORM\EntityManager $em, $programa, $idusuario)
    {
        $form = $this->createFormBuilder()
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:50%;'),                    
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:Subsede',
                    'em'=>$em,                    
                    'empty_value'=>'Estructura Acádemica .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($idusuario){
                        $q = $er->createQueryBuilder('s')
                                ->leftJoin('s.subsedeusuario', 'su');
                                $q->where('su.usuario = '.$idusuario);
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->getForm();
        return $form;
    }


 /**
     * @Route("/app/admin/ofertacad/showcurri", name="app_show_ofertacurri_academica")
     */
    public function showcurriOfertaAction(Request $request)
    {
        $programa = $request->get('programa_id');
        $especialidad = $request->get('especialidad_id');
        $lapso = $request->get('lapso_id');
        $cohorte = $request->get('cohorte_id');
        $subsede = $request->get('subsede_id');
        $actions = $request->get('actions');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
        
        $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        
        return $this->render('AppBundle:Oferta:showcurri.html.twig', array(
            'oferta'=>$oferta,'listado'=>$actions
        ));
    }
    
    private function formConsultcurriOferta(\Doctrine\ORM\EntityManager $em, $programa, $idusuario)
    {
        $form = $this->createFormBuilder()
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:50%;'),                    
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:Subsede',
                    'em'=>$em,                    
                    'empty_value'=>'Estructura Acádemica .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($idusuario){
                        $q = $er->createQueryBuilder('s')
                                ->leftJoin('s.subsedeusuario', 'su');
                                $q->where('su.usuario = '.$idusuario);
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->getForm();
        return $form;
    }


    
    /**
     * @Route("/app/admin/ofertacad/new/{programa}/{especialidad}/{lapso}/{sede}/{subsede}/{cohorte}", name="app_new_oferta_academica")
     */
    public function newAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL, $cohorte = NULL)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getEntityManager();
        
                $idusuario = $this->get('security.token_storage')->getToken()->getUser()->getId();
                $nrocedula = $em2->getRepository('UsersBundle:Users')->findOneBy(array('id'=>$idusuario))->getCedula();
                $idusuario = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$nrocedula))->getId();
        $entity = new OfertAcade();
        $form = $this->formNewOfertAcade($entity, $em, $idusuario);
        
        $dias = $em->getRepository('AppBundle:Dias')->findAll();
        $bloque_h = $em->getRepository('AppBundle:BloqueHoras')->findAll();
        
        if($programa==NULL && $especialidad==NULL && $lapso==NULL && $sede==NULL&&$subsede==NULL && $cohorte==NULL){
            $oferta = NULL;
        }else{            
            $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        }
        
        return $this->render('AppBundle:Oferta:new.html.twig', array(
            'form'=>$form->createView(),
            'dias'=>$dias,
            'bloquesh'=>$bloque_h,
            'oferta'=>$oferta
        ));
    }
    
    /**
     * @Route("/app/admin/ofertacad/create", name="app_create_oferta_academica", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getEntityManager();

        $idusuario = $this->get('security.token_storage')->getToken()->getUser()->getId();
        $nrocedula = $em2->getRepository('UsersBundle:Users')->findOneBy(array('id'=>$idusuario))->getCedula();
        $idusuario = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$nrocedula))->getId();

        $entity = new OfertAcade();
        $form = $this->formNewOfertAcade($entity, $em, $idusuario);
        
        $form->handleRequest($request);
        
        if($form->isValid())
        {            
            $codHorario = $form->get('descripc_horario')->getData();
            $entity->setDescripcHorario($codHorario);
            $prof = $form->get('profesor2')->getData();
            if($prof!==null){
                list($cedula, $nombre) = explode('-',$prof);
                $profesor = $em->getRepository('AppBundle:Profesor')->findOneBy(array('cedula'=>$cedula));
            }else{
                $profesor = NULL;
            }
            $entity->setProfesor($profesor);
            $ids = $this->getUser()->getSede()->getCodigo();

            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
            $entity->setSede($sede);
            $em->persist($entity);
            $em->flush();
            
            $programa = $entity->getPrograma()->getId();
            $especialidad = $entity->getEspecialidad()->getId();
            $lapso = $entity->getLapso()->getId();
            $sede = $entity->getSede()->getId();
            $subsede = ($entity->getSubsede()!= NULL) ? $entity->getSubsede()->getId(): NULL;
            $cohorte = ($entity->getCohorte()!= NULL) ? $entity->getCohorte()->getId(): NULL;
            
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro insertado con exito.!');
            return $this->redirect($this->generateUrl('app_new_oferta_academica', array(
                'programa'=>$programa,
                'especialidad'=>$especialidad,
                'lapso'=>$lapso,
                'sede'=>$sede,
                'subsede'=>$subsede,
                'cohorte'=>$cohorte,
            )));
        }
        
        
        $dias = $em->getRepository('AppBundle:Dias')->findAll();
        $bloque_h = $em->getRepository('AppBundle:BloqueHoras')->findAll();
        return $this->render('AppBundle:Oferta:new.html.twig', array(
            'form'=>$form->createView(),
            'dias'=>$dias,
            'bloquesh'=>$bloque_h,
        ));
    }
    
    private function formNewOfertAcade(OfertAcade $entity, \Doctrine\ORM\EntityManager $em, $idusuario)
    {   

        $form = $this->createForm(new OfertAcadeType($em), $entity, array(
            'method'=>'POST',
            'action'=>$this->generateUrl('app_create_oferta_academica')
        ))
        ->add('subsede', 'entity', array(
            'class'=>'AppBundle:Subsede',
            'em'=>$em,                    
            'empty_value'=>'Estructura Acádemica .:seleccione:.',
            'query_builder'=>function(EntityRepository $er) use ($idusuario){
                $q = $er->createQueryBuilder('s')
                        ->leftJoin('s.subsedeusuario', 'su');
                        $q->where('su.usuario = '.$idusuario);
                        //->orderBy('c.codigo', 'DESC');                                
                return $q;
            },
            'attr'=>array('class'=>'form-control', 'style'=>'width:100%;'),
        ))
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/ofertacad/edit/{id}", name="app_edit_oferta_academica")
     */
    public function editOfertaAcadeAction($id, Request $request){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getEntityManager();
        
                $idusuario = $this->get('security.token_storage')->getToken()->getUser()->getId();
                $nrocedula = $em2->getRepository('UsersBundle:Users')->findOneBy(array('id'=>$idusuario))->getCedula();
                $idusuario = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$nrocedula))->getId();

        $entity = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $oferta = $entity->getId();

        $entity2 = $em->getRepository('AppBundle:OfertAcade')->findByOfertaMat($oferta);
        $url =  $request->headers->get('referer');

        foreach ($entity2 as $n){

            if($entity->getCantidadAlumnos()>0 && $n->getCondicion()->getId()==3 || $n->getCondicion()->getId()==4){
                
                $this->get('session')->getFlashBag()->add('msg-error', 'No se puede editar debido a que posee alumnos inscritos con notas');
            return $this->redirect($this->generateUrl('app_consult_oferta_academica'));
            }
        }   

        $url =  $request->headers->get('referer');
                
        $findme   = '/new/';
        $pos = strpos($url, $findme);        
        $form = $this->formEditOfertAcade($entity, $em, $idusuario , ($pos === false) ? 'consult':'new');
        $dias = $em->getRepository('AppBundle:Dias')->findAll();
        $bloque_h = $em->getRepository('AppBundle:BloqueHoras')->findAll();
        return $this->render('AppBundle:Oferta:edit.html.twig', array(
            'form'=>$form->createView(),
            'dias'=>$dias,
            'bloquesh'=>$bloque_h,
        ));
    }
    
    /**
     * @Route("/app/admin/ofertacad/update/{id}", name="app_update_oferta_academica", requirements={"_method":"PUT"})
     */
    public function updateOfertaAcadeAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getEntityManager();
        
                $idusuario = $this->get('security.token_storage')->getToken()->getUser()->getId();
                $nrocedula = $em2->getRepository('UsersBundle:Users')->findOneBy(array('id'=>$idusuario))->getCedula();
                $idusuario = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$nrocedula))->getId();

        $entity = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $form = $this->formEditOfertAcade($entity, $em, $idusuario);
        
        $form->handleRequest($request);
        
        if($form->isValid())
        {            
            $codHorario = $form->get('descripc_horario')->getData();
            $entity->setDescripcHorario($codHorario);
            $prof = $form->get('profesor2')->getData();
            list($cedula, $nombre) = explode('-',$prof);
            $profesor = $em->getRepository('AppBundle:Profesor')->findOneBy(array('cedula'=>$cedula));
            $entity->setProfesor($profesor);
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
            $entity->setSede($sede);
            $em->persist($entity);
            $em->flush();
            
            $programa = $entity->getPrograma()->getId();
            $especialidad = $entity->getEspecialidad()->getId();
            $lapso = $entity->getLapso()->getId();
            $sede = $entity->getSede()->getId();
            $subsede = ($entity->getSubsede()!= NULL) ? $entity->getSubsede()->getId(): NULL;
            $cohorte = ($entity->getCohorte()!= NULL) ? $entity->getCohorte()->getId(): NULL;
            
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');            
            
            if($form->get('preacct')->getData()=='new'){
                return $this->redirect($this->generateUrl('app_new_oferta_academica', array(
                'programa'=>$programa,
                'especialidad'=>$especialidad,
                'lapso'=>$lapso,
                'sede'=>$sede,
                'subsede'=>$subsede,
                'cohorte'=>$cohorte,
                )));
            }
        }
        
        
        $dias = $em->getRepository('AppBundle:Dias')->findAll();
        $bloque_h = $em->getRepository('AppBundle:BloqueHoras')->findAll();
        return $this->render('AppBundle:Oferta:edit.html.twig', array(
            'form'=>$form->createView(),
            'dias'=>$dias,
            'bloquesh'=>$bloque_h,
        ));
    }
    
    /**
     * @Route("/app/admin/ofertacad/delete/{id}", name="app_delete_oferta_academica")
     */
    public function deleteOfertAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:OfertAcade')->find($id);
        if($entity->getCantidadAlumnos()>0){
            $this->get('session')->getFlashBag()->add('msg-error', 'Registro no se puede eliminar debido a que posee alumnos inscritos');
            return $this->redirect($request->headers->get('referer'));
        }
        
        $url = $request->headers->get('referer');
        $findme   = '/new/';
        $pos = strpos($url, $findme); 
            $em->remove($entity);
            $em->flush(); 
        $this->get('session')->getFlashBag()->add('msg-success', 'Registro eliminado de forma exitosa!');
        if($pos===false){
            $programa = $entity->getPrograma()->getId();
            $especialidad = $entity->getEspecialidad()->getId();
            $lapso = $entity->getLapso()->getId();
            $sede = $entity->getSede()->getId();
            $subsede = ($entity->getSubsede()!= NULL) ? $entity->getSubsede()->getId(): NULL;
            $cohorte = ($entity->getCohorte()!= NULL) ? $entity->getCohorte()->getId(): NULL;            
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');    
            return $this->redirect($this->generateUrl('app_consult_oferta_academica', array(
                'programa'=>$programa,
                'especialidad'=>$especialidad,
                'lapso'=>$lapso,
                'sede'=>$sede,
                'subsede'=>$subsede,
                'cohorte'=>$cohorte,
            )));
        }else{
            return $this->redirect($request->headers->get('referer'));
        }
    }
    
    private function formEditOfertAcade(OfertAcade $entity, \Doctrine\ORM\EntityManager $em, $idusuario, $preacct = 'consult')
    {        
        $form = $this->createForm(new OfertAcadeType($em), $entity, array(
            'method'=>'PUT',
            'action'=>$this->generateUrl('app_update_oferta_academica', array('id'=>$entity->getId()))
        ))
                ->remove('profesor2')
                ->add('profesor2', 'text', array(
                    'mapped'=>false,
                    'data'=>($entity->getProfesor()) ? $entity->getProfesor()->getCedula().'-'.$entity->getProfesor():null,
                ))
                ->add('preacct', 'hidden', array(
                    'mapped'=>false,
                    'data'=>$preacct,
                )) 
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:Subsede',
                    'em'=>$em,                    
                    'empty_value'=>'Estructura Acádemica .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($idusuario){
                        $q = $er->createQueryBuilder('s')
                                ->leftJoin('s.subsedeusuario', 'su');
                                $q->where('su.usuario = '.$idusuario);
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:100%;'),
                ))
                ->add('submit', 'submit', array('label'=>'Modificar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    /**
     * @Route("/app/admin/consult_cursos", name="select_cursos")
     */
    public function selectCursos(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $ids = $this->getUser()->getSede()->getCodigo();
        
        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);        
        $programa = $request->get('programa_id');
        $especialidad = $request->get('especialidad_id');
        $cursos = $em->getRepository('AppBundle:PlanEstudio')->consultMateriasOferta($programa, $especialidad, $sede);
        
        foreach($cursos as $value)
            {
                $dato['id'] = $value->getCurso()->getId();
                $dato['text'] = $value->getCurso()->getCodigo().'-'.$value->getCurso()->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
        
    }
    
    /**
     * @Route("/app/admin/consult_profesores", name="opt_all_profesores")
     */
    public function selectProfesores(Request $request)
    {
       $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
       $ids = $this->getUser()->getSede()->getId();
       $sede = $em->getRepository('AppBundle:Sede')->find($ids);      
       $entities = $em->getRepository('AppBundle:Profesor')->findSearchTermino($request->get('q')); 
        if(count($entities) > 0){
            foreach ($entities as $value)
            {            
                $response[] = $value->getCedula().'-'.$value->getPrimerNombre().' '.$value->getPrimerApellido();
                //$dato['profesor'] = $value->getCedula().'-'.$value->getPrimerNombre().' '.$value->getPrimerApellido();
                //$response[] = $dato;
            }
        }else{
            $dato['profesor'] = NULL;            
            $response[] = $dato;
        }
        
//        if(count($entities) > 0){
//            foreach ($entities as $value)
//            {            
//                $dato['codigo'] = $value->getCedula().'-'.$value->getPrimerNombre().' '.$value->getPrimerApellido();
//                $dato['nombre'] = $value->getPrimerNombre().' '.$value->getPrimerApellido();
//                
//                $response[] = $dato;
//            }
//        }else{
//            $dato['codigo'] = NULL;            
//            $dato['nombre'] = NULL;            
//            $response[] = $dato;
//        }
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }
    
    
    
    /**
     * @Route("/app/admin/opt/all/unidadcurricular/buscar", name="app_opt_buscar_cursos")
     */    
    public function optAllChildren(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:Cursos')->findSearchTermino($request->get('q'));
        if(count($entities) > 0){
            foreach ($entities as $value)
            {   
                
                $response[] = $value->getCodigo().'-'.$value->getNombre();
                             
            }
        }else{
            $dato['codigo'] = NULL;            
            $dato['nombre'] = NULL;            
            $response[] = $dato;
        }
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }
    
    
    
    
    
      
    
    
    
    /**
     * @Route("/select/show/horario", name="app_select_show_horario")
     */
    public function showSelectHorarioAction()
    {
        return $this->render('AppBundle:Oferta:include/index.html.twig', array(            
        ));
    }
    
    /**
     * @Route("/app/admin/asignacion/ofertacad/consult/{programa}/{especialidad}/{lapso}/{sede}/{subsede}/{cohorte}", name="app_asignacion_oferta_academica")
     */
    public function asignacionAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL, $cohorte = NULL)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsultOferta($em, $programa);
        
        if($programa==NULL && $especialidad==NULL && $lapso==NULL && $sede==NULL&&$subsede==NULL && $cohorte==NULL){
            $oferta = NULL;
        }else{            
            $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        }
        return $this->render('AppBundle:Oferta:indexasignacion.html.twig', array(
            'form'=>$form->createView(),
            'oferta'=>$oferta,
            'programa'=>$programa,
            'especialidad'=>$especialidad,
            'lapso'=>$lapso,
            'subsede'=>$subsede,
            'cohorte'=>$cohorte,
        ));        
        
    }
    
    /**
     * @Route("/app/admin/asignacion/ofertacad/update/", name="app_asignacion_oferta_academica_update")
     */
    public function asignacionUpdateAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $oferta = $em->getRepository('AppBundle:OfertAcade')->find($request->get('oferta'));
        if(!$oferta)
            throw new Exception;
        
        $arrDatosP = explode('-', $request->get('profesor'));
        
        $profesor = $em->getRepository('AppBundle:Profesor')->findOneBy(array('cedula'=>$arrDatosP[0]));
        if(!$profesor){
            $status = '505';
            $msg = array('msg'=>'Profesor no encontrado');
            $respuesta = new Response(json_encode($msg), $status);
            $respuesta->headers->set('Content-Type', 'application/json');
            return $respuesta;
        }
        
        $oferta->setProfesor($profesor);
        $em->persist($oferta);
        $em->flush();
        
        $status = '201';
        $msg = array('profesor'=>$profesor->getCedula().'-'.$profesor->getPrimerNombre().' '.$profesor->getSegundoApellido());
        $respuesta = new Response(json_encode($msg), $status);
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }

    /**
     * @Route("/app/admin/ofertacad/show/inscritos", name="app_show_inscritos")
     */
    public function showOfertaInscritosAction(Request $request)
    {
        $programa = $request->get('programa_id');
        $especialidad = $request->get('especialidad_id');
        $lapso = $request->get('lapso_id');
        $cohorte = $request->get('cohorte_id');
        $subsede = $request->get('subsede_id');
        $actions = $request->get('actions');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
        
        $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        
        return $this->render('AppBundle:Reportes:inscritos_por_UC/show.html.twig', array(
            'oferta'=>$oferta,'listado'=>$actions
        ));
    }
    
}
