<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use AppBundle\Utils\phpjru\PJRU;
use AppBundle\Utils\phpjru\JdbcConnection;
use AppBundle\Utils\ReporteLayout;

use Doctrine\ORM\EntityRepository;

use AppBundle\Entity\OfertAcade;
use AppBundle\Form\OfertAcadeType;

/**
 * Description of ReportesController
 *
 * @author jose
 */
class ReportesController extends Controller {
    //put your code here
    
    /**
     * @Route("/app/admin/reports/listado/clases/{programa}/{especialidad}/{lapso}/{sede}/{subsede}/{cohorte}", name="app_admin_listado_clases")
     */
    public function listadoClasesAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL, $cohorte = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsultOferta($em, $programa);
        
        if($programa==NULL && $especialidad==NULL && $lapso==NULL && $sede==NULL&&$subsede==NULL && $cohorte==NULL){
            $oferta = NULL;
        }else{            
            $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        }
        
        return $this->render('AppBundle:Reportes:listado_clases/index.html.twig', array(
            'form'=>$form->createView(),
            'oferta'=>$oferta,
            'programa'=>$programa,
            'especialidad'=>$especialidad,
            'lapso'=>$lapso,
            'subsede'=>$subsede,
            'cohorte'=>$cohorte,
        ));
    }
    
    private function formConsultOferta(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:50%;'),                    
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extension .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/reportes/listado/clases/{id}", name="app_admin_reporte_listado_clases")
     */
     
    public function reportListadoClasesAction($id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesByOferta($oferta);
        $subsedeausar = $oferta->getSubSede()->getId();

        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('subsede'=>$subsedeausar,'cargo'=>$cargo, 'activo'=>$activo));
        
        $cualitativo = false;
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(10,20,60,60,10,30));
        $pdf->SetAligns(array('C','C','L', 'L', 'C', 'C'));
        //srand(microtime()*1000000);
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->titleReport('Acta de Calificaciones');

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getPrograma()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(26,10,utf8_decode('Sede/Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getSubSede()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$oferta->getEspecialidad()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(11,10,utf8_decode('Curso: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(128,10,utf8_decode(''.$oferta->getCurso()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Sección: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(20,10,utf8_decode(''.$oferta->getSeccion()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(13,10,utf8_decode('Horario: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(126,10,utf8_decode(''.$oferta->getHorario()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Cohorte: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getCohorte()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(16,10,utf8_decode('Ambiente: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(123,10,utf8_decode(''.$oferta->getAmbiente()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getLapso()),0,'L');
            $pdf->Ln(10);
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('N°','Cédula', 'Nombre', 'Apellidos', 'Nota','Condicion');
        $pdf->RowTitles($titles); 
        
        $index = 1;
        $sincargar = 0;
        $aplaz = 0;
        $aprob = 0;
        $proc = 0;
        $nota = '';
       
        foreach ($entities as $value){

            $calificacion = ($cualitativo) ? '':$value->getNota();

            if($value->getCondicion()=='INSCRITO'){
                $sincargar++;
            }

            if($value->getCondicion()!='INSCRITO'){
                $nota = $calificacion;

                $pdf->RowBorders(array($index,
                    $value->getEstudiante()->getEstudiante()->getCedula(),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getEstudiante()->getSegundoNombre()),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getEstudiante()->getSegundoApellido()),
                        $nota,
                    $value->getCondicion(),
                ), 1);
                if($value->getCondicion()->getCodigo()=='APLZ'){
                    $aplaz++;
                }elseif($value->getCondicion()->getCodigo()=='APR'){
                    $aprob++;
                }elseif($value->getCondicion()->getCodigo()=='PROC'){
                    $proc++;
                }
                
                $index++;
                }

        }

        if(count($entities) == 0){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO HAY ESTUDIANTES INSCRITOS');
            return $this->redirect($this->generateUrl('app_admin_listado_clases'));
        }

        if(count($entities) == $sincargar){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO HA CARGADO NOTAS');
            return $this->redirect($this->generateUrl('app_admin_listado_clases'));
        } 

        $pdf->Ln(5);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(($cualitativo)? 47.5: 40, 6,'Total estudiantes: '.count($entities), '',0,'L');
        $pdf->Cell(($cualitativo)? 47.5: 80, 6,'Sin cargar nota: '.$sincargar, '',0,'L');
        $pdf->Cell(($cualitativo)? 47.5: 35, 6,'Total Aprobados: '.$aprob, '',0,'R');
        $pdf->Cell(($cualitativo)? 47.5: 35, 6,'Total Aplazado: '.($aplaz), '',0,'R');
        if($cualitativo)
            $pdf->Cell(47.5, 6,'Total En Proceso: '.($proc), '',1,'C');

        $pdf->SetFont('helvetica','B',9);
    $pdf->Ln(30);
        $pdf->Cell(63,10,  utf8_decode($oferta->getProfesor()),'T',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
    $pdf->Ln(5);
    $pdf->Cell(63,10,utf8_decode('C.I.: '.number_format($oferta->getProfesor()->getCedula(), 0, '', '.')),'',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
        $pdf->Cell(64, 10,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
    $pdf->Ln(5);
        $pdf->Cell(63,10,  utf8_decode(' Profesor(a)'),'',0,'C');
    $pdf->Ln(5);
    $pdf->Cell(63,10,'',0,0,'C');
    $pdf->Cell(64, 10,  utf8_decode('Sello'),'',0,'C');
    $pdf->Ln(5);
        
       // $pdf->Output('','Listado de clases.pdf', 1);
        
        //return $this->dispositionReporte($pdf->Output());
        // se reemplaza por esto 
        return $this->dispositionReporte($pdf->Output('', 'listado de clases.pdf', 'I'));
    }
    /**
     * @Route("/app/admin/reportes/test", name="app_admin_reporte_test")
     */
    public function reporteTestAction(){
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(30,80,80));
        srand(microtime()*1000000);
        
        $headerPage = array('Programa'=>'Maestria', 'Especialidad'=>'Maestría en Educación Mención EDUCACION INICIAL',
            'Curso'=>'INIO01 - PROBLEMATICA DE LA EDUC. INICIAL EN VZLA.', 'Sección'=>'EI1141', 'Período Académico'=>'2016-1');
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Listado de clases');
        
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Nombre', 'Apellidos' );
        $pdf->RowTitles($titles);
        
        
        for($i=0;$i<20;$i++){
            $pdf->RowBorders(array($this->GenerateSentence(),$this->GenerateSentence(),
                $this->GenerateSentence(), $this->GenerateSentence(),$this->GenerateSentence()), 0);
        }
        
        $pdf->Output('','test.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    
    public function dispositionReporte($filename)
    {
        return new Response($filename, 200, array(
            'Content-Type' => 'application/pdf'));       
    }
    
    
    public function GenerateWord()
    {
        //Get a random word
        $nb=rand(3,5);
        $w='';
        for($i=1;$i<=$nb;$i++)
            $w.=chr(rand(ord('a'),ord('z')));
        return $w;
    }

    public function GenerateSentence()
    {
        //Get a random sentence
        $nb=rand(1,10);
        $s='';
        for($i=1;$i<=$nb;$i++)
            $s.=$this->GenerateWord().' ';
        return substr($s,0,-1);
    }
    
    /**
     * @Route("/app/admin/reports/form/record/academico", name="app_admin_reports_form_record_academico")
     */
    public function recordAcademicoAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL, $cohorte = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsulEstudianteRecord($em);
        
        
        
        return $this->render('AppBundle:Reportes:record_academico/index.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    
    private function formConsulEstudianteRecord(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_record_academico'))
                ->setMethod('GET')
                ->setAttributes(array('target'=>'_blank'))
                ->add('cedula', 'text', array(
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');                        
                                $q->where('p.id IS NULL');
                                
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:85%;'),                    
                ))
                ->getForm();
        return $form;
    }
    
    
    /**
     * @Route("/app/admin/get/especialidades/by/estudiante", name="app_admin_get_especialidades_by_estudiante")
     */
    public function getEspecialidadesAction(Request $request){
        $cedula = $request->get('cedula');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $especialidades = $em->getRepository('AppBundle:EspeEstud')->getEspecialidadesByEstudiante($cedula);
        
        foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getEspecialidad()->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;
    }
    
    /**
     * @Route("/app/admin/reportes/record/academico", name="app_admin_reporte_record_academico")
     */
    public function reportRecordAcademicoAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $id =  $form['especialidad'];
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $entities = $em->getRepository('AppBundle:EspeEstud')->findHistMatri($espe_estud);
		$subsedeausar = $espe_estud->getSubsede()->getId();
        $cargo = '12';
        $activo = '1';
        
        $Nombre = $espe_estud->getEstudiante(); 
        $Cédula = $espe_estud->getEstudiante()->getCedula();
        $Especialidad = $espe_estud->getEspecialidad()->getNombre();
        $Sede = $espe_estud->getSede()->getNombre();
		$uca = '0';
		$cil = '0';
		$e = '0';
        $var = '0';
        $ult_lapso = '';

        foreach ($entities as $value){
                 
            if ($value->getId() > $var){
            $var = $value->getId();
            $ult_lapso = $value->getLapso();
            }
        }

        if($autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('subsede'=>$subsedeausar,'cargo'=>$cargo, 'activo'=>$activo)) == null){
            $this->get('session')->getFlashBag()->add('msg-error', 'Jefe(a) de la Sección de Control de Estudios no asignado');
            return $this->redirect($request->headers->get('referer'));
        }

        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('subsede'=>$subsedeausar,'cargo'=>$cargo, 'activo'=>$activo));
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();

        $pdf->SetWidths(array(15,25,85,12,25,28));

	    $pdf->SetY(35);
	    $pdf->titleReport('Récord Académico');
        
        //srand(microtime()*1000000);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(10,10,utf8_decode('Sede: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(105,10,utf8_decode(''.$Sede),0,'L');
            $pdf->Ln(4);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(13,10,utf8_decode('Cédula: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(57,10,utf8_decode(''.$Cédula),0,'L');
            $pdf->Ln(4);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(30,10,utf8_decode('Nombre y Apellido: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(40,10,strtoupper(utf8_decode(''.$Nombre)),0,'L');
            $pdf->Ln(4);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$Especialidad),0,'L');
            $pdf->Ln(10);

        /*$headerPage = array('Nombre y Apellido'=>$espe_estud->getEstudiante(), 
                        'Cédula'=>$espe_estud->getEstudiante()->getCedula(),
                        'Especialidad'=>$espe_estud->getEspecialidad()->getNombre(),
  			'Sede'=>$espe_estud->getSede()->getNombre(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');*/

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(50,10,utf8_decode('Componente: Formación Docente'),0,'C');
        $pdf->Ln(8);

        $pdf->aligns = array('C','C', 'L', 'C', 'C', 'C');
        $pdf->SetFont('helvetica','',8);
        $titles = array('Lapso', 'Código', 'Unidad Curricular', 'C.A.', 'Calificación', 'Condición');
        $pdf->RowTitles($titles);

        $puntos = 0;
        $indiceac = 0;
        $puntoss = 0;
        $indicelap = 0;
        $i = 0;
		$eca = 0;

        $pdf->SetFont('helvetica','',7);
        
        foreach ($entities as $value){
                 
            if($value->getCurso()->getComponentes()->getCodigo() == 'CFD') {
                 $nota = $value->getNota();
                 $uc = $value->getCurso()->getUc();
                 $ucxnota = $nota * $uc;
                 $puntos += $ucxnota;
                 $indiceac += $uc;
                 $i += $uc;

        if ($value->getLapso() == $ult_lapso){
            $nota = $value->getNota();
            $uc = $value->getCurso()->getUc();
            $ucxnota = $nota * $uc;
            $puntoss += $ucxnota;
            $indicelap += $uc;
        }

		 if ($value->getCondicion()->getNombre() == 'APROBADO'){
			$uca += '1';
		 }

                 $pdf->RowBorders(array($value->getLapso()->getCodigo(),
                                   $value->getCurso()->getCodigo(),
                                   strtoupper($value->getCurso()->getNombre()),
                                   $uc,
                                   $nota,
                                   //$ucxnota,
                                   (($value->getCondicion()->getNombre() == 'APLAZADO') ? ' ' : '').$value->getCondicion()->getNombre(),
                            ), 0);
             }else {}            
        }

        $pdf->SetFont('helvetica','',8);
        $pdf->Cell(190,10,'Total de Creditos en el Componente: '.$i,'',0,'C');
        $pdf->Ln(5);

        $i = 0;

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(50,10,utf8_decode('Componente: Formación Profesional Especifico'),0,'C');
        $pdf->Ln(8);

        $pdf->aligns = array('C','C', 'L', 'C', 'C', 'C');
        $pdf->SetFont('helvetica','',8);
        $titles = array('Lapso', 'Código', 'Unidad Curricular', 'C.A.', 'Calificación', 'Condición');
        $pdf->RowTitles($titles);

        $pdf->SetFont('helvetica','',7);
        
        foreach ($entities as $value){
                 
            if($value->getCurso()->getComponentes()->getCodigo() == 'CFPE') {
                 $nota = $value->getNota();
                 $uc = $value->getCurso()->getUc();
                 $ucxnota = $nota * $uc;
                 $puntos += $ucxnota;
                 $indiceac += $uc;
                 $i += $uc;
        
        if ($value->getLapso() == $ult_lapso){
            $nota = $value->getNota();
            $uc = $value->getCurso()->getUc();
            $ucxnota = $nota * $uc;
            $puntoss += $ucxnota;
            $indicelap += $uc;
        }

		 if ($value->getCondicion()->getNombre() == 'APROBADO'){
			$uca += '1';
		 }

                 $pdf->RowBorders(array($value->getLapso()->getCodigo(),
                                   $value->getCurso()->getCodigo(),
                                   strtoupper($value->getCurso()->getNombre()),
                                   $uc,
                                   $nota,
                                   //$ucxnota,
                                   (($value->getCondicion()->getNombre() == 'APLAZADO') ? ' ' : '').$value->getCondicion()->getNombre(),
                            ), 0);
             }else {}            
        }

        $pdf->SetFont('helvetica','',8);
        $pdf->Cell(190,10,'Total de Creditos en el Componente: '.$i,'',0,'C');
        $pdf->Ln(5);

        $i = 0;

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(50,10,utf8_decode('Componente: Formación Contextualizado'),0,'C');
        $pdf->Ln(8);

        $pdf->aligns = array('C','C', 'L', 'C', 'C', 'C');
        $pdf->SetFont('helvetica','',8);
        $titles = array('Lapso', 'Código', 'Unidad Curricular', 'C.A.', 'Calificación', 'Condición');
        $pdf->RowTitles($titles);

        $pdf->SetFont('helvetica','',7);
        
        foreach ($entities as $value){
                 
            if($value->getCurso()->getComponentes()->getCodigo() == 'CFC') {
                 $nota = $value->getNota();
                 $uc = $value->getCurso()->getUc();
                 $ucxnota = $nota * $uc;
                 $puntos += $ucxnota;
                 $indiceac += $uc;
                 $i += $uc;
        
        if ($value->getLapso() == $ult_lapso){
            $nota = $value->getNota();
            $uc = $value->getCurso()->getUc();
            $ucxnota = $nota * $uc;
            $puntoss += $ucxnota;
            $indicelap += $uc;
        }

		 if ($value->getCondicion()->getNombre() == 'APROBADO'){
			$uca += '1';
		 }

                 $pdf->RowBorders(array($value->getLapso()->getCodigo(),
                                   $value->getCurso()->getCodigo(),
                                   strtoupper($value->getCurso()->getNombre()),
                                   $uc,
                                   $nota,
                                   //$ucxnota,
                                   (($value->getCondicion()->getNombre() == 'APLAZADO') ? ' ' : '').$value->getCondicion()->getNombre(),
                            ), 0);
             }else {}            
        }

        $pdf->SetFont('helvetica','',8);
        $pdf->Cell(190,10,'Total de Creditos en el Componente: '.$i,'',0,'C');
        $pdf->Ln(5);

        $i = 0;

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(50,10,utf8_decode('Componente: Sin Componente de Formación'),0,'C');
        $pdf->Ln(10);

        $pdf->aligns = array('C','C', 'L', 'C', 'C', 'C');
        $pdf->SetFont('helvetica','',8);
        $titles = array('Lapso', 'Código', 'Eje Curricular', 'C.A.', 'Calificación', 'Condición');
        $pdf->RowTitles($titles);
        //$pdf->Ln(1);

        $pdf->SetFont('helvetica','',7);
        
        foreach ($entities as $value){
                 
            if($value->getCurso()->getComponentes()->getCodigo() == 'SCF') {
                 $nota = $value->getNota();
                 $uc = $value->getCurso()->getUc();
                 $ucxnota = $nota * $uc;
                 $puntos += $ucxnota;
                 $indiceac += $uc;
                 $i += $uc;
        
        if ($value->getLapso() == $ult_lapso){
            $nota = $value->getNota();
            $uc = $value->getCurso()->getUc();
            $ucxnota = $nota * $uc;
            $puntoss += $ucxnota;
            $indicelap += $uc;
        }

		 if ($value->getCondicion()->getNombre() == 'APROBADO'){
			$eca += '1';
		 }

                 $pdf->RowBorders(array($value->getLapso()->getCodigo(),
                                   $value->getCurso()->getCodigo(),
                                   strtoupper($value->getCurso()->getNombre()),
                                   $uc,
                                   $nota,
                                   //$ucxnota,
                                   (($value->getCondicion()->getNombre() == 'APLAZADO') ? ' ' : '').$value->getCondicion()->getNombre(),
                            ), 0);
             }else {}            
        }

        $pdf->SetFont('helvetica','',8);
        $pdf->Cell(190,10,'Total de Creditos en el Componente: '.$i,'',0,'C');
        $pdf->Ln(10);

        /*$pdf->SetFont('helvetica','B',9);
        $pdf->Cell(63,10,'Puntos: '.  number_format($puntos, 2, ',','.'),'T',0,'C');
        $pdf->Cell(64,10,'UC indice: '.$indiceac,'T',0,'C');
        $pdf->Cell(63,10,'IND*ACAD: '.number_format($puntos/$indiceac,2,',','.'),'T',1,'C');
        $pdf->Ln(5);*/

    if($puntos == 0 && $indiceac == 0){
            $this->get('session')->getFlashBag()->add('msg-error', 'No posee Récord Académico');
            return $this->redirect($request->headers->get('referer'));
        }

    $iaa = $puntos/$indiceac;
    $ial = $puntoss/$indicelap;
    $ind_egre = ($iaa+$ial)/2;

	
	$pdf->SetFont('helvetica','',9);
	$pdf->Cell(190,10,'','T',0,'C');
	$pdf->Ln(5);

    $pdf->Cell(95,10,utf8_decode('Créditos Logrados Por:'),'',0,'L');
	$pdf->Cell(95,10,'Unidades Curriculares Cursadas Aprobadas: '.$uca,'',0,'R');
	$pdf->Ln(5);

	$pdf->Cell(95,10,utf8_decode('Acreditación por Competencia: '). number_format($e, 2, ',','.'),'',0,'L');
	$pdf->Cell(95,10,'Ejes Curriculares Cursadas Aprobadas: '.$eca,'',0,'R');
	$pdf->Ln(5);

	$pdf->Cell(95,10,'Por Traslado: '. number_format($e, 2, ',','.'),'',0,'L');
    $pdf->Cell(95,10,utf8_decode('Total de Créditos Académico: ').$indiceac,'',0,'R');
	$pdf->Ln(5);
	
	$pdf->Cell(95,10,'Por Reconocimiento de Estudios: '. number_format($e, 2, ',','.'),'',0,'L');
	$pdf->Ln(5);

	$pdf->Cell(95,10,utf8_decode('Indice Académico de Acumulado: '). number_format($iaa,2,',','.'),'',0,'L');
	$pdf->Cell(95,10,'Indice de Egreso: '. number_format($ind_egre, 2, ',','.'),'',0,'R');
	$pdf->Ln(5);

        $pdf->Cell(95,10,utf8_decode('Indice Académico de Lapso: '). number_format($ial, 2, ',','.'),'',0,'L');
	$pdf->Cell(95,10,utf8_decode('Créditos Inscritos en Lapso: ').$e,'',0,'R');
	$pdf->Ln(15);
        

        /*$pdf->SetFont('helvetica','',7);
        $text1 = "UC= Unid. de Credito, IA= Indice Acad.(PTOS/UC), PTOS= Puntos(Suma de UC x C), C=Calificacion, CM= Cond. de Asig.; 3= Equiivalencia, 4= DOC. NoTrans.calf.,
6= Nota en Observa.,7= Prueba Extraor., 8= Sin Nota., 9= Inasistente.CM= 3,4,6,8 y 9 no afectan el Indice";
        $pdf->MultiCell(190, 3, $text1,0,'J');
        $text2 = "INDICE ACADEMICO CALCULADO SEGUN RESOLUCION No.2008.316.2818 EXAMINADA DEL CONSEJO UNIVERSITARIO FECHA: 23 JULIO DE 2008";
        $pdf->MultiCell(190, 3, $text2,0,'J');*/
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(15);
        $pdf->Cell(63,10,'',0,0,'C');
        $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        $pdf->Ln(1);
        $pdf->Cell(0,0,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
        $pdf->Ln(8);

        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    
    /**
     * @Route("/app/admin/reports/form/planilla/inscripcion", name="app_admin_form_planilla_inscripcion")
     */
    public function planillaInscripcionAction(){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsulEstudiantePlanillaInscripcion($em);
        
        
        return $this->render('AppBundle:Reportes:planilla_inscripcion/index.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    private function formConsulEstudiantePlanillaInscripcion(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_planilla_inscripcion'))
                ->setMethod('GET')
                ->setAttributes(array('target'=>'_blank'))
                ->add('cedula', 'text', array(
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('l');
                        $q->orderBy('l.codigo', 'DESC');
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),                    
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');                        
                                $q->where('p.id IS NULL');
                                
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:75%;'),                    
                ))
                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/reportes/planilla/inscripcion", name="app_admin_reporte_planilla_inscripcion")
     */
    public function reportPlanillaInscripcionAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $id =  $form['especialidad'];
        $lapsoid = $form['lapso'];
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudianteReport($espe_estud, $lapso);
        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-success', 'No se encuentra inscrito para ese periodo!');
            return $this->redirect($this->generateUrl('app_admin_form_planilla_inscripcion'));
        }
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();  
        $pdf->setSede($espe_estud->getSede());       
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(20,77,8,15,70));

        $pdf->SetY(35);
        $pdf->titleReport('Planilla de Inscripción - '.$lapso->getCodigo());

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(10,10,utf8_decode('Sede: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(105,10,utf8_decode(''.$espe_estud->getSede()->getNombre()),0,'L');
            $pdf->Ln(4);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(13,10,utf8_decode('Cédula: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(57,10,utf8_decode(''.$espe_estud->getEstudiante()->getCedula()),0,'L');
            $pdf->Ln(4);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(30,10,utf8_decode('Nombre y Apellido: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(37,10,utf8_decode(''.$espe_estud->getEstudiante()),0,'L');
            $pdf->Ln(4);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$espe_estud->getEspecialidad()->getNombre()),0,'L');
            $pdf->Ln(10);
        
        $pdf->aligns = array('C', 'L', 'C', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Código', 'Unidad Curricular', 'C.A', 'Sección', 'Horario');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){
            $ucs+=$value->getOferta()->getCurso()->getUc();
            $pdf->RowBorders(array($value->getOferta()->getCurso()->getCodigo(),
                                   $value->getOferta()->getCurso()->getNombre(),
                                   $value->getOferta()->getCurso()->getUc(),
                                   $value->getOferta()->getSeccion(),
                                   $value->getOferta()->getHorario() 
                            ), 0);
        }
       
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(100, 6,utf8_decode('Total Créditos Académicos: '),'T',0,'R');
        $pdf->Cell(10, 6,$ucs,'T',0,'C');
        $pdf->Cell(80, 6,'','T',1,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(5);
        $pdf->Ln(90);
        $pdf->SetFont('helvetica','',8);
 	$pdf->Cell(0,10,  utf8_decode('- Control de Estudios se reserva el derecho de modificar y eliminar la planilla de Inscripción Nacional cuando se detecten aspectos que no proceden.'),'',0,'L');
        $pdf->SetFont('helvetica','',8);
 	$pdf->Ln(3);
	$pdf->Cell(0,10,  utf8_decode('- Para ser válida la inscripción debe consignarse este documento ante Control de Estudios.'),'',0,'L');
        $pdf->SetFont('helvetica','',8);
 	$pdf->Ln(3);
	$pdf->Cell(0,10,  utf8_decode('- Se considera como válida la última planilla de inscripción que emita el sistema.'),'',0,'L');
        $pdf->Ln(10);
        $pdf->SetFont('helvetica','',7);
        $pdf->Cell(64,10,  utf8_decode('ESTUDIANTE'),'',0,'C');
        $pdf->Cell(64,10,  utf8_decode('SELLO'),'',0,'C');
        $pdf->Cell(64,10,  utf8_decode('CONTROL DE ESTUDIOS'),'',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Planilla de Inscricipcion.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    

//**************************************reporte constancia**********************************************
     

    /**
     * @Route("/app/admin/reports/form/planilla/constanciaestudio", name="app_admin_form_planilla_constanciaestudio")
     */
    public function planillaConstanciaestudioAction(){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsulEstudiantePlanillaConstanciaestudio($em);
        
        
        return $this->render('AppBundle:Reportes:constancia_estudio/index.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    private function formConsulEstudiantePlanillaConstanciaestudio(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_planilla_constanciaestudio'))
                ->setMethod('GET')
                ->setAttributes(array('target'=>'_blank'))
                ->add('cedula', 'text', array(
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('l');
                        $q->orderBy('l.codigo', 'DESC');
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),                    
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');                        
                                $q->where('p.id IS NULL');
                                
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:75%;'),                    
                ))
                ->getForm();
        return $form;
    }
    

     /**
     * @Route("/app/admin/reportes/planilla/constanciaestudio", name="app_admin_reporte_planilla_constanciaestudio")
     */
    public function reportPlanillaConstanciaAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $id =  $form['especialidad'];
        $lapsoid = $form['lapso'];
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($espe_estud, $lapso);
       
        $subsedeausar = $espe_estud->getSubsede()->getId();
        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('subsede'=>$subsedeausar,'cargo'=>$cargo, 'activo'=>$activo));
        //$sede= $em->getRepository('AppBundle:Sede')->findByCodigo($ids);
        
        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-success', 'No se encuentra inscrito para ese periodo!');
            return $this->redirect($this->generateUrl('app_admin_form_planilla_constanciaestudio'));
        }
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();  
        $pdf->setSede($espe_estud->getSede());       
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(20,75,8,15,70));
        //srand(microtime()*1000000);        
        
         
        $pdf->titleReport(''.$espe_estud->getSede());
        
        $pdf->titleReport('Constancia de Estudios ');
         $pdf->Ln(6);
	
        $ucs = 0;
       

         foreach ($entities as $value){
            $ucs+=$value->getOferta()->getCurso()->getUc();
           
                  
        }

       // $fecha2 = new \DateTime();
       // $fecha2->format('d-m-Y');
        $pdf->Ln(2);

        //fecha en español*****************************************************
        $dia=date("l"); // dia en lunes martes etc
        
        if ($dia=="Monday") $dia="Lunes";
        if ($dia=="Tuesday") $dia="Martes";
        if ($dia=="Wednesday") $dia="Miércoles";
        if ($dia=="Thursday") $dia="Jueves";
        if ($dia=="Friday") $dia="Viernes";
        if ($dia=="Saturday") $dia="Sabado";
        if ($dia=="Sunday") $dia="Domingo";
        
        $mes=date("F"); //mes en enero febrero etc
        
        if ($mes=="January") $mes="Enero";
        if ($mes=="February") $mes="Febrero";
        if ($mes=="March") $mes="Marzo";
        if ($mes=="April") $mes="Abril";
        if ($mes=="May") $mes="Mayo";
        if ($mes=="June") $mes="Junio";
        if ($mes=="July") $mes="Julio";
        if ($mes=="August") $mes="Agosto";
        if ($mes=="September") $mes="Setiembre";
        if ($mes=="October") $mes="Octubre";
        if ($mes=="November") $mes="Noviembre";
        if ($mes=="December") $mes="Diciembre";
        
        $ano=date("Y"); // año completo 2017 
        $dia2=date("d");// solo dia en numero

        $fecha = date('j-m-Y');
        $nuevafecha = strtotime ( '+3 month' , strtotime ( $fecha ) ) ;
        $nuevafecha = date ( 'j/m/Y' , $nuevafecha );
        //fecha en español*****************************************************
        
        $text3 = "      Quien suscribe, ".strtoupper($autoridad->getNombre()).' '.strtoupper($autoridad->getApellido()) .' titular de la Cédula de Identidad  N° '.$autoridad->getCedula() .' hace constar que el (la) ciudadano(a)  '.ucwords(strtolower($espe_estud->getEstudiante()->getPrimerNombre())).' '.ucwords(strtolower($espe_estud->getEstudiante()->getSegundoNombre())).' '.ucwords(strtolower($espe_estud->getEstudiante()->getPrimerApellido())). ' '.ucwords(strtolower($espe_estud->getEstudiante()->getSegundoApellido())).
             " titular de la Cédula de Identidad N° ".$espe_estud->getEstudiante()->getCedula().
             ' cursa estudios en el '. $espe_estud->getSubsede()->getDescripcion() .' en la Especialidad de '.$espe_estud->getEspecialidad()->getNombre().
                '. Está inscrito(a) en el actual período académico ordinario '.$lapso->getCodigo().
                ', hasta la fecha tiene '. $ucs  . ' Creditos Académicos'.  ', Pertenece a la matrícula de ingreso '.$espe_estud->getCohorte().'.'.
        $pdf->SetFont('helvetica','',12);
        $pdf->MultiCell(190, 5,  utf8_decode($text3),0,'J');
  
                      
        $pdf->Ln(10);       
        $text4=   '      Constancia que se expide a solicitud de la parte interesada, a los '.$dia2.' días del mes de '. $mes  .' del año '.$ano .'.'.
                   
        $pdf->SetFont('helvetica','',12);
        $pdf->MultiCell(190, 5,  utf8_decode($text4),0,'J');
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(50);
        $pdf->Cell(63,10,'',0,0,'C');
        
        $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        $pdf->Ln(1);
        $pdf->Cell(0,0,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
        $pdf->Ln(8);
        
        $pdf->Cell(0,0,  utf8_decode('Sello'),'',0,'C');

        $pdf->Ln(40);
        $pdf->Cell(0,0,  utf8_decode('Va sin enmienda'),'',0,'');
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Planilla de Inscricipcion.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }

















































    /**
     * @Route("/app/admin/reports/form/totales/inscritos", name="app_admin_reports_form_totales_inscritos")
     */
    public function totalesInscritosFormAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formTotalesInscritos($em);
        
        return $this->render('AppBundle:Reportes:totales_inscritos/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    private function formTotalesInscritos(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_totales_inscritos'))
                ->setMethod('POST')
                ->setAttributes(array('attr'=>array('target'=>'_blank')))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em
                ))
    	        ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ;
        return $form->getForm();
    }

    /**
     * @Route("/app/admin/reportes/totales/inscritos", name="app_admin_reporte_totales_inscritos")
     */
    public function reporteTotalesInscritosAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $programaid =  $form['programa'];
        $lapsoid = $form['lapso'];
        $subsedeid = $form['subsede'];
        $cohorteid = $form['cohorte'];

        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $subsede = $em->getRepository('AppBundle:SubSede')->find($subsedeid);
        $cohorte = $em->getRepository('AppBundle:Cohorte')->find($cohorteid);
        //Se coloca la variable cohorte
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesInscritos($cohorte, $lapso, $programa, $subsede);

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN ESTUDIANTES INSCRITOS!');
            return $this->redirect($this->generateUrl('app_admin_reports_form_totales_inscritos'));
        }
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();

        $pdf->SetWidths(array(160,30));

    $pdf->SetY(35);
    $pdf->titleReport('Totales de Inscritos');       

    $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(28,10,utf8_decode('Sede / Extensión: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(162,10,utf8_decode(''.$subsede->getDescripcion()),0,'L');
        $pdf->Ln(5);

    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(15,10,utf8_decode('Cohorte: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(175,10,utf8_decode(''.$cohorte->getCodigo()),0,'L');
        $pdf->Ln(5);

    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(158,10,utf8_decode(''.$lapso->getCodigo()),0,'L');
        $pdf->Ln(10);

        
    $pdf->aligns = array('L', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Especialidad', 'Cantidad');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){

            $ucs+=count($value->getEspeestud());
            $pdf->RowBorders(array(($value->getNombre()),
                                    count($value->getEspeestud())
                            ), 0);
        }
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(170, 6,'Total: ','T',0,'R');
        $pdf->Cell(20, 6,$ucs,'T',0,'C');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        
    //        
    //        $pdf->SetFont('helvetica','B',9);
    //        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
       // $pdf->Output('','totales_inscritos.pdf', 1);
        
        //return $this->dispositionReporte($pdf->Output());
        //Se reemplaza por :
        return $this->dispositionReporte($pdf->Output('', 'totales_inscritos.pdf', 'I'));
    }

    /**
     * @Route("/app/admin/reports/form/totales/inscritos_pa", name="app_admin_reports_totales_inscritos_p")
     */
    public function totalesInscritosPFormAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formTotalesInscritosP($em);
        
        return $this->render('AppBundle:Reportes:totales_inscritos/indexp.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    private function formTotalesInscritosP(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_totales_inscritosp'))
                ->setMethod('POST')
                ->setAttributes(array('attr'=>array('target'=>'_blank')))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ;
        return $form->getForm();
    }

    /**
     * @Route("/app/admin/reportes/totales/inscritos_pa", name="app_admin_reporte_totales_inscritosp")
     */
    public function reporteTotalesInscritosPAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $programaid =  $form['programa'];
        $lapsoid = $form['lapso'];
        $subsedeid = $form['subsede'];

        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $subsede = $em->getRepository('AppBundle:SubSede')->find($subsedeid);

        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesInscritosP($lapso, $programa, $subsede);

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN ESTUDIANTES INSCRITOS!');
            return $this->redirect($this->generateUrl('app_admin_reports_form_totales_inscritos'));
        }
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();

        $pdf->SetWidths(array(160,30));

    $pdf->SetY(35);
    $pdf->titleReport('Totales de Inscritos');       

    $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(28,10,utf8_decode('Sede / Extensión: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(162,10,utf8_decode(''.$subsede->getDescripcion()),0,'L');
        $pdf->Ln(5);

    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(158,10,utf8_decode(''.$lapso->getCodigo()),0,'L');
        $pdf->Ln(10);

        
    $pdf->aligns = array('L', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Especialidad', 'Cantidad');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){

            $ucs+=count($value->getEspeestud());
            $pdf->RowBorders(array(($value->getNombre()),
                                    count($value->getEspeestud())
                            ), 0);
        }
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(170, 6,'Total: ','T',0,'R');
        $pdf->Cell(20, 6,$ucs,'T',0,'C');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        
    //        
    //        $pdf->SetFont('helvetica','B',9);
    //        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
       // $pdf->Output('','totales_inscritos.pdf', 1);
        
        //return $this->dispositionReporte($pdf->Output());
        //Se reemplaza por :
        return $this->dispositionReporte($pdf->Output('', 'totales_inscritos.pdf', 'I'));
    }
    
     /**
     * @Route("/app/admin/form/listado/inscritos/{programa}", name="app_admin_listado_inscritos")
     */
    public function listadoInscritosAction($programa = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formListadoInscritos($em, $programa);
        
        return $this->render('AppBundle:Reportes:listado_inscritos/index.html.twig', array(
            'form'=>$form->createView(),
            'programa'=>$programa,
            
        ));
    }
    
    private function formListadoInscritos(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reportes_inscritos'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:35%;'),                    
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:20%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:20%;'),
                ))
                ->getForm();
        return $form;
    }

    /**
     * @Route("/app/admin/reporte/listado/inscritos/", name="app_admin_reportes_inscritos")
     */
    public function reproteListadoInscritosAction(Request $request){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $lapsoid = $form['lapso'];
        $cohorteid = $form['cohorte'];
        $programaid = $form['programa'];
        $especialidadid = $form['especialidad'];
        $subsedeid = $form['subsede'];
        
        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $cohorte = $em->getRepository('AppBundle:Cohorte')->find($cohorteid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        $subsede = $em->getRepository('AppBundle:Subsede')->find($subsedeid);
        
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesInscritosByEspecialidad($cohorte, $lapso, $programa, $especialidad, $subsede);
	// ->find() ->findBy(['lapso'=>$lapso], [], Limit) ->findAll() ->findOneBy(['lapso'=>$lapso]) ->findByLapso 
        
        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN ESTUDIANTES INSCRITOS!');
            return $this->redirect($this->generateUrl('app_admin_listado_inscritos'));
        }

        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();

        $pdf->SetWidths(array(10,23,50,50,15,40));         
        //$pdf->Cell(40,10,'Hello World!');
              
        $pdf->SetY(35);
        $pdf->titleReport('Estudiantes Inscritos');      
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$programa->getNombre()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(28,10,utf8_decode('Sede / Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(111,10,utf8_decode(''.$subsede->getDescripcion()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(14,10,utf8_decode('Cohorte: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(98,10,utf8_decode(''.$cohorte->getCodigo()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$especialidad->getNombre()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$lapso->getCodigo()),0,'L');
            $pdf->Ln(10);

        $pdf->aligns = array('C','C', 'L', 'L', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('N°','Cédula', 'Apellidos','Nombres', 'Sexo', 'Fecha nac.');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        $i = 1;
        $FechaNac = '';

        foreach ($entities as $value){
            $ucs = count($value->getEspeestud());
        
            foreach ($value->getEspeestud() as $v){

            if (!$v->getEstudiante()->getFechaNacimiento()){
                $FechaNac = 'Vacio';
            }else{
                $FechaNac = $v->getEstudiante()->getFechaNacimiento()->format('d-m-Y');
            }

        $sexo = $v->getEstudiante()->getSexo();
                $pdf->RowBorders(array($i,($v->getEstudiante()->getCedula()),
                                      strtoupper(($v->getEstudiante()->getPrimerApellido().' '.$v->getEstudiante()->getSegundoApellido())),
                                       strtoupper(($v->getEstudiante()->getPrimerNombre().' '.$v->getEstudiante()->getSegundoNombre())),
                                       strtoupper($sexo[0]),
                                  ($FechaNac),
                                ), 0);
            $i++;
            }
        }
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(170, 6,'Total: ','T',0,'R');
        $pdf->Cell(20, 6,$ucs,'T',0,'C');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        
        //$pdf->Output('','totales_inscritos.pdf', 1);
        
             //return $this->dispositionReporte($pdf->Output());
       //Se reemplaza por:
       return $this->dispositionReporte($pdf->Output('', 'totales_inscritos.pdf', 'I'));
    }

    /**
     * @Route("/app/admin/form/listado/discapacidad/{programa}", name="app_admin_inscritos_discapacidad")
     */
    public function listadoDiscapacidadAction($programa = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formListadoDiscapacidad($em, $programa);
        
        return $this->render('AppBundle:Reportes:inscritos_con_discapacidad/index.html.twig', array(
            'form'=>$form->createView(),
            'programa'=>$programa,
            
        ));
    }
    
    private function formListadoDiscapacidad(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reportes_discapacidad'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:35%;'),                    
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:20%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:20%;'),
                ))
                ->getForm();
        return $form;
    }

    /**
     * @Route("/app/admin/reporte/listado/discapacidad/", name="app_admin_reportes_discapacidad")
     */
    public function reproteListadoDiscapacidadAction(Request $request){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $lapsoid = $form['lapso'];
        $cohorteid = $form['cohorte'];
        $programaid = $form['programa'];
        $especialidadid = $form['especialidad'];
        $subsedeid = $form['subsede'];
        
        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $cohorte = $em->getRepository('AppBundle:Cohorte')->find($cohorteid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        $subsede = $em->getRepository('AppBundle:Subsede')->find($subsedeid);
        
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesInscritosByEspecialidad2($cohorte, $lapso, $programa, $especialidad, $subsede);
    // ->find() ->findBy(['lapso'=>$lapso], [], Limit) ->findAll() ->findOneBy(['lapso'=>$lapso]) ->findByLapso 
        
        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN ESTUDIANTES CON DISCAPACIDAD!');
            return $this->redirect($this->generateUrl('app_admin_inscritos_discapacidad'));
        }

        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();

        $pdf->SetWidths(array(10,18,40,40,10,20,50));         
        //$pdf->Cell(40,10,'Hello World!');
        
        $pdf->SetY(35);
        $pdf->titleReport('Estudiantes Inscritos con Discapacidad');      
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$programa->getNombre()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(28,10,utf8_decode('Sede / Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(111,10,utf8_decode(''.$subsede->getDescripcion()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(14,10,utf8_decode('Cohorte: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(98,10,utf8_decode(''.$cohorte->getCodigo()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$especialidad->getNombre()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$lapso->getCodigo()),0,'L');
            $pdf->Ln(10);

        $pdf->aligns = array('C','C', 'L', 'L', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('N°','Cédula', 'Apellidos','Nombres', 'Sexo', 'Fecha nac.', 'Discapacidad');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        $i = 1;
        foreach ($entities as $value){
        
            foreach ($value->getEspeestud() as $v){
                
                $ucs = count($value->getEspeestud());
                $sexo = $v->getEstudiante()->getSexo();
                $pdf->RowBorders(array($i,($v->getEstudiante()->getCedula()),
                                        strtoupper(($v->getEstudiante()->getPrimerApellido().' '.$v->getEstudiante()->getSegundoApellido())),
                                        strtoupper(($v->getEstudiante()->getPrimerNombre().' '.$v->getEstudiante()->getSegundoNombre())),
                                        strtoupper($sexo[0]),
                                        $v->getEstudiante()->getFechaNacimiento()->format('d-m-Y'),
                                        $v->getEstudiante()->getDiscapacidad()
                                ), 0);
                $i++;
            }
        $i--;
        }

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(170, 6,'Total: ','T',0,'R');
        $pdf->Cell(20, 6,$ucs,'T',0,'C');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        
        //$pdf->Output('','totales_inscritos.pdf', 1);
        
          //   return $this->dispositionReporte($pdf->Output());
           return $this->dispositionReporte($pdf->Output('', 'totales_inscritos.pdf', 'I'));
       
    }
    
    /**
     * @Route("/app/admin/reporte/form/depositos/exonerados", name="app_admin_reporte_form_dep_exon")
     */
    public function reporteDepositosExoneradosAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formDepotisoExonerados($em);
        
        return $this->render('AppBundle:Reportes:depositosexon/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/generate/reports/dep/exon", name="app_admin_generate_reports_dep_exon")
     */
    public function generateReporteDepExoneradoAction(Request $request){
        $form = $request->get('form');
        
        $lapsoid = $form['lapso'];
        $programaid = $form['programa'];
        $especialidadid = $form['especialidad'];
        $tipo_reporte = $form['tipo_reporte'];
        if($tipo_reporte=='depositos')
        {
            $pdf = $this->generarReporteDepositos($lapsoid, $programaid, $especialidadid);
        }
        if($tipo_reporte=='exonorados')
        {
            $pdf = $this->generarReporteExonerados($lapsoid, $programaid, $especialidadid);
        }
        
        return $this->dispositionReporte($pdf->Output());
    }    
   
    private function generarReporteDepositos($lapsoid, $programaid, $especialidadid)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        
        $entities = $em->getRepository('AppBundle:Depositos')->findByDepositosByEspecialidad($especialidad ,$lapso);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
      
        $pdf->SetWidths(array(18,66,66,20,20));
        //srand(microtime()*1000000);        
        $headerPage = array('Programa'=>$especialidad->getPrograma()->getNombre(), 
                        'Especialidad'=>$especialidad->getNombre(),
                        'Período Académico'=>$lapso->getCodigo(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Reporte de Depósitos');
        $pdf->aligns = array('C', 'L', 'L', 'C', 'R', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Apellidos','Nombres', '#Bauche', 'Monto');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $sum = 0;
        foreach ($entities as $v){
                $depositos = "";
                $montos = "";
                foreach ($v->getDepositos() as $d)
                {
                    $depositos .= $d->getNumDeposito()."\n";
                    $montos .= number_format($d->getMonto(), 2,'.',',')."\n";
                    $sum += $d->getMonto();
                }
                $pdf->RowBorders(array(utf8_decode($v->getEstudiante()->getCedula()),
                                       utf8_decode($v->getEstudiante()->getPrimerApellido().' '.$v->getEstudiante()->getSegundoApellido()),
                                       utf8_decode($v->getEstudiante()->getPrimerNombre().' '.$v->getEstudiante()->getSegundoNombre()),
                                       utf8_decode($depositos),
                                       utf8_decode($montos),
                                ), 0);
        }
        $pdf->SetFont('helvetica','B',8);
        $pdf->Cell(170,6,  'Total:','T', 0, 'R');
        $pdf->Cell(20,6,  number_format($sum, 2, '.', ','),'T', 1, 'R');
        
        $pdf->Output('','reporte_depositos.pdf', 1);
        return $pdf;
        
    }
    
    private function generarReporteExonerados($lapsoid, $programaid, $especialidadid)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        
        $entities = $em->getRepository('AppBundle:Exonerados')->findByExoneracionByEspecialidad($especialidad ,$lapso);
        
        $exoneradosArr;
        $configPrograma = $em->getRepository('AppBundle:ConfigSistema')->findOneBy(array('programa'=>$programaid));
        foreach ($entities as $e)
        {
            //echo count($e->getMatricula());
            //die();
            $montoIns = $em->getRepository('AppBundle:Matricula')->getMontoInscritoEstudiante($e->getMatricula(), $em, $configPrograma);
            $porcentaje = $e->getExonerados()[0]->getPorcentaje();
            
            $exoneradosArr[] = array(
                'cedula'=>$e->getEstudiante()->getCedula(),
                'apellidos'=>$e->getEstudiante()->getPrimerApellido().' '.$e->getEstudiante()->getSegundoApellido(),
                'nombres'=>$e->getEstudiante()->getPrimerNombre().' '.$e->getEstudiante()->getSegundoNombre(),
                'tipo'=>$e->getExonerados()[0]->getTipo()->getDescripcion(),
                'resolucion'=>$e->getExonerados()[0]->getResolucion(),
                'porcentaje'=> number_format($porcentaje, 2, ',', '.'),
                'montoInsc'=> number_format($montoIns, 2, ',', '.'),
                'monto'=>  number_format(($montoIns*$porcentaje)/100, 2, '.','')
            );
        }
        
        
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
      
        $pdf->SetWidths(array(18,45,45,35,22,25));
        //srand(microtime()*1000000);        
        $headerPage = array('Programa'=>$especialidad->getPrograma()->getNombre(), 
                        'Especialidad'=>$especialidad->getNombre(),
                        'Período Académico'=>$lapso->getCodigo(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Reporte de Exoneración');
        $pdf->aligns = array('C', 'L', 'L', 'L', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Apellidos','Nombres', 'Resolución', 'Porcentaje', 'Monto');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $sum = 0;
        foreach ($exoneradosArr as $v){
                $sum += $v['monto'];
                
                $pdf->RowBorders(array(utf8_decode($v['cedula']),
                                       utf8_decode($v['apellidos']),
                                       utf8_decode($v['nombres']),
                                       utf8_decode($v['resolucion']),
                                       utf8_decode($v['porcentaje']),
                                       utf8_decode($v['monto']),
                                ), 0);
        }
        $pdf->SetFont('helvetica','B',8);
        $pdf->Cell(165 ,6,  'Total:','T', 0, 'R');
        $pdf->Cell(25,6,  number_format($sum, 2, '.', ''),'T', 1, 'C');
        
        $pdf->Output('','reporte_depositos.pdf', 1);
        return $pdf;
        
    }
    
    private function formDepotisoExonerados(\Doctrine\ORM\EntityManager $em, $programa = null)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_generate_reports_dep_exon'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:60%;'),
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))
                ->add('tipo_reporte', 'choice', array(
                    'choices'=>array('depositos'=>'Depósitos', 'exonorados'=>'Exonerados'),
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))

                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/reporte/form/sintranscripcion/", name="app_admin_report_form_sintranscripcion")
     */
    public function generarFormSinTranscribirAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formProfesoresSinTranscripcion($em);
        
        return $this->render('AppBundle:Reportes:profesores_sin_transcribir/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/reporte/sintranscripcion/", name="app_admin_report_sintranscripcion")
     */
    public function generarReportSinTranscribirAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $form = $request->get('form');
        $lapsoid = $form['lapso'];
        $programaid = $form['programa'];
        $especialidadid = $form['especialidad']; 
        $subsedeid = $form['subsede'];
        $cohorteid = $form['cohorte'];
        
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $cohorte = $em->getRepository('AppBundle:Cohorte')->find($cohorteid);
        $subsede = $em->getRepository('AppBundle:SubSede')->find($subsedeid);
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede= $em->getRepository('AppBundle:Sede')->findByCodigo($ids);
        
        $entities = $em->getRepository('AppBundle:OfertAcade')->findOfertaSinTranscribirA($especialidad, $cohorte, $lapso, $sede, $subsede);

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-success', 'No se encuentran profesores sin transcribir!');
            return $this->redirect($this->generateUrl('app_admin_report_form_sintranscripcion'));
        }
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
      
        $pdf->SetWidths(array(19,23,23,20,87,18));
        //srand(microtime()*1000000);        
        /*$headerPage = array('Programa'=>$especialidad->getPrograma()->getNombre(), 
                        'Especialidad'=>$especialidad->getNombre(),
                        'Período Académico'=>$lapso->getCodigo(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');*/

        $pdf->SetY(35);
        $pdf->titleReport('Profesores Sin Transcribir Calificaciones');       
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$especialidad->getPrograma()->getNombre()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(28,10,utf8_decode('Sede / Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(111,10,utf8_decode(''.$subsede->getDescripcion()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(14,10,utf8_decode('Cohorte: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(98,10,utf8_decode(''.$cohorte->getCodigo()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$especialidad->getNombre()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$lapso->getCodigo()),0,'L');
            $pdf->Ln(10);

        $pdf->aligns = array('C','L','L','C','L','C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Apellido','Nombre','Codigo','Unidad Curricular','Sección');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',7);
        $sum = 0;

        foreach ($entities as $v){

            $prof = $v->getId();

            $entities2 = $em->getRepository('AppBundle:OfertAcade')->findOfertaCurSec($prof, $especialidad, $lapso, $sede, $subsede);

            foreach ($entities2 as $oferta){
            	$pdf->RowBorders(array(utf8_decode($v->getCedula()),
                                   strtoupper(utf8_decode($v->getPrimerApellido())),
                                   strtoupper(utf8_decode($v->getPrimerNombre())),
                                   $oferta->getCurso()->getCodigo(),
                                   strtoupper($oferta->getCurso()->getNombre()),
                                   $oferta->getSeccion()
                            ), 0);
            	
            	$sum += '1';
            }

            
        
        }

        $pdf->SetFont('helvetica','B',8);
        $pdf->Cell(15 ,6,  'Total:','T', 0, 'L');
        $pdf->Cell(175 ,6,  $sum,'T', 1, 'L');

        
        $pdf->Output('','reporte_profesores_sin_transcribir.pdf', 1);
        return $pdf;
        
    }
    
    private function formProfesoresSinTranscripcion(\Doctrine\ORM\EntityManager $em, $programa = null)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_report_sintranscripcion'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:30%;'),
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:20%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:25%;'),
                ))

                ->getForm();
        return $form;
    }

    /**
     * @Route("/app/admin/reporte/form/sintranscripcion/general/", name="app_admin_report_form_sintranscripcion_general")
     */
    public function generarFormSinTranscribirGeneralAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formProfesoresSinTranscripcionGeneral($em);
        
        return $this->render('AppBundle:Reportes:profesores_sin_transcribir_general/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/reporte/sintranscripcion/general", name="app_admin_report_sintranscripcion_general")
     */
    public function generarReportSinTranscribirGeneralAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $form = $request->get('form');
        $programaid = $form['programa'];
        $subsedeid = $form['subsede'];
        $lapsoid = $form['lapso'];
        
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $subsede = $em->getRepository('AppBundle:SubSede')->find($subsedeid);
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede= $em->getRepository('AppBundle:Sede')->findByCodigo($ids);
        
        $entities = $em->getRepository('AppBundle:OfertAcade')->findOfertaSinTranscribirG($lapso, $sede, $subsede);

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-success', 'No se encuentran profesores sin transcribir!');
            return $this->redirect($this->generateUrl('app_admin_report_form_sintranscripcion_general'));
        }
        
        // solicitamos el servicio 'phpexcel' y creamos el objeto vacío...
        $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();

        // ...y le asignamos una serie de propiedades
        $phpExcelObject->getProperties()
            ->setCreator("UPEL")
            ->setLastModifiedBy("UPEL")
            ->setTitle("Prof(a) sin transcribir G".$lapso)
            ->setSubject("Prof(a) sin transcribir G")
            ->setDescription("Prof(a) sin transcribir G")
            ->setKeywords("UPEL exportar excel");

        $activesheet = $phpExcelObject->getActiveSheet();
        $drawingobject = $this->get('phpexcel')->createPHPExcelWorksheetDrawing();
        $drawingobject->setName('upel.png');
        $drawingobject->setDescription('Logo');
        $drawingobject->setPath('../web/uploads/images/upel.png');
        $drawingobject->setHeight(80);
        $drawingobject->setOffsetY(30);
        $drawingobject->setCoordinates('A1');
        $drawingobject->setWorksheet($activesheet);

        // establecemos como hoja activa la primera, y le asignamos un título
        $phpExcelObject->setActiveSheetIndex(0);
        $phpExcelObject->getActiveSheet()->setTitle('Prof(a) sin transcribir General');
        
        // escribimos en distintas celdas del documento el título de los campos que vamos a exportar
        $phpExcelObject->setActiveSheetIndex(0)
            ->setCellValue('C2', 'República Bolivariana de Venezuela')
            ->setCellValue('C3', 'Universidad Pedagógica Experimental Libertador')

            ->setCellValue('A6', 'Programa: Pregrado')
            ->setCellValue('A7', 'Período: '.$lapso)
            ->setCellValue('A8', 'Sede / Extensión: '.$subsede->getDescripcion())
            
            ->setCellValue('A10', 'CÉDULA')
            ->setCellValue('B10', 'APELLIDO')
            ->setCellValue('C10', 'NOMBRE')
            ->setCellValue('D10', 'UNIDAD CURRICULAR')
            ->setCellValue('E10', 'ESPECIALIDAD')
            ->setCellValue('F10', 'SECCIÓN')
            ->setCellValue('G10', 'COHORTE');


        // fijamos un ancho a las distintas columnas
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('A')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('B')
            ->setWidth(17);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('C')
            ->setWidth(17);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('D')
            ->setWidth(80);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('E')
            ->setWidth(35);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('F')
            ->setWidth(10);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('G')
            ->setWidth(10);

        // recorremos los registros obtenidos de la consulta a base de datos escribiéndolos en las celdas correspondientes

        $sum = 0;
        $row = 12;

        foreach ($entities as $v){

            $prof = $v->getId();

            $entities2 = $em->getRepository('AppBundle:OfertAcade')->findOfertaCurSecCoh($prof, $lapso, $sede, $subsede);

            foreach ($entities2 as $oferta){                            

            $oferta_academica = $oferta->getId();

            $entities3 = $em->getRepository('AppBundle:Matricula')->findOfertaInscritos($oferta_academica);

                if($entities3){

                    $phpExcelObject->setActiveSheetIndex(0)
                        ->setCellValue('A'.$row, utf8_decode($v->getCedula()))
                        ->setCellValue('B'.$row, strtoupper(utf8_decode($v->getPrimerApellido())))
                        ->setCellValue('C'.$row, strtoupper(utf8_decode($v->getPrimerNombre())))
                        ->setCellValue('D'.$row, strtoupper($oferta->getCurso()->getNombre()))
                        ->setCellValue('E'.$row, $oferta->getEspecialidad()->getNombre())
                        ->setCellValue('F'.$row, $oferta->getSeccion())
                        ->setCellValue('G'.$row, $oferta->getCohorte());

                    $row++;
                    $sum += '1';

                }

            }
        }
        $row++;

        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'Total: '.$sum);      

        // se crea el writer
        $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
        // se crea el response
        $response = $this->get('phpexcel')->createStreamedResponse($writer);
        // y por último se añaden las cabeceras
        $dispositionHeader = $response->headers->makeDisposition(
            ResponseHeaderBag::DISPOSITION_ATTACHMENT,
            'Listado Prof(a) sin transcribir general.xls'
        );
        $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');
        $response->headers->set('Pragma', 'public');
        $response->headers->set('Cache-Control', 'maxage=1');
        $response->headers->set('Content-Disposition', $dispositionHeader);

        return $response;
        
    }
    
    private function formProfesoresSinTranscripcionGeneral(\Doctrine\ORM\EntityManager $em, $programa = null)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_report_sintranscripcion_general'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:20%;')
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:25%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:55%;'),
                ))

                ->getForm();
        return $form;
    }



    /* asesoria academica */


    /**
     * @Route("/app/admin/reports/form/totales/asesorados_pa", name="app_admin_reports_totales_inscritos_asesoria_p")
     */
    public function totalesInscritosAsesoriaPFormAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formTotalesInscritosAsesoriaP($em);
        
        return $this->render('AppBundle:Reportes:totales_inscritos/indexasesoriap.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formTotalesInscritosAsesoriaP(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_totales_inscritos_asesoria_p'))
                ->setMethod('POST')
                ->setAttributes(array('attr'=>array('target'=>'_blank')))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em, 
                    'mapped'=>false,
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('l');
                        $q->orderBy('l.codigo', 'DESC');
                        return $q;
                    },
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ;
        return $form->getForm();
    }
    
    /**
     * @Route("/app/admin/reportes/totales/asesorados_pa", name="app_admin_reporte_totales_inscritos_asesoria_p")
     */
    public function reporteTotalesInscritosAsesoradosPAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $programaid =  $form['programa'];
        $subsedeid = $form['subsede'];
        $lapsoid = $form['lapso'];

        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $subsede = $em->getRepository('AppBundle:SubSede')->find($subsedeid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        
        $entities = $em->getRepository('AppBundle:Asesoria')->getEstudEspecialidadAsesorados($lapso, $programa);

        $entities2 = $em->getRepository('AppBundle:Asesoria')->findEstudiantesAsesorados($lapso, $programa, $subsede);

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN ESTUDIANTES ASESORADOS!');
            return $this->redirect($this->generateUrl('app_admin_reports_totales_inscritos_asesoria_p'));
        }
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();

        $pdf->SetWidths(array(160,30));         

        $pdf->SetY(35);
        $pdf->titleReport('Totales de Asesorados');       
        
        $pdf->SetFont('helvetica','B',9);
            $pdf->Cell(28,10,utf8_decode('Sede / Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(162,10,utf8_decode(''.$subsede->getDescripcion()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(158,10,utf8_decode(''.$lapso->getCodigo()),0,'L');
            $pdf->Ln(10);


        $pdf->aligns = array('L', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Especialidad', 'Cantidad');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        $id_est = 0;
        $total = 0;
        
        foreach ($entities as $value){

            foreach ($entities2 as $value2){

                if ($id_est != $value2->getEstudiante()->getId()){

                    if ($value['nombre'] == $value2->getEstudiante()->getEspecialidad()->getNombre()){

                    $total += '1';
                    $ucs += '1';

                    }
                }

            $id_est = $value2->getEstudiante()->getId();

            }
        if ($total != "0"){
            
            $pdf->RowBorders(array(($value['nombre']),
                                      $total
                                ), 0);
        }

        $total = 0;

        }

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(160, 6,'Total: ','T',0,'R');
        $pdf->Cell(30, 6,$ucs,'T',0,'C');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
       // $pdf->Output('','total_asesorados.pdf', 1);
        
        //return $this->dispositionReporte($pdf->Output());
        return $this->dispositionReporte($pdf->Output('', 'total_asesorados.pdf', 'I'));
        
    }
    
    /**
     * @Route("/app/admin/reports/form/totales/asesorados", name="app_admin_reports_totales_inscritos_asesoria_c")
     */
    public function totalesInscritosAsesoriaCFormAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formTotalesInscritosAsesoriaC($em);
        
        return $this->render('AppBundle:Reportes:totales_inscritos/indexasesoriac.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formTotalesInscritosAsesoriaC(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_totales_inscritos_asesoria_c'))
                ->setMethod('POST')
                ->setAttributes(array('attr'=>array('target'=>'_blank')))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em, 
                    'mapped'=>false,
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('l');
                        $q->orderBy('l.codigo', 'DESC');
                        return $q;
                    },
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ;
        return $form->getForm();
    }
    
    /**
     * @Route("/app/admin/reportes/totales/asesorados", name="app_admin_reporte_totales_inscritos_asesoria_c")
     */
    public function reporteTotalesInscritosAsesoradosCAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $programaid =  $form['programa'];
        $subsedeid = $form['subsede'];
        $lapsoid = $form['lapso'];
        $cohorteid = $form['cohorte'];

        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $subsede = $em->getRepository('AppBundle:SubSede')->find($subsedeid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $cohorte = $em->getRepository('AppBundle:Cohorte')->find($cohorteid);
        
        $entities = $em->getRepository('AppBundle:Asesoria')->getEstudEspecialidadAsesoradosC($cohorte, $lapso, $programa);

        $entities2 = $em->getRepository('AppBundle:Asesoria')->findEstudiantesAsesorados($lapso, $programa, $subsede);

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN ESTUDIANTES ASESORADOS!');
            return $this->redirect($this->generateUrl('app_admin_reports_totales_inscritos_asesoria_c'));
        }
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();

        $pdf->SetWidths(array(160,30));         

        $pdf->SetY(35);
        $pdf->titleReport('Totales de Asesorados');       
        
        $pdf->SetFont('helvetica','B',9);
            $pdf->Cell(28,10,utf8_decode('Sede / Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(162,10,utf8_decode(''.$subsede->getDescripcion()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
	    $pdf->Cell(15,10,utf8_decode('Cohorte: '),0,'L');
	    $pdf->SetFont('helvetica','',9);
	    $pdf->Cell(175,10,utf8_decode(''.$cohorte->getCodigo()),0,'L');
	        $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(158,10,utf8_decode(''.$lapso->getCodigo()),0,'L');
            $pdf->Ln(10);


        $pdf->aligns = array('L', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Especialidad', 'Cantidad');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        $id_est = 0;
        $total = 0;
        
        foreach ($entities as $value){

            foreach ($entities2 as $value2){

                if ($id_est != $value2->getEstudiante()->getId() && $cohorte == $value2->getEstudiante()->getCohorte()){

                    if ($value['nombre'] == $value2->getEstudiante()->getEspecialidad()->getNombre()){

                    $total += '1';
                    $ucs += '1';

                    }

                }

            $id_est = $value2->getEstudiante()->getId();

            }
        if ($total != "0"){
            
            $pdf->RowBorders(array(($value['nombre']),
                                      $total
                                ), 0);
        }

        $total = 0;

        }

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(160, 6,'Total: ','T',0,'R');
        $pdf->Cell(30, 6,$ucs,'T',0,'C');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
       // $pdf->Output('','total_asesorados.pdf', 1);
        
        //return $this->dispositionReporte($pdf->Output());
        return $this->dispositionReporte($pdf->Output('', 'total_asesorados.pdf', 'I'));
        
    }

    /**
     * @Route("/app/admin/reports/listado/pregrado", name="app_admin_listado_pregrado")
     */

    public function listadoPregradoAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsultPregrado($em);
        
        return $this->render('AppBundle:Reportes:listado_pregrado/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formConsultPregrado(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reportes_pregrado'))
                ->setMethod('POST')
                ->setAttributes(array('attr'=>array('target'=>'_blank')))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em
                ))
                ;
        return $form->getForm();
    }

     /**
     * @Route("/app/admin/reporte/listado-pregrado", name="app_admin_reportes_pregrado")
     */

    public function ReportelistadoPregradoAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        $fecha = new \DateTime();
        $fechaactual = $fecha->format('d-m-Y');
        

        $programaid =  $form['programa'];
        $sede = $this->getUser()->getSede();

        // recuperamos los elementos de base de datos que queremos exportar
        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $entities = $em->getRepository('AppBundle:Estudiante')->getEstudiantesPregrado();

        // solicitamos el servicio 'phpexcel' y creamos el objeto vacío...
        $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();

        // ...y le asignamos una serie de propiedades
        $phpExcelObject->getProperties()
            ->setCreator("UPEL")
            ->setLastModifiedBy("UPEL")
            ->setTitle("Listado Pregrado")
            ->setSubject("Listado")
            ->setDescription("Listado de pregrado")
            ->setKeywords("UPEL exportar excel");

        $activesheet = $phpExcelObject->getActiveSheet();
        $drawingobject = $this->get('phpexcel')->createPHPExcelWorksheetDrawing();
        $drawingobject->setName('upel.png');
        $drawingobject->setDescription('Logo');
        $drawingobject->setPath('../web/uploads/images/upel.png');
        $drawingobject->setHeight(80);
        $drawingobject->setOffsetY(30);
        $drawingobject->setCoordinates('A1');
        $drawingobject->setWorksheet($activesheet);

        // establecemos como hoja activa la primera, y le asignamos un título
        $phpExcelObject->setActiveSheetIndex(0);
        $phpExcelObject->getActiveSheet()->setTitle('Listado Pregrado');
        
        // escribimos en distintas celdas del documento el título de los campos que vamos a exportar
        $phpExcelObject->setActiveSheetIndex(0)
            ->setCellValue('B2', 'República Bolivariana de Venezuela')
            ->setCellValue('B3', 'Universidad Pedagógica Experimental Libertador')

            ->setCellValue('A6', 'Programa: '.$programa)
            ->setCellValue('A8', 'Sede: '.$sede)

            ->setCellValue('F2', 'Fecha: '.$fechaactual)
            
            ->setCellValue('A10', 'CÓDIGO')
            ->setCellValue('B10', 'ESPECIALIDAD')
            ->setCellValue('C10', 'CONDICION DE RES.')
            ->setCellValue('D10', 'CÉDULA')
            ->setCellValue('E10', 'APELLIDOS')
            ->setCellValue('F10', 'NOMBRES')
            ->setCellValue('G10', 'SEXO')
            ->setCellValue('H10', 'FECHA DE NAC.')
            ->setCellValue('I10', 'FECHA DE ING.')
            ->setCellValue('J10', 'ÚLTIMO P.I.')
            ->setCellValue('K10', 'ETNIA')
            ->setCellValue('L10', 'PRIV. DE LIBERTAD')
            ->setCellValue('M10', 'NÚMERO DE RUSNIES')
            ->setCellValue('N10', 'COHORTE')
            ->setCellValue('O10', 'U.C.A.')
            ->setCellValue('P10', 'PLANTEL GRADUADO')
            ->setCellValue('Q10', 'CLASIFICACIÓN DEL PLANTEL')
            ->setCellValue('R10', 'FECHA GRD. BACH.')
            ->setCellValue('S10', 'ESTADO')
            ->setCellValue('T10', 'MUNICIPIO')
            ->setCellValue('U10', 'BECA')
            ->setCellValue('V10', 'NIVEL ECONÓMICO')
            ->setCellValue('W10', 'SEDE/EXTENSIÓN');


        // fijamos un ancho a las distintas columnas
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('A')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('B')
            ->setWidth(73);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('C')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('D')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('E')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('F')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('G')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('H')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('I')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('J')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('K')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('L')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('M')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('N')
            ->setWidth(12);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('O')
            ->setWidth(12);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('P')
            ->setWidth(40);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('Q')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('R')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('S')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('T')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('U')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('V')
            ->setWidth(45);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('W')
            ->setWidth(65);

        // recorremos los registros obtenidos de la consulta a base de datos escribiéndolos en las celdas correspondientes

        $ucs = 0;
        $uca = 0;
        $row = 12;
        $FechaInclusion = '';
        $sexo = '';
        $beca = '';
        $residencia = '';
        $PrivLib = '';
        $NumRusnies = '';
        $NivelEco = '';
        $CPlantel = '';
        $FechaNac = '';
        $FechaGra = '';
        $estudiante2 = '';


        foreach ($entities as $v){

            $estudiante = $v->getId();

            if (!$v->getFechaNacimiento()){
                $FechaNac = 'Vacio';
            }else{
                $FechaNac = $v->getFechaNacimiento()->format('d-m-Y');
            }

            if (!$v->getFechaGraduado()){
                $FechaGra = 'Vacio';
            }else{
                $FechaGra = $v->getFechaGraduado()->format('d-m-Y');
            }

            $entities2 = $em->getRepository('AppBundle:EspeEstud')->findEspeEstudPregrado($estudiante);

            foreach ($entities2 as $espe){
                    $estudiante2 = $espe->getId();
                }            

            $entities3 = $em->getRepository('AppBundle:EspeEstud')->findHistMatriUCA($estudiante2);

            $entities4 = $em->getRepository('AppBundle:Matricula')->getHistorico($estudiante2);

            foreach ($entities4 as $fecha){
                $FechaInclusion = $fecha->getOferta()->getFechaInclusion()->format('d-m-Y');
            }

            foreach ($entities2 as $estud){
                $FecIng = $estud->getFechaIngreso()->format('d-m-Y');
            }

            foreach ($entities3 as $unicredapro){
                $uca += $unicredapro->getCurso()->getUc();
            }

            switch ($v->getBeca()) {
                        case '0':
                            $beca = 'No Posee Beca';
                            break;
                        case '1':
                            $beca = 'Becado por la Institución';
                            break;
                        case '2':
                            $beca = 'Becado por la Alcaldía o Gobernación';
                            break;
                        case '3':
                            $beca = 'Por un Ministerio';
                            break;
                        case '4':
                            $beca = 'Por Fundayacucho';
                            break;
                        case '5':
                            $beca = 'Por un Ente Privado';
                            break;
                        case '6':
                            $beca = 'Por la Opsu';
                            break;
                        case '':
                            $beca = 'Vacio';
                            break;
                    }
            switch ($v->getClasifPlantel()) {
                        case '1':
                            $CPlantel = 'Público';
                            break;
                        case '2':
                            $CPlantel = 'Privado';
                            break;
                        case '3':
                            $CPlantel = 'Mixto';
                            break;
                        case '':
                            $CPlantel = 'Vacio';
                            break;
                    }
            switch ($v->getSexo()) {
                        case 'f':
                            $sexo = 'Femenino';
                            break;
                        case 'm':
                            $sexo = 'Masculino';
                            break;
                        case 'F':
                            $sexo = 'Femenino';
                            break;
                        case 'M':
                            $sexo = 'Masculino';
                            break;
                        case 'Femenino':
                            $sexo = 'Femenino';
                            break;
                        case 'Masculino':
                            $sexo = 'Masculino';
                            break;
                        case 'null':
                            $sexo = 'Vacio';
                            break;
                    }
            switch ($v->getCondiResidencia()) {
                        case '1':
                            $residencia = 'Residente';
                            break;
                        case '2':
                            $residencia = 'Transeúnte';
                            break;
                        case '':
                            $residencia = 'Vacio';
                            break;
                    }
            switch ($v->getPrivLibertad()) {
                        case '1':
                            $PrivLib = 'Si';
                            break;
                        case '0':
                            $PrivLib = 'No';
                            break;
                        case '':
                            $PrivLib = 'Vacio';
                            break;
                    }
            switch ($v->getNivelEconomico()) {
                        case '1':
                            $NivelEco = 'INGRESOS MENSUALES INFERIORES A 40.000 BS';
                            break;
                        case '2':
                            $NivelEco = 'INGRESOS MENSUALES ENTRE 40.000 Y 80.000 BS';
                            break;
                        case '3':
                            $NivelEco = 'INGRESOS MENSUALES ENTRE 80.000 Y 130.000 BS';
                            break;
                        case '4':
                            $NivelEco = 'INGRESOS MENSUALES ENTRE 130.000 Y 180.000 BS';
                            break;
                        case '5':
                            $NivelEco = 'INGRESOS MENSUALES SUPERIORES A 180.000 BS';
                            break;
                        case '':
                            $NivelEco = 'Vacio';
                            break;
                    }

            if (!$v->getNumRusnies()){
                $NumRusnies = 'Vacio';
            }else{
                $NumRusnies = $v->getNumRusnies();
            }

            if (!$v->getMunicipio()){
                $Munic = 'Vacio';
            }else{
                $Munic = $v->getMunicipio();
            }

            foreach ($entities2 as $estud){


            if (!$estud->getEspecialidad()){
                $Especi = 'Vacio';
                $EspeCod = 'Vacio';
            }else{
                $Especi = $estud->getEspecialidad();
                $EspeCod = $estud->getEspecialidad()->getCodigo();
            }
                   

            $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row, $EspeCod)
                ->setCellValue('B'.$row, $Especi)
                ->setCellValue('C'.$row, $residencia)
                ->setCellValue('D'.$row, $v->getCedula())
                ->setCellValue('E'.$row, $v->getPrimerApellido().' '.$v->getSegundoApellido())
                ->setCellValue('F'.$row, $v->getPrimerNombre().' '.$v->getSegundoNombre())
                ->setCellValue('G'.$row, $sexo)
                ->setCellValue('H'.$row, $FechaNac)
                ->setCellValue('I'.$row, $FecIng)
                ->setCellValue('J'.$row, $FechaInclusion)
                ->setCellValue('K'.$row, $v->getEtnia())
                ->setCellValue('L'.$row, $PrivLib)
                ->setCellValue('M'.$row, $NumRusnies)
                ->setCellValue('N'.$row, $estud->getCohorte())
                ->setCellValue('O'.$row, $uca)
                ->setCellValue('P'.$row, $v->getPlantelGraduado())
                ->setCellValue('Q'.$row, $CPlantel)
                ->setCellValue('R'.$row, $FechaGra)
                ->setCellValue('S'.$row, $v->getEstado())
                ->setCellValue('T'.$row, $Munic)
                ->setCellValue('U'.$row, $beca)
                ->setCellValue('V'.$row, $NivelEco)
                ->setCellValue('W'.$row, $estud->getSubsede());

            $row++;
            }


        $ucs += '1';
        $uca = 0;
        }
        $row++;

        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'Total de estudiantes: '.$ucs);
        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'CONDICIÓN DE RES.: CONDICIÓN DE RESIDENCIA');$row++;
        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'FECHA DE NAC.: FECHA DE NACIMIENTO');$row++;
        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'FECHA DE ING.: FECHA DE INGRESO');$row++;
        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'ÚLTIMO P.I.: ÚLTIMO PERÍODO INSCRITO');$row++;
        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'PRIV. DE LIBERTAD: PRIVADO DE LIBERTAD');$row++;
        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'U.C.A.: UNIDADES DE CRÉDITOS APROBADAS');$row++;
        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'FECHA GRD. BACH.: FECHA GRADUACIÓN BACHILLER');$row++;
                
                

        // se crea el writer
        $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
        // se crea el response
        $response = $this->get('phpexcel')->createStreamedResponse($writer);
        // y por último se añaden las cabeceras
        $dispositionHeader = $response->headers->makeDisposition(
            ResponseHeaderBag::DISPOSITION_ATTACHMENT,
            'LISTADO.xls'
        );
        $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');
        $response->headers->set('Pragma', 'public');
        $response->headers->set('Cache-Control', 'maxage=1');
        $response->headers->set('Content-Disposition', $dispositionHeader);

        return $response;        
    }

    /**
     * @Route("/app/admin/reporte/listado/clase/inscritos/{programa}/{especialidad}/{lapso}/{sede}/{subsede}/{cohorte}", name="app_admin_inscritos_por_UC")
     */
    public function listadoInscritosClasesAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL, $cohorte = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsultOfertaInscritos($em, $programa);
        
        if($programa==NULL && $especialidad==NULL && $lapso==NULL && $sede==NULL&&$subsede==NULL && $cohorte==NULL){
            $oferta = NULL;
        }else{            
            $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        }
        
        return $this->render('AppBundle:Reportes:inscritos_por_UC/index.html.twig', array(
            'form'=>$form->createView(),
            'oferta'=>$oferta,
            'programa'=>$programa,
            'especialidad'=>$especialidad,
            'lapso'=>$lapso,
            'subsede'=>$subsede,
            'cohorte'=>$cohorte,
        ));
    }
    
    private function formConsultOfertaInscritos(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:Seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:Seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:50%;'),                    
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:Seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:Seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extension .:Seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/reportes/listado/clases/inscritos/{id}", name="app_admin_reporte_inscritos_por_UC")
     */
    public function reportListadoInscritosClasesAction($id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesByOferta($oferta);
        $subsedeausar = $oferta->getSubSede()->getId();

        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('subsede'=>$subsedeausar,'cargo'=>$cargo, 'activo'=>$activo));
        
        $cualitativo = false;
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(10,20,80,80));
        $pdf->SetAligns(array('C','C','L', 'L'));
        //srand(microtime()*1000000);
        $pdf->setProfesor($oferta->getProfesor());
        $pdf->titleReport('Inscritos por Unidades Curriculares');

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getPrograma()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(26,10,utf8_decode('Sede/Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$oferta->getSubSede()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$oferta->getEspecialidad()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(11,10,utf8_decode('Curso: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(128,10,utf8_decode(''.$oferta->getCurso()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Sección: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(20,10,utf8_decode(''.$oferta->getSeccion()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(13,10,utf8_decode('Horario: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(126,10,utf8_decode(''.$oferta->getHorario()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(15,10,utf8_decode('Cohorte: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getCohorte()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(16,10,utf8_decode('Ambiente: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(123,10,utf8_decode(''.$oferta->getAmbiente()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$oferta->getLapso()),0,'L');
            $pdf->Ln(10);
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('N°','Cédula', 'Nombre', 'Apellidos');
        $pdf->RowTitles($titles); 
        
        $index = 1;
        $aplaz = 0;
        $aprob = 0;
        $proc = 0;
        $nota = '';
       
        foreach ($entities as $value){

            $calificacion = ($cualitativo) ? '':$value->getNota();

            if($value->getCondicion()!='INSCRITO'){
                $nota = $calificacion;
            }

            $pdf->RowBorders(array($index,
                    $value->getEstudiante()->getEstudiante()->getCedula(),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getEstudiante()->getSegundoNombre()),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getEstudiante()->getSegundoApellido()),
            ), 1);
            
            $index++;

        }

        if(count($entities) == 0){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO HAY ESTUDIANTES INSCRITOS');
            return $this->redirect($this->generateUrl('app_admin_listado_clases'));
        }  

        $pdf->Ln(5);
    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(16,10,utf8_decode('Profesor: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(140,10,utf8_decode(''.utf8_decode($oferta->getProfesor())),0,'L');
    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(28,10,utf8_decode('Total Estudiantes: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(5,10,utf8_decode(''.count($entities)),0,'L');
        $pdf->Ln(5);

    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(13,10,utf8_decode('Cédula: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(118,10,utf8_decode(''.number_format($oferta->getProfesor()->getCedula(), 0, '', '.')),0,'L');

        $pdf->Ln(30);
    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
        $pdf->Ln(5);
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Cell(64, 10,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
        $pdf->Ln(10);
    $pdf->Cell(63,10,'',0,0,'C');
    $pdf->Cell(64, 10,  utf8_decode('Sello'),'',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Ln(5);
        
       // $pdf->Output('','Listado de clases.pdf', 1);
        
       // return $this->dispositionReporte($pdf->Output());
       // se reemplaza por:
       return $this->dispositionReporte($pdf->Output('', 'Listado de clases.pdf', 'I'));
    }
    
    /**
     * @Route("/app/admin/reporte/listado/clase/asesorados/{programa}/{especialidad}/{lapso}/{sede}/{subsede}", name="app_admin_asesorados_por_UC")
     */
    public function listadoAsesoradosClasesAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsultOfertaAsesorados($em, $programa);
        
        if($programa==NULL && $especialidad==NULL && $lapso==NULL && $sede==NULL&&$subsede==NULL){
            $asesoria = NULL;   
        }else{            
            $asesoria = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede);
        }
        
        return $this->render('AppBundle:Reportes:asesorados_por_UC/index.html.twig', array(
            'form'=>$form->createView(),
            'programa'=>$programa,
            'asesoria'=>$asesoria,
            'especialidad'=>$especialidad,
            'lapso'=>$lapso,
            'subsede'=>$subsede,
        ));
    }
    
    private function formConsultOfertaAsesorados(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:Seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:Seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:50%;'),                    
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:Seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extension .:Seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:20%;'),
                ))
                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/reportes/listado/clases/asesorados/{id}/", name="app_admin_reporte_asesorados_por_UC")
     */
    public function reportListadoAsesoradosClasesAction($id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $asesoria = $em->getRepository('AppBundle:Asesoria')->find($id);
        $especialidad = $asesoria->getEstudiante()->getEspecialidad();
        $curso = $asesoria->getCurso();
        $lapso = $asesoria->getLapso();

        $entities = $em->getRepository('AppBundle:Asesoria')->getEstudAsesorados($especialidad, $curso, $lapso);
        $subsedeausar = $asesoria->getEstudiante()->getSubSede()->getId(); 
        
        //$entities = $em->getRepository('AppBundle:Asesoria')->findAllAsesoriaAcademica($especialidad, $lapso);

        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('subsede'=>$subsedeausar,'cargo'=>$cargo, 'activo'=>$activo));
        
        $cualitativo = false;
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(10,20,70,70,20));
        $pdf->SetAligns(array('C','C','L', 'L','C'));
        //srand(microtime()*1000000);
        $pdf->titleReport('Asesorados por Unidades Curriculares');

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$asesoria->getEstudiante()->getPrograma()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(26,10,utf8_decode('Sede/Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$asesoria->getEstudiante()->getSubSede()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$asesoria->getEstudiante()->getEspecialidad()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(29,10,utf8_decode('Unidad Curricular: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$asesoria->getCurso()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(128,10,utf8_decode(''.$asesoria->getLapso()),0,'L');        
            $pdf->Ln(10);
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('N°','Cédula', 'Nombre', 'Apellidos', 'Cohorte');
        $pdf->RowTitles($titles); 
        
        $index = 1;
        $cont = 0;

        foreach ($entities as $value){

            $pdf->RowBorders(array($index,
                    $value->getEstudiante()->getEstudiante()->getCedula(),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getEstudiante()->getSegundoNombre()),
                    strtoupper($value->getEstudiante()->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getEstudiante()->getSegundoApellido()),
                    $value->getEstudiante()->getCohorte()->getCodigo(),
            ), 1);
            
            $index++;
            $cont++;

        }

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE PUEDE GENERAR LISTADO');
            return $this->redirect($this->generateUrl('app_admin_asesorados_por_UC'));
        }  

        $pdf->Ln(5);
    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(28,10,utf8_decode('Total Estudiantes: '),0,'L');
    $pdf->SetFont('helvetica','',9);
    $pdf->Cell(5,10,utf8_decode(''.$cont),0,'L');
        $pdf->Ln(5);

        $pdf->Ln(30);
    $pdf->SetFont('helvetica','B',9);
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
        $pdf->Ln(5);
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Cell(64, 10,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
        $pdf->Ln(10);
    $pdf->Cell(63,10,'',0,0,'C');
    $pdf->Cell(64, 10,  utf8_decode('Sello'),'',0,'C');
    $pdf->Cell(63,10,'',0,0,'R');
    $pdf->Ln(5);
        
       // $pdf->Output('','Listado de clases.pdf', 1);
        
       // return $this->dispositionReporte($pdf->Output());
       // se reemplaza por:
       return $this->dispositionReporte($pdf->Output('', 'Listado de clases.pdf', 'I'));
    }


    /**
     * @Route("/app/admin/form/listado/UDBE/{programa}", name="app_admin_listado_UDBE")
     */
    public function listadoUDBEAction($programa = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formListadoUDBE($em, $programa);
        
        return $this->render('AppBundle:Reportes:listado_UDBE/index.html.twig', array(
            'form'=>$form->createView(),
            'programa'=>$programa,
            
        ));
    }
    
    private function formListadoUDBE(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reportes_UDBE'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:35%;'),                    
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:20%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:20%;'),
                ))
                ->getForm();
        return $form;
    }

    /**
     * @Route("/app/admin/reporte/listado/UDBE/", name="app_admin_reportes_UDBE")
     */
    public function reproteListadoUDBEAction(Request $request){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $lapsoid = $form['lapso'];
        $cohorteid = $form['cohorte'];
        $programaid = $form['programa'];
        $especialidadid = $form['especialidad'];
        $subsedeid = $form['subsede'];
        
        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $cohorte = $em->getRepository('AppBundle:Cohorte')->find($cohorteid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        $subsede = $em->getRepository('AppBundle:Subsede')->find($subsedeid);
        
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesInscritosByEspecialidad($cohorte, $lapso, $programa, $especialidad, $subsede);
	// ->find() ->findBy(['lapso'=>$lapso], [], Limit) ->findAll() ->findOneBy(['lapso'=>$lapso]) ->findByLapso 
        
        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN ESTUDIANTES INSCRITOS!');
            return $this->redirect($this->generateUrl('app_admin_reports_form_totales_inscritos'));
        }

        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();

        $pdf->SetWidths(array(16,22,22,12,20,20,22,56));         
        //$pdf->Cell(40,10,'Hello World!');
              
        $pdf->SetY(35);
        $pdf->titleReport('Listado de UDBE');      
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(17,10,utf8_decode('Programa: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(102,10,utf8_decode(''.$programa->getNombre()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(28,10,utf8_decode('Sede / Extensión: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(111,10,utf8_decode(''.$subsede->getDescripcion()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(14,10,utf8_decode('Cohorte: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(98,10,utf8_decode(''.$cohorte->getCodigo()),0,'L');
            $pdf->Ln(5);

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$especialidad->getNombre()),0,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(32,10,utf8_decode('Período Académico: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(38,10,utf8_decode(''.$lapso->getCodigo()),0,'L');
            $pdf->Ln(10);

        $pdf->aligns = array('C', 'L', 'L', 'C', 'C', 'C', 'C', 'L');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Apellido','Nombre', 'Sexo', 'Estado civil', 'Fecha nac.', 'Nro Telefono', 'Correo');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        $i = 1;
        $EstadoC = null;
        foreach ($entities as $value){
            $ucs = count($value->getEspeestud());
        
            foreach ($value->getEspeestud() as $v){

            switch ($v->getEstudiante()->getEstadoCivil()) {
                        case 's':
                            $EstadoC = 'Soltero(a)';
                            break;
                        case 'c':
                            $EstadoC = 'Casado(a)';
                            break;
                        case 'd':
                            $EstadoC = 'Divorciado(a)';
                            break;
                        case 'v':
                            $EstadoC = 'Viudo(a)';
                            break;    
                    }

        $sexo = $v->getEstudiante()->getSexo();
        $telefono = $v->getEstudiante()->getTelefonoMovil();

        if ($v->getEstudiante()->getTelefonoMovil() == null){
        	$telefono = $v->getEstudiante()->getTelefonoLocal();
        }
                $pdf->RowBorders(array(($v->getEstudiante()->getCedula()),
                                      strtoupper(($v->getEstudiante()->getPrimerApellido())),
                                       strtoupper(($v->getEstudiante()->getPrimerNombre())),
                                       strtoupper($sexo[0]),
                                       $EstadoC,
                                  	   ($v->getEstudiante()->getFechaNacimiento()->format('d-m-Y')),
                                  	   $telefono,
                                  	   $v->getEstudiante()->getEmail()
                                ), 1);
            $i++;
            }
        }
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(170, 6,'Total: ','T',0,'R');
        $pdf->Cell(20, 6,$ucs,'T',0,'C');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        
        //$pdf->Output('','totales_inscritos.pdf', 1);
        
            // return $this->dispositionReporte($pdf->Output());
            // Se reemplaza por:
            return $this->dispositionReporte($pdf->Output('', 'totales_inscritos.pdf', 'I'));
       
    }

    /**
     * @Route("/app/admin/reportes/listado/UDBE_2", name="app_admin_reporte_listado_UDBE")
     */
    public function totalListadoUDBEAction($programa = NULL)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formTotalListadoUDBE($em, $programa);
        
        return $this->render('AppBundle:Reportes:listado_UDBE/index2.html.twig', array(
            'form'=>$form->createView(),
            'programa'=>$programa,
        ));
    }
    
    private function formTotalListadoUDBE(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_total_listado_UDBE'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:50%;')
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:50%;'),
                ))
                ;
        return $form->getForm();
    }

     /**
     * @Route("/app/admin/reporte/listado-UDBE", name="app_admin_reporte_total_listado_UDBE")
     */

    public function ReportelistadoUDBEAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $fecha = new \DateTime();
        $fechaactual = $fecha->format('d-m-Y');
        
        $form = $request->get('form');
        $lapsoid = $form['lapso'];
        
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede= $em->getRepository('AppBundle:Sede')->findByCodigo($ids);
        
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesInscritosUDBE($lapso);

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN ESTUDIANTES INSCRITOS!');
            return $this->redirect($this->generateUrl('app_admin_reporte_listado_UDBE'));
        }

        // solicitamos el servicio 'phpexcel' y creamos el objeto vacío...
        $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();

        // ...y le asignamos una serie de propiedades
        $phpExcelObject->getProperties()
            ->setCreator("UPEL")
            ->setLastModifiedBy("UPEL")
            ->setTitle("Ofertas Academicas".$lapso)
            ->setSubject("Ofertas Academicas")
            ->setDescription("Ofertas Academicas")
            ->setKeywords("UPEL exportar excel");

        $activesheet = $phpExcelObject->getActiveSheet();
        $drawingobject = $this->get('phpexcel')->createPHPExcelWorksheetDrawing();
        $drawingobject->setName('upel.png');
        $drawingobject->setDescription('Logo');
        $drawingobject->setPath('../web/uploads/images/upel.png');
        $drawingobject->setHeight(80);
        $drawingobject->setOffsetY(30);
        $drawingobject->setCoordinates('A1');
        $drawingobject->setWorksheet($activesheet);

        // establecemos como hoja activa la primera, y le asignamos un título
        $phpExcelObject->setActiveSheetIndex(0);
        $phpExcelObject->getActiveSheet()->setTitle('Ofertas Academicas');
        
        // escribimos en distintas celdas del documento el título de los campos que vamos a exportar
        $phpExcelObject->setActiveSheetIndex(0)
            ->setCellValue('C2', 'República Bolivariana de Venezuela')
            ->setCellValue('C3', 'Universidad Pedagógica Experimental Libertador')           

            ->setCellValue('A6', 'Período: Pregrado')
            ->setCellValue('A7', 'Período: '.$lapso)
            
            ->setCellValue('A10', 'CÉDULA')
            ->setCellValue('B10', 'APELLIDOS')
            ->setCellValue('C10', 'NOMBRES')
            ->setCellValue('D10', 'SEXO')
            ->setCellValue('E10', 'ESTADO CIVIL')
            ->setCellValue('F10', 'FECHA NAC.')
            ->setCellValue('G10', 'NRO. TELEFONO')
            ->setCellValue('H10', 'CORREO')
            ->setCellValue('I10', 'ESPECIALIDAD')
            ->setCellValue('J10', 'COHORTE')
            ->setCellValue('K10', 'SEDE O EXTENSIÓN ACADÉMICA');


        // fijamos un ancho a las distintas columnas
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('A')
            ->setWidth(10);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('B')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('C')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('D')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('E')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('F')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('G')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('H')
            ->setWidth(40);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('I')
            ->setWidth(100);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('J')
            ->setWidth(10);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('K')
            ->setWidth(120);

        // recorremos los registros obtenidos de la consulta a base de datos escribiéndolos en las celdas correspondientes

        $ucs = 0;
        $row = 12;
        $i = 1;
        $estado_civ = null;
        $sexo = null;

        foreach ($entities as $v){
            $ucs = count($v->getEspeestud());
        
            foreach ($v->getEspeestud() as $value){

            switch ($value->getEstudiante()->getEstadoCivil()) {
                        case 's':
                            $estado_civ = 'Soltero(a)';
                            break;
                        case 'Soltero':
                            $estado_civ = 'Soltero(a)';
                            break;
                        case 'Soltero(a)':
                            $estado_civ = 'Soltero(a)';
                            break;
                        case 'c':
                            $estado_civ = 'Casado(a)';
                            break;
                        case 'Casado':
                            $estado_civ = 'Casado(a)';
                            break;
                        case 'Casado(a)':
                            $estado_civ = 'Casado(a)';
                            break;
                        case 'd':
                            $estado_civ = 'Divorciado(a)';
                            break;
                        case 'Divorcia':
                            $estado_civ = 'Divorciado(a)';
                            break;
                        case 'Divorciado(a)':
                            $estado_civ = 'Divorciado(a)';
                            break;
                        case 'v':
                            $estado_civ = 'Viudo(a)';
                            break;
                        case 'Viudo':
                            $estado_civ = 'Viudo(a)';
                            break;
                        case 'Viudo(a)':
                            $estado_civ = 'Viudo(a)';
                            break;
                        case 'Otro)':
                            $estado_civ = 'Otro';
                            break;    
                }

                switch ($value->getEstudiante()->getSexo()) {    
                        case 'f':
                            $sexo = 'Femenino';
                            break;
                        case 'm':
                            $sexo = 'Masculino';
                            break;
                        case 'F':
                            $sexo = 'Femenino';
                            break;
                        case 'M':
                            $sexo = 'Masculino';
                            break;
                        case 'Femenino':
                            $sexo = 'Femenino';
                            break;
                        case 'Masculino':
                            $sexo = 'Masculino';
                            break;
                }

            $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row, $value->getEstudiante()->getCedula())
                ->setCellValue('B'.$row, strtoupper($value->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getSegundoApellido()))
                ->setCellValue('C'.$row, strtoupper($value->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getSegundoNombre()))
                ->setCellValue('D'.$row, $sexo)
                ->setCellValue('E'.$row, $estado_civ)
                ->setCellValue('F'.$row, $value->getEstudiante()->getFechaNacimiento()->format('d-m-Y'))
                ->setCellValue('G'.$row, $value->getEstudiante()->getTelefonoMovil())
                ->setCellValue('H'.$row, $value->getEstudiante()->getEmail())
                ->setCellValue('I'.$row, $value->getEspecialidad())
                ->setCellValue('J'.$row, $value->getCohorte())
                ->setCellValue('K'.$row, $value->getSubsede());

            $row++;
            $ucs += 1;

            }
        }

        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'Total: '.$ucs);  

        // se crea el writer
        $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
        // se crea el response
        $response = $this->get('phpexcel')->createStreamedResponse($writer);
        // y por último se añaden las cabeceras
        $dispositionHeader = $response->headers->makeDisposition(
            ResponseHeaderBag::DISPOSITION_ATTACHMENT,
            'LISTADO UDBE.xls'
        );
        $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');
        $response->headers->set('Pragma', 'public');
        $response->headers->set('Cache-Control', 'maxage=1');
        $response->headers->set('Content-Disposition', $dispositionHeader);

        return $response;       
    }

    /**
     * @Route("/app/admin/reportes/oferta/academica", name="app_admin_reporte_oferta_academica")
     */
    public function totalOfertaAcadAction($programa = NULL)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formTotalOfertaAcad($em, $programa);
        
        return $this->render('AppBundle:Reportes:oferta_academica/index.html.twig', array(
            'form'=>$form->createView(),
            'programa'=>$programa,
        ));
    }
    
    private function formTotalOfertaAcad(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_total_oferta'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:40%;')
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:25%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:35%;'),
                ))
                ;
        return $form->getForm();
    }

     /**
     * @Route("/app/admin/reporte/oferta-academica", name="app_admin_reporte_total_oferta")
     */

    public function ReporteOfertaAcademicaAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $fecha = new \DateTime();
        $fechaactual = $fecha->format('d-m-Y');
        
        $form = $request->get('form');
        $subsedeid = $form['subsede'];
        $lapsoid = $form['lapso'];
        
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $subsede = $em->getRepository('AppBundle:SubSede')->find($subsedeid);
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede= $em->getRepository('AppBundle:Sede')->findByCodigo($ids);
        
        $entities = $em->getRepository('AppBundle:OfertAcade')->totalOfertaAcademica($lapso, $subsede);

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN OFERTAS!');
            return $this->redirect($this->generateUrl('app_admin_reporte_oferta_academica'));
        }

        // solicitamos el servicio 'phpexcel' y creamos el objeto vacío...
        $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();

        // ...y le asignamos una serie de propiedades
        $phpExcelObject->getProperties()
            ->setCreator("UPEL")
            ->setLastModifiedBy("UPEL")
            ->setTitle("Ofertas Academicas".$lapso)
            ->setSubject("Ofertas Academicas")
            ->setDescription("Ofertas Academicas")
            ->setKeywords("UPEL exportar excel");

        $activesheet = $phpExcelObject->getActiveSheet();
        $drawingobject = $this->get('phpexcel')->createPHPExcelWorksheetDrawing();
        $drawingobject->setName('upel.png');
        $drawingobject->setDescription('Logo');
        $drawingobject->setPath('../web/uploads/images/upel.png');
        $drawingobject->setHeight(80);
        $drawingobject->setOffsetY(30);
        $drawingobject->setCoordinates('A1');
        $drawingobject->setWorksheet($activesheet);

        // establecemos como hoja activa la primera, y le asignamos un título
        $phpExcelObject->setActiveSheetIndex(0);
        $phpExcelObject->getActiveSheet()->setTitle('Ofertas Academicas');
        
        // escribimos en distintas celdas del documento el título de los campos que vamos a exportar
        $phpExcelObject->setActiveSheetIndex(0)
            ->setCellValue('C2', 'República Bolivariana de Venezuela')
            ->setCellValue('C3', 'Universidad Pedagógica Experimental Libertador')           

            ->setCellValue('A6', 'Período: Pregrado')
            ->setCellValue('A7', 'Período: '.$lapso)
            ->setCellValue('A8', 'Sede/Extensión: ' .$subsede)
            
            ->setCellValue('A10', 'UNIDAD CURRICULAR')
            ->setCellValue('B10', 'ESPECIALIDAD')
            ->setCellValue('C10', 'SECCIÓN')
            ->setCellValue('D10', 'CUPOS')
            ->setCellValue('E10', 'INSCRITOS')
            ->setCellValue('F10', 'HORARIO')
            ->setCellValue('G10', 'AMBIENTE')
            ->setCellValue('H10', 'PROFESOR')
            ->setCellValue('I10', 'COHORTE');


        // fijamos un ancho a las distintas columnas
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('A')
            ->setWidth(60);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('B')
            ->setWidth(60);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('C')
            ->setWidth(10);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('D')
            ->setWidth(10);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('E')
            ->setWidth(10);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('F')
            ->setWidth(45);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('G')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('H')
            ->setWidth(30);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('I')
            ->setWidth(10);

        // recorremos los registros obtenidos de la consulta a base de datos escribiéndolos en las celdas correspondientes

        $ucs = 0;
        $row = 12;

        foreach ($entities as $v){

            $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row, $v->getCurso()->getNombre())
                ->setCellValue('B'.$row, $v->getEspecialidad())
                ->setCellValue('C'.$row, $v->getSeccion())
                ->setCellValue('D'.$row, $v->getCantidadCupos())
                ->setCellValue('E'.$row, $v->getCantidadAlumnos())
                ->setCellValue('F'.$row, $v->getHorario())
                ->setCellValue('G'.$row, $v->getAmbiente())
                ->setCellValue('H'.$row, strtoupper($v->getProfesor()))
                ->setCellValue('I'.$row, strtoupper($v->getCohorte()));

            $row++;
            $ucs += 1;
        }

        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'Total de ofertas académicass: '.$ucs);  

        // se crea el writer
        $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
        // se crea el response
        $response = $this->get('phpexcel')->createStreamedResponse($writer);
        // y por último se añaden las cabeceras
        $dispositionHeader = $response->headers->makeDisposition(
            ResponseHeaderBag::DISPOSITION_ATTACHMENT,
            'OFERTAS ACADEMICAS.xls'
        );
        $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');
        $response->headers->set('Pragma', 'public');
        $response->headers->set('Cache-Control', 'maxage=1');
        $response->headers->set('Content-Disposition', $dispositionHeader);

        return $response;       
    }

    /**
     * @Route("/app/admin/reports/form/listado/pre/inscritos", name="app_admin_reports_form_listado_pre_inscritos")
     */
    public function ListadoPreInscritosFormAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formListadoPreInscritos($em);
        
        return $this->render('AppBundle:Reportes:listado_pre_inscritos/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formListadoPreInscritos(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_listado_pre_inscritos'))
                ->setMethod('POST')
                ->setAttributes(array('attr'=>array('target'=>'_blank')))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em
                ))
        ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Período Académico .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extensión Académica.:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                ))
                ;
        return $form->getForm();
    }
    
    /**
     * @Route("/app/admin/reportes/listado/pre/inscritos", name="app_admin_reporte_listado_pre_inscritos")
     */
    public function reporteListadoPreInscritosAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $programaid =  $form['programa'];
        $lapsoid = $form['lapso'];
        $subsedeid = $form['subsede'];
        $cohorteid = $form['cohorte'];

        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $subsede = $em->getRepository('AppBundle:SubSede')->find($subsedeid);
        $cohorte = $em->getRepository('AppBundle:Cohorte')->find($cohorteid);
        
        $entities = $em->getRepository('AppBundle:EspeEstud')->getEstudiantesPreInscritos($cohorte, $lapso, $subsede);

        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-error', 'NO SE ENCUENTRAN ESTUDIANTES PRE-INSCRITOS!');
            return $this->redirect($this->generateUrl('app_admin_reports_form_listado_pre_inscritos'));
        }
        
        // solicitamos el servicio 'phpexcel' y creamos el objeto vacío...
        $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();

        // ...y le asignamos una serie de propiedades
        $phpExcelObject->getProperties()
            ->setCreator("UPEL")
            ->setLastModifiedBy("UPEL")
            ->setTitle("Listado Pre-Inscritos".$cohorte)
            ->setSubject("Listado")
            ->setDescription("Listado de pre-inscritos")
            ->setKeywords("UPEL exportar excel");

        $activesheet = $phpExcelObject->getActiveSheet();
        $drawingobject = $this->get('phpexcel')->createPHPExcelWorksheetDrawing();
        $drawingobject->setName('upel.png');
        $drawingobject->setDescription('Logo');
        $drawingobject->setPath('../web/uploads/images/upel.png');
        $drawingobject->setHeight(80);
        $drawingobject->setOffsetY(30);
        $drawingobject->setCoordinates('A1');
        $drawingobject->setWorksheet($activesheet);

        // establecemos como hoja activa la primera, y le asignamos un título
        $phpExcelObject->setActiveSheetIndex(0);
        $phpExcelObject->getActiveSheet()->setTitle('Listado Pre-Inscritos');
        
        // escribimos en distintas celdas del documento el título de los campos que vamos a exportar
        $phpExcelObject->setActiveSheetIndex(0)
            ->setCellValue('B2', 'República Bolivariana de Venezuela')
            ->setCellValue('B3', 'Universidad Pedagógica Experimental Libertador')

            ->setCellValue('A6', 'Período: '.$programa)
            ->setCellValue('A8', 'Sede/ Extensión: '.$subsede)
            
            ->setCellValue('A10', 'CÉDULA')
            ->setCellValue('B10', 'NOMBRES')
            ->setCellValue('C10', 'APELLIDOS')
            ->setCellValue('D10', 'NACIONALIDAD')
            ->setCellValue('E10', 'FECHA DE NAC.')
            ->setCellValue('F10', 'GENERO')
            ->setCellValue('G10', 'ESTADO CIVIL')
            ->setCellValue('H10', 'CELULAR')
            ->setCellValue('I10', 'TELEFONO')
            ->setCellValue('J10', 'DIRECCIÓN')
            ->setCellValue('K10', 'CORREO')
            ->setCellValue('L10', 'DISCAPACIDAD')
            ->setCellValue('M10', 'ETNIA')
            ->setCellValue('N10', 'PAIS')
            ->setCellValue('O10', 'ESTADO')
            ->setCellValue('P10', 'CIUDAD')
            ->setCellValue('Q10', 'MUNICIPIO')
            ->setCellValue('R10', 'TIPO DE ESTUDIANTE')
            ->setCellValue('S10', 'TIPO DE BECA')
            ->setCellValue('T10', 'RUSNIES')
            ->setCellValue('U10', 'PLANTEL GRADUADO')
            ->setCellValue('V10', 'CLASIF. DEL PLANTEL')
            ->setCellValue('W10', 'ESPECIALIDAD')
            ->setCellValue('X10', 'TIPO DE INGRESO')
            ->setCellValue('Y10', 'COHORTE')
            ->setCellValue('Z10', 'LAPSO');


        // fijamos un ancho a las distintas columnas
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('A')
            ->setWidth(17);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('B')
            ->setWidth(35);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('C')
            ->setWidth(35);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('D')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('E')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('F')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('G')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('H')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('I')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('J')
            ->setWidth(100);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('K')
            ->setWidth(35);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('L')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('M')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('N')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('O')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('P')
            ->setWidth(25);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('Q')
            ->setWidth(25);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('R')
            ->setWidth(25);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('S')
            ->setWidth(25);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('T')
            ->setWidth(15);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('U')
            ->setWidth(50);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('V')
            ->setWidth(25);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('W')
            ->setWidth(40);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('X')
            ->setWidth(20);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('Y')
            ->setWidth(12);
        $phpExcelObject->setActiveSheetIndex(0)
            ->getColumnDimension('Z')
            ->setWidth(12);

        // recorremos los registros obtenidos de la consulta a base de datos escribiéndolos en las celdas correspondientes

        $ucs = 0;
        $uca = 0;
        $row = 12;
        $FechaInclusion = null;

        foreach ($entities as $value){

            $sexo = 'Vacio';
            $beca = 'Vacio';

            $estudiante = $value->getId();

            $estud = $em->getRepository('AppBundle:Espeestud')->findOneBy(array('estudiante'=>$estudiante));
        
            $FechaNac = $value->getFechaNacimiento()->format('d-m-Y');
            $FecIng = $estud->getFechaIngreso()->format('d-m-Y');

            switch ($value->getBeca()) {
                        case '0':
                            $beca = 'No Posee Beca';
                            break;
                        case '1':
                            $beca = 'Becado por la Institución';
                            break;
                        case '2':
                            $beca = 'Becado por la Alcaldía o Gobernación';
                            break;
                        case '3':
                            $beca = 'Por un Ministerio';
                            break;
                        case '4':
                            $beca = 'Por Fundayacucho';
                            break;
                        case '5':
                            $beca = 'Por un Ente Privado';
                            break;
                        case '6':
                            $beca = 'Por la Opsu';
                            break;
                    }
            switch ($value->getClasifPlantel()) {
                        case '1':
                            $CPlantel = 'Público';
                            break;
                        case '2':
                            $CPlantel = 'Privado';
                            break;
                        case '3':
                            $CPlantel = 'Mixto';
                            break;
                    }
            switch ($value->getSexo()) {
                        case 'f':
                            $sexo = 'Femenino';
                            break;
                        case 'm':
                            $sexo = 'Masculino';
                            break;
                        case 'F':
                            $sexo = 'Femenino';
                            break;
                        case 'M':
                            $sexo = 'Masculino';
                            break;
                        case 'Femenino':
                            $sexo = 'Femenino';
                            break;
                        case 'Masculino':
                            $sexo = 'Masculino';
                            break;
                    }
            switch ($value->getEstadoCivil()) {
                        case 's':
                            $estado_civ = 'Soltero(a)';
                            break;
                        case 'Soltero':
                            $estado_civ = 'Soltero(a)';
                            break;
                        case 'Soltero(a)':
                            $estado_civ = 'Soltero(a)';
                            break;
                        case 'c':
                            $estado_civ = 'Casado(a)';
                            break;
                        case 'Casado':
                            $estado_civ = 'Casado(a)';
                            break;
                        case 'Casado(a)':
                            $estado_civ = 'Casado(a)';
                            break;
                        case 'd':
                            $estado_civ = 'Divorciado(a)';
                            break;
                        case 'Divorcia':
                            $estado_civ = 'Divorciado(a)';
                            break;
                        case 'Divorciado(a)':
                            $estado_civ = 'Divorciado(a)';
                            break;
                        case 'v':
                            $estado_civ = 'Viudo(a)';
                            break;
                        case 'Viudo':
                            $estado_civ = 'Viudo(a)';
                            break;
                        case 'Viudo(a)':
                            $estado_civ = 'Viudo(a)';
                            break;
                        case 'Otro)':
                            $estado_civ = 'Otro';
                            break;
                    }
            switch ($value->getNivelEconomico()) {
                        case '1':
                            $Niv_Eco = 'Ingresos mensuales inferiores a 40.000 Bs';
                            break;
                        case '2':
                            $Niv_Eco = 'Ingresos mensuales entre 40.000 y 80.000 Bs';
                            break;
                        case '3':
                            $Niv_Eco = 'Ingresos mensuales entre 80.000 y 130.000 Bs';
                            break;
                        case '4':
                            $Niv_Eco = 'Ingresos mensuales entre 130.000 y 180.000 Bs';
                            break;
                        case '5':
                            $Niv_Eco = 'Ingresos mensaules superiores a 180.000 Bs';
                            break;
                    }

            if(!$sexo){
                $sexo = 'Vacio';
            }

            if(!$beca){
                $beca = 'Vacio';
            }

            $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row, $value->getCedula())
                ->setCellValue('B'.$row, strtoupper($value->getPrimerNombre().' '.$value->getSegundoNombre()))
                ->setCellValue('C'.$row, strtoupper($value->getPrimerApellido().' '.$value->getSegundoApellido()))
                ->setCellValue('D'.$row, $value->getNacionalidad())
                ->setCellValue('E'.$row, $FechaNac)
                ->setCellValue('F'.$row, $sexo)
                ->setCellValue('G'.$row, $estado_civ)
                ->setCellValue('H'.$row, $value->getTelefonoMovil())
                ->setCellValue('I'.$row, $value->getTelefonoLocal())
                ->setCellValue('J'.$row, $value->getDireccion())
                ->setCellValue('K'.$row, $value->getEmail())
                ->setCellValue('L'.$row, $value->getDiscapacidad())
                ->setCellValue('M'.$row, $value->getEtnia())
                ->setCellValue('N'.$row, $value->getPais())
                ->setCellValue('O'.$row, $value->getEstado())
                ->setCellValue('P'.$row, $value->getCiudad())
                ->setCellValue('Q'.$row, $value->getMunicipio())
                ->setCellValue('R'.$row, $value->getTipoestudiante())
                ->setCellValue('S'.$row, $beca)
                ->setCellValue('T'.$row, $value->getNumRusnies())
                ->setCellValue('U'.$row, $value->getPlantelGraduado())
                ->setCellValue('V'.$row, $CPlantel)
                ->setCellValue('W'.$row, $estud->getEspecialidad()->getNombre())
                ->setCellValue('X'.$row, $estud->getIngreso())
                ->setCellValue('Y'.$row, $estud->getCohorte())
                ->setCellValue('Z'.$row, $estud->getCodLapso());

            $row++;


        $ucs += '1';
        $uca = 0;
        }
        $row++;

        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'FECHA DE NAC.: FECHA DE NACIMIENTO');
        $phpExcelObject->setActiveSheetIndex(0)
                ->setCellValue('A'.$row,'CLASIF. DEL PLANTEL: CLASIFICACIÓN DEL PLANTEL');$row++;
                
                

        // se crea el writer
        $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
        // se crea el response
        $response = $this->get('phpexcel')->createStreamedResponse($writer);
        // y por último se añaden las cabeceras
        $dispositionHeader = $response->headers->makeDisposition(
            ResponseHeaderBag::DISPOSITION_ATTACHMENT,
            'LISTADO.xls'
        );
        $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');
        $response->headers->set('Pragma', 'public');
        $response->headers->set('Cache-Control', 'maxage=1');
        $response->headers->set('Content-Disposition', $dispositionHeader);

        return $response;
        
    }

}
