<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AuditoriaEspe
 *
 * @ORM\Table(name="auditoria_espe")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\AuditoriaEspeRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class AuditoriaEspe
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Usuarios", inversedBy="auditoria_espe")

     * @ORM\JoinColumn(name="usuario_id", referencedColumnName="id")
     */
    private $usuarios;

    /**

     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="auditoria_espe")

     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")

     */
    private $estudiante;

    /**

     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="auditoria_espe")

     * @ORM\JoinColumn(name="especialidadini_id", referencedColumnName="id")

     */
    private $especialidadIni;

    /**

     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="auditoria_espe")

     * @ORM\JoinColumn(name="especialidadactual_id", referencedColumnName="id")

     */
    private $especialidadActual;

    /**

     * @ORM\ManyToOne(targetEntity="Cohorte", inversedBy="auditoria_espe")

     * @ORM\JoinColumn(name="cohorte_id", referencedColumnName="id")

     */
    private $cohorte;

    /**

     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="auditoria_espe")

     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")

     */
    private $lapso;

    /**

     * @ORM\ManyToOne(targetEntity="TipoIngreso", inversedBy="auditoria_espe")

     * @ORM\JoinColumn(name="ingreso_id", referencedColumnName="id")

     */
    private $ingreso;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fecha_hora", type="datetime")
     */
    private $fechaHora;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set usuarios
     *
     * @param AppBundle\Entity\Usuarios $usuarios
     *
     * @return AuditoriaEspe
     */
    public function setUsuarios(\AppBundle\Entity\Usuarios $usuarios)
    {
        $this->usuarios = $usuarios;

        return $this;
    }

    /**
     * Get usuarios
     *
     * @return AppBundle\Entity\Usuarios
     */
    public function getUsuarios()
    {
        return $this->usuarios;
    }

    /**
     * Set estudiante
     *
     * @param integer $estudiante
     *
     * @return AuditoriaEspe
     */
    public function setEstudiante($estudiante)
    {
        $this->estudiante = $estudiante;

        return $this;
    }

    /**
     * Get estudiante
     *
     * @return integer
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set especialidadIni
     *
     * @param integer $especialidadIni
     *
     * @return AuditoriaEspe
     */
    public function setEspecialidadIni($especialidadIni)
    {
        $this->especialidadIni = $especialidadIni;

        return $this;
    }

    /**
     * Get especialidadIni
     *
     * @return integer
     */
    public function getEspecialidadIni()
    {
        return $this->especialidadIni;
    }

    /**
     * Set especialidadActual
     *
     * @param integer $especialidadActual
     *
     * @return AuditoriaEspe
     */
    public function setEspecialidadActual($especialidadActual)
    {
        $this->especialidadActual = $especialidadActual;

        return $this;
    }

    /**
     * Get especialidadActual
     *
     * @return integer
     */
    public function getEspecialidadActual()
    {
        return $this->especialidadActual;
    }

    /**
     * Set cohorte
     *
     * @param integer $cohorte
     *
     * @return AuditoriaEspe
     */
    public function setCohorte($cohorte)
    {
        $this->cohorte = $cohorte;

        return $this;
    }

    /**
     * Get cohorte
     *
     * @return integer
     */
    public function getCohorte()
    {
        return $this->cohorte;
    }

    /**
     * Set lapso
     *
     * @param integer $lapso
     *
     * @return AuditoriaEspe
     */
    public function setLapso($lapso)
    {
        $this->lapso = $lapso;

        return $this;
    }

    /**
     * Get lapso
     *
     * @return integer
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set ingreso
     *
     * @param integer $ingreso
     *
     * @return AuditoriaEspe
     */
    public function setIngreso($ingreso)
    {
        $this->ingreso = $ingreso;

        return $this;
    }

    /**
     * Get ingreso
     *
     * @return integer
     */
    public function getIngreso()
    {
        return $this->ingreso;
    }

    /**
     *  @param \DateTime $fechaHora
     *
     * @return AuditoriaEspe
     */
    public function setFechaHora($fechaHora)
    {
        $this->fechaHora = $fechaHora;
    }

    /**
     * Get fechaHora
     *
     * @return \DateTime
     */
    public function getFechaHora()
    {
        return $this->fechaHora;
    }
}

