<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AuditoriaNotas
 *
 * @ORM\Table(name="auditoria_notas")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\AuditoriaNotasRepository")
 */
class AuditoriaNotas
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="auditoria_notas")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    private $estudiante;

    /**
     * @ORM\ManyToOne(targetEntity="Matricula", inversedBy="auditoria_notas")
     * @ORM\JoinColumn(name="matricula_id", referencedColumnName="id")
     */
    private $matricula;

    /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="auditoria_notas")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    private $especialidad;

    /**
     * @ORM\ManyToOne(targetEntity="Cursos", inversedBy="auditoria_notas")
     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")
     */
    private $curso;

    /**
     * @ORM\ManyToOne(targetEntity="CondCurso", inversedBy="auditoria_notas")
     * @ORM\JoinColumn(name="condicion_id", referencedColumnName="id")
     */
    protected $condicion;

    /**
     * @var string
     *
     * @ORM\Column(name="seccion", type="string", length=11)
     */
    private $seccion;

    /**
     * @ORM\ManyToOne(targetEntity="Profesor", inversedBy="auditoria_notas")
     * @ORM\JoinColumn(name="profesor_id", referencedColumnName="id")
     */
    private $profesor;

    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="auditoria_notas")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    private $lapso;

    /**
     * @var integer
     *
     * @ORM\Column(name="nota", type="integer")
     */
    private $nota;

    /**
     * @var string
     *
     * @ORM\Column(name="proceso", type="string", length=50)
     */
    private $proceso;

    /**
     * @var integer
     *
     * @ORM\Column(name="nota_actual", type="integer")
     */
    private $notaActual;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fecha_hora", type="datetime")
     */
    private $fechaHora;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set estudiante
     *
     * @param string $estudiante
     *
     * @return AuditoriaNotas
     */
    public function setEstudiante($estudiante)
    {
        $this->estudiante = $estudiante;

        return $this;
    }

    /**
     * Get estudiante
     *
     * @return string
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set matricula
     *
     * @param string $matricula
     *
     * @return AuditoriaNotas
     */
    public function setMatricula($matricula)
    {
        $this->matricula = $matricula;

        return $this;
    }

    /**
     * Get matricula
     *
     * @return string
     */
    public function getMatricula()
    {
        return $this->matricula;
    }

    /**
     * Set especialidad
     *
     * @param string $especialidad
     *
     * @return AuditoriaNotas
     */
    public function setEspecialidad($especialidad)
    {
        $this->especialidad = $especialidad;

        return $this;
    }

    /**
     * Get especialidad
     *
     * @return string
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }

    /**
     * Set cursos
     *
     * @param string $curso
     *
     * @return AuditoriaNotas
     */
    public function setCurso($curso)
    {
        $this->curso = $curso;

        return $this;
    }

    /**
     * Get cursos
     *
     * @return string
     */
    public function getCurso()
    {
        return $this->curso;
    }

    /**
     * Set condicion
     *
     * @param string $condicion
     *
     * @return Auditoria
     */
    public function setCondicion($condicion)
    {
        $this->condicion = $condicion;
    
        return $this;
    }

    /**
     * Get condicion
     *
     * @return string
     */
    public function getCondicion()
    {
        return $this->condicion;
    }

    /**
     * Set seccion
     *
     * @param string $seccion
     *
     * @return AuditoriaNotas
     */
    public function setSeccion($seccion)
    {
        $this->seccion = $seccion;

        return $this;
    }

    /**
     * Get seccion
     *
     * @return string
     */
    public function getSeccion()
    {
        return $this->seccion;
    }

    /**
     * Set profesor
     *
     * @param AppBundle\Entity\Profesor $profesor
     *
     * @return AuditoriaNotas
     */
    public function setProfesor(\AppBundle\Entity\Profesor $profesor = null)
    {
        $this->profesor = $profesor;

        return $this;
    }

    /**
     * Get profesor
     *
     * @return AppBundle\Entity\Profesor
     */
    public function getProfesor()
    {
        return $this->profesor;
    }

    /**
     * Set lapso
     *
     * @param string $lapso
     *
     * @return AuditoriaNotas
     */
    public function setLapso($lapso)
    {
        $this->lapso = $lapso;

        return $this;
    }

    /**
     * Get lapso
     *
     * @return string
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set nota
     *
     * @param integer $nota
     *
     * @return AuditoriaNotas
     */
    public function setNota($nota)
    {
        $this->nota = $nota;

        return $this;
    }

    /**
     * Get nota
     *
     * @return integer
     */
    public function getNota()
    {
        return $this->nota;
    }

    /**
     * Set proceso
     *
     * @param string $proceso
     *
     * @return AuditoriaNotas
     */
    public function setProceso($proceso)
    {
        $this->proceso = $proceso;

        return $this;
    }

    /**
     * Get proceso
     *
     * @return string
     */
    public function getProceso()
    {
        return $this->proceso;
    }

    /**
     * Set notaAtual
     *
     * @param integer $notaActual
     *
     * @return AuditoriaNotas
     */
    public function setNotaActual($notaActual)
    {
        $this->notaActual = $notaActual;

        return $this;
    }

    /**
     * Get notaActual
     *
     * @return integer
     */
    public function getNotaActual()
    {
        return $this->notaActual;
    }

    /**
     * Set fecha_hora
     *
     * @param \DateTime $fechaHora
     *
     * @return AuditoriaNotas
     */
    public function setFechaHora($fechaHora)
    {
        $this->fechaHora = $fechaHora;

        return $this;
    }

    /**
     * Get fecha_hora
     *
     * @return \DateTime
     */
    public function getFechaHora()
    {
        return $this->fechaHora;
    }
}

