<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="bloque_horas")
 * @ORM\Entity()
 */
class BloqueHoras {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=2)
     */
    protected $codigo;
      
    /**
     * @ORM\Column(type="string", length=8)
     */
    protected $desde;
    
    /**
     * @ORM\Column(type="string", length=8)
     */
    protected $hasta;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $vigente;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="hora")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
   

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return BloqueHoras
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set desde
     *
     * @param string $desde
     * @return BloqueHoras
     */
    public function setDesde($desde)
    {
        $this->desde = $desde;
    
        return $this;
    }

    /**
     * Get desde
     *
     * @return string 
     */
    public function getDesde()
    {
        return $this->desde;
    }

    /**
     * Set hasta
     *
     * @param string $hasta
     * @return BloqueHoras
     */
    public function setHasta($hasta)
    {
        $this->hasta = $hasta;
    
        return $this;
    }

    /**
     * Get hasta
     *
     * @return string 
     */
    public function getHasta()
    {
        return $this->hasta;
    }

    /**
     * Set vigente
     *
     * @param boolean $vigente
     * @return BloqueHoras
     */
    public function setVigente($vigente)
    {
        $this->vigente = $vigente;
    
        return $this;
    }

    /**
     * Get vigente
     *
     * @return boolean 
     */
    public function getVigente()
    {
        return $this->vigente;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     * @return BloqueHoras
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }
}
