<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="config_sistema")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ConfigSistemaRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class ConfigSistema {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer", nullable=false)
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Programa", inversedBy="config")
     * @ORM\JoinColumn(name="programa_id", referencedColumnName="id")
     */
    protected $programa;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $controlpago;
    
    /**
     * @ORM\Column(type="float", scale=2)
     */
    protected $cuota1;
    
    /**
     * @ORM\Column(type="float", scale=2)
     */    
    protected $cuota2;
    
    /**
     * @ORM\Column(type="float", scale=2)
     */
    protected $cuota3;
    
    /**
     * @ORM\Column(type="float", scale=2)
     */
    protected $montouc;
    
    /**
     * @ORM\Column(type="float", scale=2)
     */
    protected $porcentajeuc;
    
    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $uc_min;
    
    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $uc_max;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $choque;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="configsistema")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;

    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="configsistema")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set controlpago
     *
     * @param boolean $controlpago
     * @return ConfigSistema
     */
    public function setControlpago($controlpago)
    {
        $this->controlpago = $controlpago;
    
        return $this;
    }

    /**
     * Get controlpago
     *
     * @return boolean 
     */
    public function getControlpago()
    {
        return $this->controlpago;
    }

    /**
     * Set montouc
     *
     * @param \float $montouc
     * @return ConfigSistema
     */
    public function setMontouc($montouc)
    {
        $this->montouc = $montouc;
    
        return $this;
    }

    /**
     * Get montouc
     *
     * @return \float 
     */
    public function getMontouc()
    {
        return $this->montouc;
    }

    /**
     * Set porcentajeuc
     *
     * @param \float $porcentajeuc
     * @return ConfigSistema
     */
    public function setPorcentajeuc($porcentajeuc)
    {
        $this->porcentajeuc = $porcentajeuc;
    
        return $this;
    }

    /**
     * Get porcentajeuc
     *
     * @return \float 
     */
    public function getPorcentajeuc()
    {
        return $this->porcentajeuc;
    }

    /**
     * Set uc_min
     *
     * @param integer $ucMin
     * @return ConfigSistema
     */
    public function setUcMin($ucMin)
    {
        $this->uc_min = $ucMin;
    
        return $this;
    }

    /**
     * Get uc_min
     *
     * @return integer 
     */
    public function getUcMin()
    {
        return $this->uc_min;
    }

    /**
     * Set uc_max
     *
     * @param integer $ucMax
     * @return ConfigSistema
     */
    public function setUcMax($ucMax)
    {
        $this->uc_max = $ucMax;
    
        return $this;
    }

    /**
     * Get uc_max
     *
     * @return integer 
     */
    public function getUcMax()
    {
        return $this->uc_max;
    }

    /**
     * Set programa
     *
     * @param \AppBundle\Entity\Programa $programa
     * @return ConfigSistema
     */
    public function setPrograma(\AppBundle\Entity\Programa $programa = null)
    {
        $this->programa = $programa;
    
        return $this;
    }

    /**
     * Get programa
     *
     * @return \AppBundle\Entity\Programa 
     */
    public function getPrograma()
    {
        return $this->programa;
    }

    /**
     * Set choque
     *
     * @param boolean $choque
     * @return ConfigSistema
     */
    public function setChoque($choque)
    {
        $this->choque = $choque;
    
        return $this;
    }

    /**
     * Get choque
     *
     * @return boolean 
     */
    public function getChoque()
    {
        return $this->choque;
    }

    /**
     * Set cuota1
     *
     * @param float $cuota1
     * @return ConfigSistema
     */
    public function setCuota1($cuota1)
    {
        $this->cuota1 = $cuota1;
    
        return $this;
    }

    /**
     * Get cuota1
     *
     * @return float 
     */
    public function getCuota1()
    {
        return $this->cuota1;
    }

    /**
     * Set cuota2
     *
     * @param float $cuota2
     * @return ConfigSistema
     */
    public function setCuota2($cuota2)
    {
        $this->cuota2 = $cuota2;
    
        return $this;
    }

    /**
     * Get cuota2
     *
     * @return float 
     */
    public function getCuota2()
    {
        return $this->cuota2;
    }

    /**
     * Set cuota3
     *
     * @param float $cuota3
     * @return ConfigSistema
     */
    public function setCuota3($cuota3)
    {
        $this->cuota3 = $cuota3;
    
        return $this;
    }

    /**
     * Get cuota3
     *
     * @return float 
     */
    public function getCuota3()
    {
        return $this->cuota3;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     *
     * @return ConfigSistema
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;

        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return ConfigSistema
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
