<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;


/**
 * Description of ControlPagos
 *
 * @author jose
 */

/**
 * @ORM\Table(name="control_pagos")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ControlPagosRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class ControlPagos {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="controlpagos")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;
    
    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="controlpagos")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $cuota;
    /**
     * @ORM\Column(type="float", scale=2)
     */
    protected $monto;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $pagado;
    
    /**
     * @ORM\Column(type="datetime")
     */
    protected $fecha_pago;
        /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="controlpagos")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;

    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="controlpagos")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;
    
    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set cuota
     *
     * @param string $cuota
     * @return ControlPagos
     */
    public function setCuota($cuota)
    {
        $this->cuota = $cuota;
    
        return $this;
    }

    /**
     * Get cuota
     *
     * @return string 
     */
    public function getCuota()
    {
        return $this->cuota;
    }

    /**
     * Set monto
     *
     * @param float $monto
     * @return ControlPagos
     */
    public function setMonto($monto)
    {
        $this->monto = $monto;
    
        return $this;
    }

    /**
     * Get monto
     *
     * @return float 
     */
    public function getMonto()
    {
        return $this->monto;
    }

    /**
     * Set pagado
     *
     * @param boolean $pagado
     * @return ControlPagos
     */
    public function setPagado($pagado)
    {
        $this->pagado = $pagado;
    
        return $this;
    }

    /**
     * Get pagado
     *
     * @return boolean 
     */
    public function getPagado()
    {
        return $this->pagado;
    }

    /**
     * Set fecha_pago
     *
     * @param \DateTime $fechaPago
     * @return ControlPagos
     */
    public function setFechaPago($fechaPago)
    {
        $this->fecha_pago = $fechaPago;
    
        return $this;
    }

    /**
     * Get fecha_pago
     *
     * @return \DateTime 
     */
    public function getFechaPago()
    {
        return $this->fecha_pago;
    }

    /**
     * Set estudiante
     *
     * @param \AppBundle\Entity\EspeEstud $estudiante
     * @return ControlPagos
     */
    public function setEstudiante(\AppBundle\Entity\EspeEstud $estudiante = null)
    {
        $this->estudiante = $estudiante;
    
        return $this;
    }

    /**
     * Get estudiante
     *
     * @return \AppBundle\Entity\EspeEstud 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set lapso
     *
     * @param \AppBundle\Entity\Lapso $lapso
     * @return ControlPagos
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return \AppBundle\Entity\Lapso 
     */
    public function getLapso()
    {
        return $this->lapso;
    }
    
    /**
     * @ORM\PrePersist()
     */
    public function setValueAt()
    {
        $this->fecha_pago = new \DateTime();
        $this->setPagado(0);
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     *
     * @return ControlPagos
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;

        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return ControlPagos
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
