<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="cursos_especiales")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\CursosEspecialesRepository")
 */
class CursosEspeciales {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Cursos", inversedBy="cursoespecial")
     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")
     */
    protected $curso;
    
    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $uc;
    
    /**
     * @ORM\ManyToOne(targetEntity="ModoTranscripcion", inversedBy="cursoespecial")
     * @ORM\JoinColumn(name="modotranscripcion_id", referencedColumnName="id")
     */
    protected $modo_transcripcion;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set uc
     *
     * @param integer $uc
     * @return CursosEspeciales
     */
    public function setUc($uc)
    {
        $this->uc = $uc;
    
        return $this;
    }

    /**
     * Get uc
     *
     * @return integer 
     */
    public function getUc()
    {
        return $this->uc;
    }

    /**
     * Set curso
     *
     * @param AppBundle\Entity\Cursos $curso
     * @return CursosEspeciales
     */
    public function setCurso(\AppBundle\Entity\Cursos $curso = null)
    {
        $this->curso = $curso;
    
        return $this;
    }

    /**
     * Get curso
     *
     * @return AppBundle\Entity\Cursos 
     */
    public function getCurso()
    {
        return $this->curso;
    }

    /**
     * Set modo_transcripcion
     *
     * @param AppBundle\Entity\ModoTranscripcion $modoTranscripcion
     * @return CursosEspeciales
     */
    public function setModoTranscripcion(\AppBundle\Entity\ModoTranscripcion $modoTranscripcion = null)
    {
        $this->modo_transcripcion = $modoTranscripcion;
    
        return $this;
    }

    /**
     * Get modo_transcripcion
     *
     * @return AppBundle\Entity\ModoTranscripcion 
     */
    public function getModoTranscripcion()
    {
        return $this->modo_transcripcion;
    }
}
